/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class ByteArrayStreamSrc
implements ILocalStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final byte[] data;
    public final int offset;
    public final int length;

    public ByteArrayStreamSrc(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayStreamSrc(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.offset = n;
        this.length = n2;
    }

    @Override
    public ByteBuffer getLocalData() {
        return ByteBuffer.wrap(this.data, this.offset, this.length);
    }

    @Override
    public InputStream open(int n) throws IOException {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }

    @Override
    public long getSize(int n) throws IOException {
        return this.length;
    }

    @Override
    public long getModTime() {
        return 0L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void transferData(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, this.offset, this.length);
    }

    @Override
    public IStreamSrc refilter(IStreamSrc iStreamSrc) {
        return iStreamSrc;
    }
}

