/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.JNIException;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.util.KeyGenerator;
import thunderheadeng.util.Keyable;

public class NativeManager
extends ABufferedNativeStream {
    protected long d_peerObj;
    private static final byte COMMAND_CREATE_OBJECT = 0;
    private static final byte COMMAND_DELETE_OBJECT = 1;
    private static final byte COMMAND_UPDATE_OBJECT = 2;
    private static final byte COMMAND_EXEC_METHOD = 3;
    private static final byte COMMAND_EXEC_STATIC_METHOD = 4;
    private static final byte COMMAND_CONNECT_PEERS = 5;
    private static final byte COMMAND_STATUS_COMPLETE = 0;
    private static final byte COMMAND_STATUS_INCOMPLETE = 1;
    private int d_numCommands = 0;
    private byte d_commandStatus = 1;
    private int d_lastCommandPosition = 0;
    private int d_firstCommandLengthB = 0;
    private int d_lastCommandLengthB = 0;
    private final Map<Class<? extends INativeObject>, Integer> d_classKeyMap = new HashMap<Class<? extends INativeObject>, Integer>();
    private final Map<Integer, Class<? extends INativeObject>> d_keyClassMap = new HashMap<Integer, Class<? extends INativeObject>>();
    private int d_classKeyIt = 0;
    private KeyGenerator d_keyGenerator = new KeyGenerator();
    private int d_numFlushes = 0;
    private final ExecutorService d_executor = Executors.newSingleThreadExecutor();
    private static final Map<Integer, Constructor<? extends Keyable>> s_nativeConstructors = new HashMap<Integer, Constructor<? extends Keyable>>();

    private native void registerClassKey(String var1, int var2);

    private final native void dispatch(ByteBuffer var1, ByteBuffer var2, int var3, byte var4, int var5, int var6) throws JNIException;

    public NativeManager() {
        this(0x100000, 0x100000);
    }

    public NativeManager(int n, int n2) {
        super(n, n2);
    }

    public KeyGenerator getKeyGenerator() {
        return this.d_keyGenerator;
    }

    private Class<? extends INativeObject> getClassForKey(int n) {
        return this.d_keyClassMap.get(n);
    }

    public ExecutorService getDispatchExecutor() {
        return this.d_executor;
    }

    private static int sRegisterClass(Class<? extends INativeObject> clazz) {
        return Native.manager.registerClass(clazz);
    }

    private int registerClass(Class<? extends INativeObject> clazz) {
        Integer n = this.d_classKeyMap.get(clazz);
        if (n != null) {
            return n;
        }
        int n2 = this.d_classKeyIt++;
        this.d_classKeyMap.put(clazz, n2);
        this.d_keyClassMap.put(n2, clazz);
        this.registerClassKey(clazz.getCanonicalName(), n2);
        return n2;
    }

    private final void beginCommand(byte by) {
        this.lockWriteBuffer();
        this.writeByte(by);
        this.d_lastCommandPosition = this.getWritePosition() - 1;
        this.d_commandStatus = 1;
        ++this.d_numCommands;
    }

    private final void endCommand() {
        this.d_commandStatus = 0;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        }
        this.markStrongRefsFinished();
        this.unlockWriteBuffer();
    }

    @Override
    public void lockWriteBuffer() {
        this.d_keyGenerator.beginReserveKeys();
        super.lockWriteBuffer();
    }

    @Override
    public void unlockWriteBuffer() {
        super.unlockWriteBuffer();
        this.d_keyGenerator.endReserveKeys();
    }

    private final void beginCustomCommand(byte by, Class<? extends INativeObject> clazz, int n) {
        Integer n2 = this.d_classKeyMap.get(clazz);
        if (n2 == null) {
            n2 = this.registerClass(clazz);
        }
        this.beginCommand(by);
        this.writeInt(n2);
        this.writeInt(n);
    }

    private final void beginStaticCustomCommand(byte by, Class<? extends INativeObject> clazz) {
        Integer n = this.d_classKeyMap.get(clazz);
        if (n == null) {
            n = this.registerClass(clazz);
        }
        this.beginCommand(by);
        this.writeInt(n);
    }

    private final void beginFullCommand(byte by, INativeObject iNativeObject) {
        this.beginCustomCommand(by, iNativeObject.resolveNativeClass(), iNativeObject.getKey());
    }

    private final void beginSimpleCommand(byte by, INativeObject iNativeObject) {
        this.beginCommand(by);
        this.writeInt(iNativeObject.getKey());
    }

    public final void markPeerDirty(INativelyMirrored iNativelyMirrored) {
        this.updatePeer(iNativelyMirrored);
    }

    public final void createPeer(INativeObject iNativeObject) {
        this.beginFullCommand((byte)0, iNativeObject);
        this.endCommand();
    }

    public final void createPeers(Collection<? extends INativeObject> collection) {
        for (INativeObject iNativeObject : collection) {
            this.createPeer(iNativeObject);
        }
    }

    public final void createPeer(Class<? extends INativeObject> clazz, int n) {
        this.beginCustomCommand((byte)0, clazz, n);
        this.endCommand();
    }

    public final void registerPeer(INativeObject iNativeObject, int n, long l) {
        this.beginFullCommand((byte)5, iNativeObject);
        this.writeLong(l);
        this.endCommand();
    }

    private final void updatePeer(INativelyMirrored iNativelyMirrored) {
        this.beginSimpleCommand((byte)2, iNativelyMirrored);
        iNativelyMirrored.writeNativeData(this);
        this.endCommand();
        iNativelyMirrored.markNativeClean();
    }

    private final void updatePeers(Collection<? extends INativelyMirrored> collection) {
        for (INativelyMirrored iNativelyMirrored : collection) {
            this.updatePeer(iNativelyMirrored);
        }
    }

    public final void execMethod(Class clazz, INativeObject iNativeObject, Enum enum_, Object ... objectArray) {
        this.execMethod(clazz, iNativeObject, enum_.ordinal(), objectArray);
    }

    public final void execMethod(Class clazz, INativeObject iNativeObject, int n, Object ... objectArray) {
        this.beginCustomCommand((byte)3, clazz, iNativeObject.getKey());
        this.writeInt(n);
        this.writeObjects(objectArray);
        this.endCommand();
    }

    public final void execThrowable(Class clazz, INativeObject iNativeObject, Enum enum_, Object ... objectArray) throws Throwable {
        this.execThrowable(clazz, iNativeObject, enum_.ordinal(), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execThrowable(Class clazz, INativeObject iNativeObject, int n, Object ... objectArray) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, iNativeObject, n, objectArray);
            this.flushThrowable();
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public final void execStaticMethod(Class clazz, Enum enum_, Object ... objectArray) {
        this.execStaticMethod(clazz, enum_.ordinal(), objectArray);
    }

    public final void execStaticMethod(Class clazz, int n, Object ... objectArray) {
        this.beginStaticCustomCommand((byte)4, clazz);
        this.writeInt(n);
        this.writeObjects(objectArray);
        this.endCommand();
    }

    public <T> T exec(Class clazz, INativeObject iNativeObject, Enum enum_, Function<NativeManager, T> function, Object ... objectArray) {
        return this.exec(clazz, iNativeObject, enum_.ordinal(), function, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(Class clazz, INativeObject iNativeObject, int n, Function<NativeManager, T> function, Object ... objectArray) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, iNativeObject, n, objectArray);
            this.flush();
            T t = function.apply(this);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public <T> T execGet(Class clazz, INativeObject iNativeObject, Enum enum_, Class<T> clazz2, Object ... objectArray) {
        return this.execGet(clazz, iNativeObject, enum_.ordinal(), clazz2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execGet(Class clazz, INativeObject iNativeObject, int n, Class<T> clazz2, Object ... objectArray) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, iNativeObject, n, objectArray);
            this.flush();
            T t = this.read(clazz2);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public void exec(Class clazz, INativeObject iNativeObject, Enum enum_, Consumer<NativeManager> consumer, Object ... objectArray) {
        this.exec(clazz, iNativeObject, enum_.ordinal(), consumer, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(Class clazz, INativeObject iNativeObject, int n, Consumer<NativeManager> consumer, Object ... objectArray) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, iNativeObject, n, objectArray);
            this.flush();
            consumer.accept(this);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public void execThrowable(Class clazz, INativeObject iNativeObject, Enum enum_, Consumer<NativeManager> consumer, Object ... objectArray) throws Throwable {
        this.execThrowable(clazz, iNativeObject, enum_.ordinal(), consumer, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execThrowable(Class clazz, INativeObject iNativeObject, int n, Consumer<NativeManager> consumer, Object ... objectArray) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execThrowable(clazz, iNativeObject, n, objectArray);
            consumer.accept(this);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public <T> T execThrowable(Class clazz, INativeObject iNativeObject, Enum enum_, Function<NativeManager, T> function, Object ... objectArray) throws Throwable {
        return this.execThrowable(clazz, iNativeObject, enum_.ordinal(), function, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execThrowable(Class clazz, INativeObject iNativeObject, int n, Function<NativeManager, T> function, Object ... objectArray) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execThrowable(clazz, iNativeObject, n, objectArray);
            T t = function.apply(this);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public final void deletePeer(INativeObject iNativeObject) {
        this.scheduleFlush(5000L);
        this.beginSimpleCommand((byte)1, iNativeObject);
        this.endCommand();
    }

    public final void deletePeers(Collection<? extends INativeObject> collection) {
        for (INativeObject iNativeObject : collection) {
            this.deletePeer(iNativeObject);
        }
    }

    @Override
    public Keyable read() {
        int n = this.readInt();
        if (n < 0) {
            return null;
        }
        int n2 = this.readInt();
        long l = this.readLong();
        return this.readObject(n, n2, l);
    }

    public Keyable readObject(int n, int n2, long l) {
        Keyable keyable;
        if (n < 0) {
            return null;
        }
        Integer n3 = null;
        if (n2 != 0 && (keyable = this.d_keyGenerator.get(n3 = Integer.valueOf(n2))) != null) {
            return keyable;
        }
        return this.newJavaPeer(n, n3, l);
    }

    private Keyable newJavaPeer(int n2, Integer n3, long l) {
        Throwable[] throwableArray = new Throwable[]{null};
        Constructor constructor = s_nativeConstructors.computeIfAbsent(n2, n -> {
            try {
                Class<? extends INativeObject> clazz = this.getClassForKey((int)n);
                if (clazz == null) {
                    throw new ClassNotFoundException(String.format("No Java class found for key: %d", n));
                }
                return clazz.getDeclaredConstructor(Integer.class, Long.TYPE);
            }
            catch (Throwable throwable) {
                assert (false);
                throwableArray[0] = throwable;
                return null;
            }
        });
        if (throwableArray[0] != null) {
            throw new RuntimeException(throwableArray[0]);
        }
        assert (constructor != null);
        try {
            boolean bl = constructor.isAccessible();
            constructor.setAccessible(true);
            Keyable keyable = (Keyable)constructor.newInstance(n3, l);
            constructor.setAccessible(bl);
            return keyable;
        }
        catch (Throwable throwable) {
            assert (false);
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public final void flush() {
        try {
            super.flush();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public final void flushThrowable() throws IOException {
        super.flush();
    }

    @Override
    protected void dispatch(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws Throwable {
        this.d_lastCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.d_lastCommandLengthB;
        }
        Throwable throwable = null;
        try {
            Runnable runnable = () -> this.dispatch(byteBuffer, byteBuffer2, this.d_numCommands, this.d_commandStatus, this.d_firstCommandLengthB, this.d_lastCommandLengthB);
            this.d_executor.submit(runnable).get();
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
        this.d_numCommands = this.d_commandStatus == 1 ? 1 : 0;
        this.d_lastCommandPosition = 0;
        ++this.d_numFlushes;
        if (throwable != null) {
            throw throwable;
        }
    }

    public void resetFlushCount() {
        this.lockWriteBuffer();
        this.d_numFlushes = 0;
        this.unlockWriteBuffer();
    }

    public int getFlushCount() {
        return this.d_numFlushes;
    }
}

