/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.util.Keyable;

public class NativeKeyedObject
implements Serializable,
Keyable,
Cloneable {
    static final long serialVersionUID = 1L;
    private transient Integer d_key = null;

    public NativeKeyedObject() {
        this.ensureKeyed();
    }

    protected NativeKeyedObject(Integer n) {
        if (n == null) {
            this.ensureKeyed();
        } else {
            this.d_key = n;
            Native.keygen.registerKey(this, n);
        }
    }

    protected void ensureKeyed() {
        if (this.d_key != null) {
            return;
        }
        this.d_key = Native.keygen.generateKey(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.ensureKeyed();
    }

    protected void finalize() throws Throwable {
        Native.keygen.returnKey(this.d_key, this);
        this.d_key = null;
    }

    public static Keyable get(int n) {
        return Native.keygen.get(n);
    }

    @Override
    public Integer getKey() {
        return this.d_key;
    }

    public Object clone() {
        NativeKeyedObject nativeKeyedObject = null;
        try {
            nativeKeyedObject = (NativeKeyedObject)super.clone();
            nativeKeyedObject.d_key = null;
            nativeKeyedObject.ensureKeyed();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return nativeKeyedObject;
    }
}

