/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.Flushable;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public abstract class ABufferedNativeStream
implements INativeStream,
Flushable {
    public static final int DEFAULT_CAPACITY = 0x100000;
    private ByteBuffer d_writeBuffer;
    private final ReentrantLock d_bufferLock = new ReentrantLock();
    private ByteBuffer d_readBuffer;
    private boolean d_isDispatching = false;
    private Timer d_flushTimer = null;
    private final CustomList<Keyable> d_strongReferences = new CustomList(262144);
    private int d_numStrongRefsFinished = 0;
    private final List<Keyable> d_strongNativeRefs = new ArrayList<Keyable>();
    private static Map<Class, BiConsumer<ABufferedNativeStream, ?>> s_writers = new LinkedHashMap();
    private static Map<Class, Function<ABufferedNativeStream, ?>> s_readers = new LinkedHashMap();
    private static Map<Class, BiConsumer<ABufferedNativeStream, ?>> s_arrayReaders = new LinkedHashMap();

    public ABufferedNativeStream() {
        this(0x100000, 0x100000);
    }

    public ABufferedNativeStream(int n, int n2) {
        this.d_writeBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        this.d_readBuffer = ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    public boolean setWriteCapacity(int n) {
        this.lockWriteBuffer();
        if (this.getWritePosition() != 0) {
            this.unlockWriteBuffer();
            return false;
        }
        this.d_writeBuffer = ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        this.unlockWriteBuffer();
        return true;
    }

    public void lockWriteBuffer() {
        assert (!this.d_isDispatching || !this.d_bufferLock.isHeldByCurrentThread());
        this.d_bufferLock.lock();
    }

    public void unlockWriteBuffer() {
        this.d_bufferLock.unlock();
        if (!this.d_bufferLock.isLocked()) {
            this.d_strongNativeRefs.clear();
        }
    }

    protected void registerNativeObj(Keyable keyable) {
        if (this.d_bufferLock.isLocked()) {
            this.d_strongNativeRefs.add(keyable);
        }
    }

    public final int getWritePosition() {
        return this.d_writeBuffer.position();
    }

    @Override
    public final void write(Keyable keyable) {
        this.d_strongReferences.add(keyable);
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(keyable != null ? keyable.getKey() : 0);
    }

    @Override
    public final void write(Keyable ... keyableArray) {
        for (Keyable keyable : keyableArray) {
            this.write(keyable);
        }
    }

    @Override
    public void write(Collection<? extends Keyable> collection) {
        for (Keyable keyable : collection) {
            this.write(keyable);
        }
    }

    @Override
    public final void writeBoolean(boolean bl) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(bl ? (byte)1 : 0);
    }

    @Override
    public final void writeBooleans(boolean ... blArray) {
        for (boolean bl : blArray) {
            this.writeBoolean(bl);
        }
    }

    @Override
    public final void writeByte(byte by) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(by);
    }

    @Override
    public final void writeBytes(byte ... byArray) {
        for (byte by : byArray) {
            this.writeByte(by);
        }
    }

    @Override
    public final void writeShort(short s) {
        this.checkBuffer(2);
        this.d_writeBuffer.putShort(s);
    }

    @Override
    public final void writeShorts(short ... sArray) {
        for (short s : sArray) {
            this.writeShort(s);
        }
    }

    @Override
    public final void writeLong(long l) {
        this.checkBuffer(8);
        this.d_writeBuffer.putLong(l);
    }

    @Override
    public final void writeLongs(long ... lArray) {
        for (long l : lArray) {
            this.writeLong(l);
        }
    }

    @Override
    public void writeChar(char c) {
        this.checkBuffer(2);
        this.d_writeBuffer.putChar(c);
    }

    @Override
    public void writeChars(char ... cArray) {
        for (char c : cArray) {
            this.writeChar(c);
        }
    }

    @Override
    public final void writeInt(int n) {
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(n);
    }

    @Override
    public final void writeInts(int ... nArray) {
        for (int n : nArray) {
            this.writeInt(n);
        }
    }

    @Override
    public final void writeFloat(float f) {
        this.checkBuffer(4);
        this.d_writeBuffer.putFloat(f);
    }

    @Override
    public final void writeFloats(float ... fArray) {
        for (float f : fArray) {
            this.writeFloat(f);
        }
    }

    @Override
    public final void writeDouble(double d) {
        this.checkBuffer(8);
        this.d_writeBuffer.putDouble(d);
    }

    @Override
    public final void writeDoubles(double ... dArray) {
        for (double d : dArray) {
            this.writeDouble(d);
        }
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.writeChar(c);
        }
    }

    @Override
    public void writeStrings(String ... stringArray) {
        for (String string : stringArray) {
            this.writeString(string);
        }
    }

    public static <T> void registerWriter(Class<T> clazz, BiConsumer<ABufferedNativeStream, T> biConsumer) {
        s_writers.put(clazz, biConsumer);
    }

    public static <T> void registerReader(Class<T> clazz, Function<ABufferedNativeStream, T> function) {
        s_readers.put(clazz, function);
    }

    public static <T> void registerArrayReader(Class<T> clazz, BiConsumer<ABufferedNativeStream, T> biConsumer) {
        s_arrayReaders.put(clazz, biConsumer);
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            this.writeInt(0);
        } else {
            this.writeNonNull(object);
        }
    }

    private void writeNonNull(Object object) {
        Class<?> clazz = object.getClass();
        BiConsumer<ABufferedNativeStream, ?> biConsumer = s_writers.get(clazz);
        if (biConsumer == null) {
            biConsumer = theUtil.findObjectForArrayClass(false, s_writers, clazz);
            if (biConsumer == null) {
                assert (false) : "ABufferedNativeStream.writeObject failed: didn't recognize object type, " + object.getClass();
                return;
            }
            s_writers.put(clazz, biConsumer);
        }
        biConsumer.accept(this, object);
    }

    @Override
    public void writeObjects(Object ... objectArray) {
        for (Object object : objectArray) {
            this.writeObject(object);
        }
    }

    public void writeObjects(Collection<?> collection) {
        for (Object obj : collection) {
            this.writeObject(obj);
        }
    }

    @Override
    public void read(Keyable ... keyableArray) {
        for (int i = 0; i < keyableArray.length; ++i) {
            keyableArray[i] = this.read();
        }
    }

    @Override
    public void read(int n, Collection<Keyable> collection) {
        for (int i = 0; i < n; ++i) {
            collection.add(this.read());
        }
    }

    @Override
    public boolean readBoolean() {
        return this.d_readBuffer.get() != 0;
    }

    @Override
    public void readBooleans(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.d_readBuffer.get() != 0;
        }
    }

    @Override
    public byte readByte() {
        return this.d_readBuffer.get();
    }

    @Override
    public void readBytes(byte[] byArray) {
        this.d_readBuffer.get(byArray, 0, byArray.length);
    }

    @Override
    public short readShort() {
        return this.d_readBuffer.getShort();
    }

    @Override
    public void readShorts(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.d_readBuffer.getShort();
        }
    }

    @Override
    public long readLong() {
        return this.d_readBuffer.getLong();
    }

    @Override
    public void readLongs(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.d_readBuffer.getLong();
        }
    }

    @Override
    public char readChar() {
        return this.d_readBuffer.getChar();
    }

    @Override
    public void readChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.d_readBuffer.getChar();
        }
    }

    @Override
    public int readInt() {
        return this.d_readBuffer.getInt();
    }

    @Override
    public void readInts(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.d_readBuffer.getInt();
        }
    }

    @Override
    public float readFloat() {
        return this.d_readBuffer.getFloat();
    }

    @Override
    public void readFloats(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.d_readBuffer.getFloat();
        }
    }

    @Override
    public double readDouble() {
        return this.d_readBuffer.getDouble();
    }

    @Override
    public void readDoubles(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.d_readBuffer.getDouble();
        }
    }

    public double[] readDoubles(int n) {
        double[] dArray = new double[n];
        this.readDoubles(dArray);
        return dArray;
    }

    @Override
    public String readString() {
        int n = this.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.readChar();
        }
        return new String(cArray);
    }

    @Override
    public void readStrings(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.readString();
        }
    }

    public <T> T read(Class<T> clazz) {
        Function<ABufferedNativeStream, ?> function = ABufferedNativeStream.getReader(s_readers, clazz);
        if (function == null) {
            return null;
        }
        return (T)function.apply(this);
    }

    private static <T> T getReader(Map<Class, T> map, Class clazz) {
        T t = map.get(clazz);
        if (t == null) {
            t = theUtil.findObjectForArrayClass(false, map, clazz);
            if (t == null) {
                assert (false) : "ABufferedNativeStream.getReader failed: didn't recognize object type, " + clazz.getName();
                return null;
            }
            map.put(clazz, t);
        }
        return t;
    }

    public <CompT> void readArray(Class<CompT> clazz, Object object) {
        assert (clazz.isArray());
        BiConsumer<ABufferedNativeStream, ?> biConsumer = ABufferedNativeStream.getReader(s_arrayReaders, clazz);
        if (biConsumer == null) {
            return;
        }
        biConsumer.accept(this, object);
    }

    public <ArrayT> ArrayT readArray(Class<ArrayT> clazz, int n) {
        assert (clazz.isArray());
        Object object = Array.newInstance(clazz.getComponentType(), n);
        this.readArray(clazz, object);
        return (ArrayT)object;
    }

    private final void checkBuffer(int n) {
        assert (n <= this.d_writeBuffer.capacity());
        if (n > this.d_writeBuffer.remaining()) {
            this.forceFlushUncaught();
        }
    }

    protected void markStrongRefsFinished() {
        this.d_numStrongRefsFinished = this.d_strongReferences.size();
    }

    private void clearFinishedStrongRefs() {
        int n = this.d_strongReferences.size() - this.d_numStrongRefsFinished;
        if (n == 0) {
            this.d_strongReferences.clear();
        } else {
            this.d_strongReferences.removeRange(0, this.d_numStrongRefsFinished);
        }
        this.d_numStrongRefsFinished = n;
    }

    @Override
    public void flush() throws IOException {
        this.lockWriteBuffer();
        try {
            this.forceFlush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    private final void forceFlushUncaught() {
        try {
            this.forceFlush();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private final void forceFlush() throws Throwable {
        this.cancelScheduledFlush();
        if (this.d_writeBuffer.position() == 0) {
            return;
        }
        try {
            this.d_isDispatching = true;
            this.dispatch(this.d_writeBuffer, this.d_readBuffer);
            this.d_isDispatching = false;
        }
        finally {
            this.clearFinishedStrongRefs();
            this.d_writeBuffer.position(0);
            this.d_readBuffer.position(0);
        }
    }

    protected abstract void dispatch(ByteBuffer var1, ByteBuffer var2) throws Throwable;

    public final synchronized void scheduleFlush(long l) {
        if (this.d_flushTimer == null) {
            this.d_flushTimer = new Timer();
            this.d_flushTimer.schedule((TimerTask)new FlushTask(), l);
        }
    }

    public final synchronized void cancelScheduledFlush() {
        if (this.d_flushTimer != null) {
            this.d_flushTimer.cancel();
            this.d_flushTimer = null;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.writeByte((byte)n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.writeByte(byArray[i]);
        }
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.writeByte((byte)n);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.writeShort((short)n);
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.writeChar((char)n);
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeByte((byte)(0xFF & c));
        }
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        if (byArray.length > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(byArray.length);
        this.write(byArray);
    }

    @Override
    public void close() throws IOException {
    }

    static {
        ABufferedNativeStream.registerWriter(Byte.class, ABufferedNativeStream::writeByte);
        ABufferedNativeStream.registerReader(Byte.class, ABufferedNativeStream::readByte);
        ABufferedNativeStream.registerWriter(byte[].class, ABufferedNativeStream::writeBytes);
        ABufferedNativeStream.registerArrayReader(byte[].class, ABufferedNativeStream::readBytes);
        ABufferedNativeStream.registerWriter(Short.class, ABufferedNativeStream::writeShort);
        ABufferedNativeStream.registerReader(Short.class, ABufferedNativeStream::readShort);
        ABufferedNativeStream.registerWriter(short[].class, ABufferedNativeStream::writeShorts);
        ABufferedNativeStream.registerArrayReader(short[].class, ABufferedNativeStream::readShorts);
        ABufferedNativeStream.registerWriter(Long.class, ABufferedNativeStream::writeLong);
        ABufferedNativeStream.registerReader(Long.class, ABufferedNativeStream::readLong);
        ABufferedNativeStream.registerWriter(long[].class, ABufferedNativeStream::writeLongs);
        ABufferedNativeStream.registerArrayReader(long[].class, ABufferedNativeStream::readLongs);
        ABufferedNativeStream.registerWriter(Boolean.class, ABufferedNativeStream::writeBoolean);
        ABufferedNativeStream.registerReader(Boolean.class, ABufferedNativeStream::readBoolean);
        ABufferedNativeStream.registerWriter(boolean[].class, ABufferedNativeStream::writeBooleans);
        ABufferedNativeStream.registerArrayReader(boolean[].class, ABufferedNativeStream::readBooleans);
        ABufferedNativeStream.registerWriter(Character.class, ABufferedNativeStream::writeChar);
        ABufferedNativeStream.registerReader(Character.class, ABufferedNativeStream::readChar);
        ABufferedNativeStream.registerWriter(char[].class, ABufferedNativeStream::writeChars);
        ABufferedNativeStream.registerArrayReader(char[].class, ABufferedNativeStream::readChars);
        ABufferedNativeStream.registerWriter(Integer.class, ABufferedNativeStream::writeInt);
        ABufferedNativeStream.registerReader(Integer.class, ABufferedNativeStream::readInt);
        ABufferedNativeStream.registerWriter(int[].class, ABufferedNativeStream::writeInts);
        ABufferedNativeStream.registerArrayReader(int[].class, ABufferedNativeStream::readInts);
        ABufferedNativeStream.registerWriter(Float.class, ABufferedNativeStream::writeFloat);
        ABufferedNativeStream.registerReader(Float.class, ABufferedNativeStream::readFloat);
        ABufferedNativeStream.registerWriter(float[].class, ABufferedNativeStream::writeFloats);
        ABufferedNativeStream.registerArrayReader(float[].class, ABufferedNativeStream::readFloats);
        ABufferedNativeStream.registerWriter(Double.class, ABufferedNativeStream::writeDouble);
        ABufferedNativeStream.registerReader(Double.class, ABufferedNativeStream::readDouble);
        ABufferedNativeStream.registerWriter(double[].class, ABufferedNativeStream::writeDoubles);
        ABufferedNativeStream.registerArrayReader(double[].class, ABufferedNativeStream::readDoubles);
        ABufferedNativeStream.registerWriter(Keyable.class, ABufferedNativeStream::write);
        ABufferedNativeStream.registerReader(Keyable.class, INativeStream::read);
        ABufferedNativeStream.registerWriter(Keyable[].class, ABufferedNativeStream::write);
        ABufferedNativeStream.registerArrayReader(Keyable[].class, ABufferedNativeStream::read);
        ABufferedNativeStream.registerWriter(String.class, ABufferedNativeStream::writeString);
        ABufferedNativeStream.registerReader(String.class, ABufferedNativeStream::readString);
        ABufferedNativeStream.registerWriter(String[].class, ABufferedNativeStream::writeStrings);
        ABufferedNativeStream.registerArrayReader(String[].class, ABufferedNativeStream::readStrings);
        ABufferedNativeStream.registerWriter(Object[].class, ABufferedNativeStream::writeObjects);
        ABufferedNativeStream.registerWriter(Collection.class, ABufferedNativeStream::writeObjects);
    }

    private static class CustomList<T>
    extends ArrayList<T> {
        public CustomList(int n) {
            super(n);
        }

        @Override
        public void removeRange(int n, int n2) {
            super.removeRange(n, n2);
        }
    }

    private final class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            ABufferedNativeStream.this.d_flushTimer = null;
            ABufferedNativeStream.this.lockWriteBuffer();
            ABufferedNativeStream.this.forceFlushUncaught();
            ABufferedNativeStream.this.unlockWriteBuffer();
        }
    }
}

