/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UrlDataLoader {
    public static final X509TrustManager BLIND_TRUST_MANAGER = new BlindTrustManager();
    public static final HostnameVerifier BLIND_HOSTNAME_VERIFIER = new BlindHostnameVerifier();
    private final URL url;
    private final X509TrustManager customTrustManager;
    private final HostnameVerifier customHostnameVerifier;

    public UrlDataLoader(URL uRL, HostnameVerifier hostnameVerifier, X509TrustManager x509TrustManager) {
        this.url = uRL;
        this.customHostnameVerifier = hostnameVerifier;
        this.customTrustManager = x509TrustManager;
    }

    private URLConnection connectThroughToFinalDestination(URL uRL, int n) throws IOException {
        if (n <= 0) {
            throw new IOException("URL forwarding cycle detected - aborting connection: " + uRL.toString());
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpsURLConnection && this.customTrustManager != null) {
            try {
                SSLContext sSLContext = SSLContext.getInstance("SSLv3");
                sSLContext.init(null, new TrustManager[]{this.customTrustManager}, null);
                ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sSLContext.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        }
        if (uRLConnection instanceof HttpsURLConnection && this.customHostnameVerifier != null) {
            try {
                ((HttpsURLConnection)uRLConnection).setHostnameVerifier(this.customHostnameVerifier);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        uRLConnection.connect();
        int n2 = UrlDataLoader.getResponseCode(uRLConnection);
        if (299 < n2 && n2 < 400) {
            String string = uRLConnection.getHeaderField("Location");
            return this.connectThroughToFinalDestination(new URL(string), n - 1);
        }
        return uRLConnection;
    }

    public static int getResponseCode(URLConnection uRLConnection) throws IOException {
        if (uRLConnection instanceof HttpsURLConnection) {
            return ((HttpsURLConnection)uRLConnection).getResponseCode();
        }
        if (uRLConnection instanceof HttpURLConnection) {
            return ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        return 200;
    }

    public String connectAndRead() throws IOException {
        URLConnection uRLConnection = this.connect();
        return this.read(uRLConnection);
    }

    public URLConnection connect() throws IOException {
        return this.connectThroughToFinalDestination(this.url, 100);
    }

    public String read(URLConnection uRLConnection) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));){
            String string = bufferedReader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static class BlindHostnameVerifier
    implements HostnameVerifier {
        private BlindHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    private static class BlindTrustManager
    implements X509TrustManager {
        private BlindTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

