/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;

public enum TextFileEncoding {
    UTF32BE("UTF-32BE", 0, 0, 254, 255),
    UTF32LE("UTF-32LE", 255, 254, 0, 0),
    UTF8("UTF-8", 239, 187, 191),
    UTF16BE("UTF-16BE", 254, 255),
    UTF16LE("UTF-16LE", 255, 254);

    public final String name;
    public final byte[] bom;

    private TextFileEncoding(String string2, int ... nArray) {
        this.bom = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.bom[i] = (byte)nArray[i];
        }
        this.name = string2;
    }

    public static Optional<TextFileEncoding> find(byte[] byArray) {
        for (TextFileEncoding textFileEncoding : TextFileEncoding.values()) {
            if (!textFileEncoding.equalsBOM(byArray)) continue;
            return Optional.of(textFileEncoding);
        }
        return Optional.empty();
    }

    private boolean equalsBOM(byte[] byArray) {
        if (byArray.length < this.bom.length) {
            return false;
        }
        for (int i = 0; i < this.bom.length; ++i) {
            if (byArray[i] == this.bom[i]) continue;
            return false;
        }
        return true;
    }

    public static Optional<TextFileEncoding> read(FileInputStream fileInputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n = fileInputStream.read(byArray);
        if (n == -1) {
            return Optional.empty();
        }
        Optional<TextFileEncoding> optional = TextFileEncoding.find(Arrays.copyOf(byArray, n));
        int n2 = optional.map(textFileEncoding -> textFileEncoding.bom.length).orElse(0);
        fileInputStream.getChannel().position(n2);
        return optional;
    }

    public void writeBOM(OutputStream outputStream) throws IOException {
        outputStream.write(this.bom);
    }
}

