/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class TeciLogging {
    public static void initToSplitHandler(Logger logger, Level level, Level level2, Formatter formatter, PrintStream printStream, PrintStream printStream2) {
        StreamHandlerWithAutoFlush streamHandlerWithAutoFlush = new StreamHandlerWithAutoFlush(printStream, formatter);
        streamHandlerWithAutoFlush.setLevel(level);
        streamHandlerWithAutoFlush.setFilter(logRecord -> logRecord.getLevel().intValue() < level2.intValue());
        StreamHandlerWithAutoFlush streamHandlerWithAutoFlush2 = new StreamHandlerWithAutoFlush(printStream2, formatter);
        streamHandlerWithAutoFlush2.setLevel(level2);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        logger.setLevel(level);
        logger.addHandler(streamHandlerWithAutoFlush);
        logger.addHandler(streamHandlerWithAutoFlush2);
    }

    public static Formatter getDefaultLogFormat() {
        return new SimpleFormatter(){
            private static final String format = "%s %n";

            @Override
            public synchronized String format(LogRecord logRecord) {
                return String.format(format, logRecord.getMessage());
            }
        };
    }

    public static void main(String[] stringArray) {
        TeciLogging.initToSplitHandler(Logger.getLogger(""), Level.FINE, Level.WARNING, TeciLogging.getDefaultLogFormat(), System.out, System.err);
        Logger logger = Logger.getLogger("");
        logger.log(Level.FINEST, "finest");
        logger.log(Level.FINER, "finer");
        logger.log(Level.FINE, "fine");
        logger.log(Level.CONFIG, "config");
        logger.log(Level.INFO, "info");
        logger.log(Level.WARNING, "warning");
        logger.log(Level.SEVERE, "severe");
        Logger logger2 = Logger.getLogger("foo.bar.baz");
        logger2.log(Level.FINEST, "finest");
        logger2.log(Level.FINER, "finer");
        logger2.log(Level.FINE, "fine");
        logger2.log(Level.CONFIG, "config");
        logger2.log(Level.INFO, "info");
        logger2.log(Level.WARNING, "warning");
        logger2.log(Level.SEVERE, "severe");
    }

    private static class StreamHandlerWithAutoFlush
    extends StreamHandler {
        public StreamHandlerWithAutoFlush() {
        }

        public StreamHandlerWithAutoFlush(OutputStream outputStream, Formatter formatter) {
            super(outputStream, formatter);
        }

        @Override
        public void publish(LogRecord logRecord) {
            super.publish(logRecord);
            this.flush();
        }
    }
}

