/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

public class TeciEncrypt {
    private static final byte[] s_header = new byte[]{-97, 35, 126, 58, -121, -82, 68, 65, 109, 28, 67, 52, -18, 89, 0, 120};
    private static final byte[] s_mask = new byte[]{79, 21, -98, 52};

    public static byte[] getHeader() {
        return s_header;
    }

    public static int getSimpleShift() {
        return 7;
    }

    public static byte[] getSimpleMask() {
        return s_mask;
    }

    public static void swap(byte[] byArray) {
        int n = byArray.length / 2;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray.length - i - 1;
            byte by = byArray[i];
            byArray[i] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public static void eor(byte[] byArray, byte[] byArray2) {
        assert (byArray.length == byArray2.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    public static void rol(byte[] byArray, int n) {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            n2 = Math.min(8, i);
            int n3 = 8 - n2;
            int n4 = 255 << 8 - n2;
            int n5 = 0;
            for (int j = byArray.length - 1; j >= 0; --j) {
                int n6 = byArray[j] & 0xFF;
                int n7 = (n6 & n4) >>> n3 & 0xFF;
                byArray[j] = (byte)(n6 << n2 | n5);
                n5 = n7;
            }
            int n8 = byArray.length - 1;
            byArray[n8] = (byte)(byArray[n8] | n5);
        }
    }

    public static void rolInverted(byte[] byArray, int n) {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            n2 = Math.min(8, i);
            int n3 = 8 - n2;
            int n4 = 255 << 8 - n2;
            int n5 = 0;
            for (int j = 0; j < byArray.length; ++j) {
                int n6 = byArray[j] & 0xFF;
                int n7 = (n6 & n4) >>> n3 & 0xFF;
                byArray[j] = (byte)(n6 << n2 | n5);
                n5 = n7;
            }
            byArray[0] = (byte)(byArray[0] | n5);
        }
    }

    public static void ror(byte[] byArray, int n) {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            n2 = Math.min(8, i);
            int n3 = 8 - n2;
            int n4 = 255 >>> 8 - n2;
            int n5 = 0;
            for (int j = 0; j < byArray.length; ++j) {
                int n6 = byArray[j] & 0xFF;
                int n7 = (n6 & n4) << n3 & 0xFF;
                byArray[j] = (byte)(n6 >>> n2 | n5);
                n5 = n7;
            }
            byArray[0] = (byte)(byArray[0] | n5);
        }
    }

    public static void rorInverted(byte[] byArray, int n) {
        int n2;
        for (int i = n; i > 0; i -= n2) {
            n2 = Math.min(8, i);
            int n3 = 8 - n2;
            int n4 = 255 >>> 8 - n2;
            int n5 = 0;
            for (int j = byArray.length - 1; j >= 0; --j) {
                int n6 = byArray[j] & 0xFF;
                int n7 = (n6 & n4) << n3 & 0xFF;
                byArray[j] = (byte)(n6 >>> n2 | n5);
                n5 = n7;
            }
            int n8 = byArray.length - 1;
            byArray[n8] = (byte)(byArray[n8] | n5);
        }
    }

    public static enum Type {
        UNENCRYPTED(false),
        SIMPLE(true);

        public final boolean encrypted;

        private Type(boolean bl) {
            this.encrypted = bl;
        }
    }
}

