/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;

public class ObjectSelection
implements Transferable,
ClipboardOwner {
    private DataFlavor d_serializedFlavor;
    private Serializable d_object;
    private String d_string;

    public ObjectSelection(Serializable serializable, String string, DataFlavor dataFlavor) {
        this.d_object = serializable;
        this.d_string = string;
        this.d_serializedFlavor = dataFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        LinkedList<DataFlavor> linkedList = new LinkedList<DataFlavor>();
        if (this.d_string != null) {
            linkedList.add(DataFlavor.stringFlavor);
        }
        if (this.d_object != null) {
            linkedList.add(this.d_serializedFlavor);
        }
        return linkedList.toArray(new DataFlavor[linkedList.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.d_object != null && dataFlavor.match(this.d_serializedFlavor) || this.d_string != null && dataFlavor.match(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.match(DataFlavor.stringFlavor) && this.d_string != null) {
            return this.d_string;
        }
        if (dataFlavor.match(this.d_serializedFlavor) && this.d_object != null) {
            return this.d_object;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

