/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class MPIUtil {
    public static boolean mpiAuth(Window window, File file, int n) {
        try {
            String string;
            Object object;
            if (MPIUtil.checkValidation(file, n)) {
                return true;
            }
            List<String> list = MPIUtil.listInput(file, n, "-whoami");
            String string2 = list.isEmpty() ? "" : list.get(list.size() - 1);
            int n2 = string2.indexOf(92);
            if (0 <= n2) {
                object = string2.substring(0, n2);
                string = string2.substring(n2 + 1);
                string2 = String.format("%s\\%s", ((String)object).toUpperCase(), string);
            }
            while (true) {
                if (((guiDialog)(object = new PasswordDlg(window, string2))).doModal() != 1) {
                    return false;
                }
                string = ((PasswordDlg)object).getUser();
                if (string.isEmpty()) {
                    MPIUtil.authError(window, Intl.intl("MPI requires a user name."));
                    continue;
                }
                char[] cArray = ((PasswordDlg)object).getPassword();
                if (cArray.length == 0) {
                    MPIUtil.authError(window, Intl.intl("MPI requires a non-blank password."));
                    continue;
                }
                String[] stringArray = MPIUtil.getMPIArgs(file, n, "-register");
                Process process = Runtime.getRuntime().exec(stringArray, null, file.getParentFile());
                PrintWriter printWriter = new PrintWriter(process.getOutputStream());
                printWriter.println(string);
                printWriter.println(cArray);
                printWriter.println(cArray);
                printWriter.flush();
                Arrays.fill(cArray, '0');
                MPIUtil.listInput(process, false);
                if (MPIUtil.checkValidation(file, n)) {
                    return true;
                }
                MPIUtil.authError(window, Intl.intl("The password you entered is invalid."));
            }
        }
        catch (MPIAuthException mPIAuthException) {
            String string = mPIAuthException.getLocalizedMessage();
            if (string.isEmpty()) {
                string = MPIUtil.formatException(mPIAuthException);
            }
            MPIUtil.authError(window, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MPIUtil.formatException(iOException);
            MPIUtil.authError(window, string);
        }
        return false;
    }

    private static String formatException(Exception exception) {
        return String.format(Intl.intl("An unknown error ocurred running mpiexec:%n%s"), exception.getClass().getSimpleName() + ": " + exception.getLocalizedMessage());
    }

    private static void authError(Window window, String string) {
        JOptionPane.showMessageDialog(window, string, Intl.intl("Authorization Error"), 0);
    }

    private static boolean checkValidation(File file, int n) throws IOException, MPIAuthException {
        List<String> list = MPIUtil.listInput(file, n, "-validate");
        String string = "";
        for (String string2 : list) {
            System.out.println(string2);
            if (string2.toUpperCase().startsWith("SUCCESS")) {
                return true;
            }
            if (string2.toUpperCase().startsWith("FAIL")) {
                return false;
            }
            if (string2.isEmpty()) continue;
            if (!string.isEmpty()) {
                string = string + "\n";
            }
            string = string + string2;
        }
        throw new MPIAuthException(string);
    }

    private static List<String> listInput(File file, int n, String string) throws IOException {
        String[] stringArray = MPIUtil.getMPIArgs(file, n, string);
        File file2 = file.getParentFile();
        Process process = Runtime.getRuntime().exec(stringArray, null, file2);
        return MPIUtil.listInput(process, false);
    }

    private static List<String> listInput(Process process, boolean bl) throws IOException {
        InputCatcher inputCatcher = new InputCatcher(process.getInputStream());
        if (bl) {
            inputCatcher.run();
            new InputCatcher(process.getErrorStream()).run();
        } else {
            Thread thread = new Thread(inputCatcher);
            Thread thread2 = new Thread(new InputCatcher(process.getErrorStream()));
            thread.start();
            thread2.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (inputCatcher.d_caughtError != null) {
            throw inputCatcher.d_caughtError;
        }
        return inputCatcher.d_input;
    }

    private static String[] getMPIArgs(File file, int n, String string) {
        return new String[]{file.getAbsolutePath(), string, "-port", Integer.toString(n)};
    }

    public static void main(String[] stringArray) {
        File file = new File("C:\\Program Files\\PyroSim 2011\\fds64\\mpiexec.exe");
        MPIUtil.mpiAuth(null, file, 52401);
    }

    private static class PasswordDlg
    extends guiDialog {
        private final JPasswordField d_password;
        private final guiTextField d_user;

        public PasswordDlg(Window window, String string) {
            super(window, Intl.intl("Enter Password"), 9);
            MultiLineLabel multiLineLabel = new MultiLineLabel(Intl.intl("Please enter a password for MPI to start processes on your computer."));
            multiLineLabel.setColumns(30);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Username:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Password:"));
            this.d_user = new guiTextField(string);
            this.d_password = new JPasswordField();
            this.d_password.setEchoChar('*');
            guiPanel guiPanel2 = this.getDialogPane();
            guiPanel2.setLayout(new GridBagLayout());
            GridBagUtil.add(guiPanel2, multiLineLabel, 0, 0, 2, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiLabel2, 0, 1, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_user, 1, 1, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiLabel3, 0, 2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_password, 1, 2, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    d_user.requestFocusInWindow();
                }
            });
        }

        public char[] getPassword() {
            return this.d_password.getPassword();
        }

        public String getUser() {
            return this.d_user.getValue();
        }
    }

    private static class InputCatcher
    implements Runnable {
        private final List<String> d_input;
        private final InputStream d_stream;
        private IOException d_caughtError = null;

        public InputCatcher(InputStream inputStream) {
            this.d_stream = inputStream;
            this.d_input = new ArrayList<String>();
        }

        @Override
        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.d_stream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.d_input.add(string);
                }
            }
            catch (IOException iOException) {
                this.d_caughtError = iOException;
            }
        }
    }

    private static class MPIAuthException
    extends Exception {
        public MPIAuthException(String string) {
            super(string);
        }
    }
}

