/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
implements DataOutput,
Closeable,
Flushable {
    private static final String EmbeddedCopyright = "Copyright 1998 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected DataOutputStream d;
    byte[] w;

    public LEDataOutputStream(OutputStream outputStream) {
        this.d = new DataOutputStream(outputStream);
        this.w = new byte[8];
    }

    @Override
    public final void writeShort(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.d.write(this.w, 0, 2);
    }

    @Override
    public final void writeChar(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.d.write(this.w, 0, 2);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        this.w[0] = (byte)n;
        this.w[1] = (byte)(n >> 8);
        this.w[2] = (byte)(n >> 16);
        this.w[3] = (byte)(n >> 24);
        this.d.write(this.w, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        this.w[0] = (byte)l;
        this.w[1] = (byte)(l >> 8);
        this.w[2] = (byte)(l >> 16);
        this.w[3] = (byte)(l >> 24);
        this.w[4] = (byte)(l >> 32);
        this.w[5] = (byte)(l >> 40);
        this.w[6] = (byte)(l >> 48);
        this.w[7] = (byte)(l >> 56);
        this.d.write(this.w, 0, 8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    @Override
    public final synchronized void write(int n) throws IOException {
        this.d.write(n);
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.d.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        this.d.flush();
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        this.d.writeBoolean(bl);
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.d.writeByte(n);
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        this.d.writeBytes(string);
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        this.d.writeUTF(string);
    }

    public final int size() {
        return this.d.size();
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.d.write(byArray, 0, byArray.length);
    }

    @Override
    public final void close() throws IOException {
        this.d.close();
    }
}

