/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.function.Predicate;
import thunderheadeng.Intl;
import thunderheadeng.io.LEDataInputStream;
import thunderheadeng.io.LEDataOutputStream;
import thunderheadeng.io.streamsrc.IFilterStreamSrc;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.Pair;

public class IOUtil {
    public static DataInput constructNativeDataInput(InputStream inputStream) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? new DataInputStream(inputStream) : new LEDataInputStream(inputStream);
    }

    public static DataOutput constructNativeDataOutput(OutputStream outputStream) {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? new DataOutputStream(outputStream) : new LEDataOutputStream(outputStream);
    }

    public static void write(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        if ((byteBuffer = byteBuffer.duplicate()).hasArray()) {
            byte[] byArray = byteBuffer.array();
            outputStream.write(byArray, 0, byArray.length);
        } else {
            byte[] byArray = new byte[8192];
            while (byteBuffer.hasRemaining()) {
                int n = Math.min(byteBuffer.remaining(), byArray.length);
                byteBuffer.get(byArray, 0, n);
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static ByteBuffer readByteBuffer(InputStream inputStream, int n, boolean bl, ByteOrder byteOrder) throws IOException {
        if (n == -1) {
            int n2;
            CustomByteArrayOutputStream customByteArrayOutputStream = new CustomByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) > 0) {
                customByteArrayOutputStream.write(byArray, 0, n2);
            }
            n = customByteArrayOutputStream.getSize();
            ByteBuffer byteBuffer = IOUtil.allocate(n, bl, byteOrder);
            byteBuffer.put(customByteArrayOutputStream.getBuffer(), 0, n);
            byteBuffer.position(0);
            return byteBuffer;
        }
        ByteBuffer byteBuffer = IOUtil.allocate(n, bl, byteOrder);
        if (byteBuffer.hasArray()) {
            int n3;
            for (int i = n; i > 0; i -= n3) {
                n3 = inputStream.read(byteBuffer.array(), 0, n);
                if (n3 > 0) continue;
                throw new IOException(Intl.intl("Could not read ByteBuffer."));
            }
        } else {
            byte[] byArray = new byte[8192];
            while (byteBuffer.hasRemaining()) {
                int n4 = inputStream.read(byArray);
                if (n4 <= 0) {
                    throw new IOException(Intl.intl("Could not read ByteBuffer"));
                }
                byteBuffer.put(byArray, 0, n4);
            }
            byteBuffer.position(0);
        }
        return byteBuffer;
    }

    private static ByteBuffer allocate(int n, boolean bl, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = bl ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        byteBuffer.order(byteOrder);
        return byteBuffer;
    }

    public static Pair<ByteBuffer, Boolean> loadData(IStreamSrc iStreamSrc, int n, boolean bl, ByteOrder byteOrder) throws IOException {
        Object object;
        if ((n & 1) == 1) {
            while (iStreamSrc instanceof IFilterStreamSrc) {
                iStreamSrc = ((IFilterStreamSrc)iStreamSrc).getBaseSource();
            }
        }
        if (iStreamSrc instanceof ILocalStreamSrc) {
            object = ((ILocalStreamSrc)iStreamSrc).getLocalData();
            if (!bl || ((ByteBuffer)object).isDirect()) {
                if (((ByteBuffer)object).order() == byteOrder) {
                    return new Pair<ByteBuffer, Boolean>((ByteBuffer)object, true);
                }
                return new Pair<ByteBuffer, Boolean>(((ByteBuffer)object).order(byteOrder), true);
            }
        }
        object = null;
        try {
            long l = iStreamSrc.getSize(n);
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError(Intl.intl("Data is too big to fit into memory."));
            }
            object = iStreamSrc.open(n);
            ByteBuffer byteBuffer = IOUtil.readByteBuffer((InputStream)object, (int)l, bl, byteOrder);
            Pair<ByteBuffer, Boolean> pair = new Pair<ByteBuffer, Boolean>(byteBuffer, false);
            return pair;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File resolvePath(String string, File file, Boolean bl) {
        File file2 = new File(string);
        if (file2.exists() && (bl == null || bl.booleanValue() == file2.isFile())) {
            return file2;
        }
        if (file.isFile()) {
            file = file.getParentFile();
        }
        String string2 = "";
        while (file2 != null) {
            File file3 = new File(file, string2 = string2.isEmpty() ? file2.getName() : file2.getName() + File.separator + string2);
            if (file3.exists() && (bl == null || bl.booleanValue() == file3.isFile())) {
                return file3;
            }
            file2 = file2.getParentFile();
        }
        return null;
    }

    public static File resolvePath2(String string, File file, Predicate<File> predicate) {
        File file2;
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if ((file2 = new File(string)).exists() && predicate.test(file2)) {
            return file2;
        }
        while (file2 != null) {
            File file3 = new File(file, file2.getPath());
            if (file3.exists() && predicate.test(file3)) {
                return file3;
            }
            file2 = IOUtil.removeRoot(file2);
        }
        return null;
    }

    private static File removeRoot(File file) {
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        while (file != null) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                arrayDeque.addFirst(file.getName());
            }
            file = file2;
        }
        if (arrayDeque.isEmpty()) {
            return null;
        }
        file = new File((String)arrayDeque.removeFirst());
        while (!arrayDeque.isEmpty()) {
            file = new File(file, (String)arrayDeque.removeFirst());
        }
        return file;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static PrintWriter newPrintWriterUTF8(String string) throws IOException {
        return IOUtil.newPrintWriter(string, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriterUTF8(File file) throws IOException {
        return IOUtil.newPrintWriter(file, Charset.forName("UTF-8"));
    }

    public static PrintWriter newPrintWriter(String string, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), charset));
    }

    public static PrintWriter newPrintWriter(File file, Charset charset) throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static void writeUTF8(DataOutput dataOutput, String string) throws IOException {
        IOUtil.write(dataOutput, string, StandardCharsets.UTF_8);
    }

    public static void write(DataOutput dataOutput, String string, Charset charset) throws IOException {
        byte[] byArray = string.getBytes(charset);
        dataOutput.writeInt(byArray.length);
        dataOutput.write(byArray, 0, byArray.length);
    }

    public static void main(String[] stringArray) {
        Predicate<File> predicate = file -> file.isFile();
        String string = "C:\\.\\Temp\\MultiFloorStairwell.txt";
        File file2 = IOUtil.resolvePath2(string, new File("C:\\Users\\okonski\\Documents"), predicate);
        System.out.println(file2.getAbsolutePath());
        string = "test.txt";
        file2 = IOUtil.resolvePath2(string, new File("D:\\okonski\\Documents\\temp"), predicate);
        System.out.println(file2.getAbsolutePath());
        string = "nodir\\blah\\test.txt";
        file2 = IOUtil.resolvePath2(string, new File("D:\\okonski\\Documents\\temp"), predicate);
        System.out.println(file2.getAbsolutePath());
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getSize() {
            return this.count;
        }
    }
}

