/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.MRUFileList;

public class FilenameManager {
    public static final int OPEN_FILE = 0;
    public static final int SAVE_FILE = 1;
    public static final int FORCE_PROMPT = 0;
    public static final int ALLOW_PROMPT = 1;
    public static final int NO_PROMPT = 2;
    private Hashtable d_fileTypes = new Hashtable();
    private File d_defaultFolder;
    private guiFileChooser d_chooser = null;

    public FilenameManager() {
        this(null);
    }

    public FilenameManager(File file) {
        this.d_defaultFolder = file;
    }

    public synchronized guiFileChooser getFileChooser() {
        if (this.d_chooser == null) {
            this.d_chooser = new guiFileChooser();
            if (this.d_defaultFolder != null) {
                this.d_chooser.setCurrentDirectory(this.d_defaultFolder);
            }
        }
        return this.d_chooser;
    }

    public guiFileChooser getFileChooser(String ... stringArray) {
        return this.getFileChooser((File)null, stringArray);
    }

    public guiFileChooser getFileChooser(File file, String ... stringArray) {
        return this.getFileChooser(null, file, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public guiFileChooser getFileChooser(String string, File file, String ... stringArray) {
        List list;
        String string2;
        assert (stringArray.length % 2 == 0);
        guiFileChooser guiFileChooser2 = this.getFileChooser();
        guiFileChooser2.setDialogTitle(string);
        guiFileChooser2.resetChoosableFileFilters();
        ExampleFileFilter object2 = null;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i = 0; i < stringArray.length; i += 2) {
            String object3 = stringArray[i];
            string2 = stringArray[i + 1];
            list = (ArrayList<String>)linkedHashMap.get(string2);
            if (list == null) {
                list = new ArrayList<String>(1);
                linkedHashMap.put(string2, list);
            }
            list.add(object3);
        }
        if (linkedHashMap.size() > 1) {
            void var8_12;
            String[] stringArray2 = new String[stringArray.length / 2];
            boolean i = false;
            while (var8_12 < stringArray.length) {
                stringArray2[var8_12 / 2] = stringArray[var8_12];
                var8_12 += 2;
            }
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter(stringArray2, Intl.intl("All Supported Types"));
            exampleFileFilter.setExtensionListInDescription(stringArray2.length < 6);
            guiFileChooser2.addChoosableFileFilter(exampleFileFilter);
            object2 = exampleFileFilter;
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            string2 = (String)entry.getKey();
            list = (List)entry.getValue();
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter(list.toArray(new String[list.size()]), string2);
            guiFileChooser2.addChoosableFileFilter(exampleFileFilter);
            if (object2 != null) continue;
            object2 = exampleFileFilter;
        }
        guiFileChooser2.setAcceptAllFileFilterUsed(true);
        guiFileChooser2.setFileFilter(object2);
        if (file == null) {
            file = new File("");
        }
        guiFileChooser2.setSelectedFile(file);
        return guiFileChooser2;
    }

    public File getOpenFile(Component component, String ... stringArray) {
        return this.getOpenFile(component, (String)null, (File)null, stringArray);
    }

    public File getOpenFile(Component component, File file, String ... stringArray) {
        return this.getOpenFile(component, null, file, stringArray);
    }

    public File getOpenFile(Component component, String string, File file, String ... stringArray) {
        guiFileChooser guiFileChooser2 = this.getFileChooser(string, file, stringArray);
        if (guiFileChooser2.showOpenDialog(component) != 0) {
            return null;
        }
        return guiFileChooser2.getSelectedFile();
    }

    public File getSaveFile(Component component, String ... stringArray) {
        return this.getSaveFile(component, (String)null, (File)null, stringArray);
    }

    public File getSaveFile(Component component, File file, String ... stringArray) {
        return this.getSaveFile(component, null, file, stringArray);
    }

    public File getSaveFile(Component component, String string, File file, String ... stringArray) {
        guiFileChooser guiFileChooser2 = this.getFileChooser(string, file, stringArray);
        if (guiFileChooser2.showSaveDialog(component) != 0) {
            return null;
        }
        return guiFileChooser2.getSelectedFile();
    }

    public static String changeExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n > 0 ? string.substring(0, n) + "." + string2 : string + "." + string2;
        return string3;
    }

    public static String getRelativeFilename(File file, File file2, boolean bl, boolean bl2) {
        return FilenameManager.getRelativeFilename(file.getAbsolutePath(), file2.getAbsolutePath(), bl, bl2);
    }

    public static String getRelativeFilename(String string, String string2, boolean bl, boolean bl2) {
        File file;
        if (string == null || string2 == null) {
            return null;
        }
        File file2 = new File(string2);
        File file3 = new File(string);
        String string3 = File.separator;
        String string4 = "";
        ArrayList<File> arrayList = FilenameManager.getPathList(file2, bl2);
        int n = 0;
        File file4 = file = !bl ? file3 : file3.getParentFile();
        while (file != null) {
            int n2 = arrayList.indexOf(file);
            if (n2 >= 0) {
                n = n2;
                break;
            }
            file = file.getParentFile();
            string4 = string4 + "../";
        }
        ++n;
        while (n < arrayList.size()) {
            string4 = string4 + arrayList.get(n).getName();
            string4 = string4 + string3;
            ++n;
        }
        if (bl2) {
            string4 = string4 + file2.getName();
        }
        return string4;
    }

    public static String[] splitFilename(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return new String[]{string2, string3};
        }
        return new String[]{string, ""};
    }

    public static String getExtension(String string) {
        return FilenameManager.splitFilename(string)[1];
    }

    private static File asDirectory(File file) {
        return file.isDirectory() ? file : file.getParentFile();
    }

    private static ArrayList<File> getPathList(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (bl) {
            file = file.getParentFile();
        }
        while (file != null) {
            arrayList.add(0, file);
            file = file.getParentFile();
        }
        return arrayList;
    }

    public void addFileType(String string, FileFilter fileFilter) {
        this.addFileType(string, fileFilter, new String());
    }

    public void addFileType(String string, FileFilter fileFilter, String string2) {
        MRUFileList mRUFileList = new MRUFileList();
        mRUFileList.setEntryPrefix(string + " MRU Entry #");
        mRUFileList.usedFile(string2);
        this.d_fileTypes.put(string, new Entry(fileFilter, mRUFileList));
    }

    public void setFilename(String string, String string2) {
        Entry entry = (Entry)this.d_fileTypes.get(string);
        if (entry != null) {
            entry.i_filelist.usedFile(string2);
        }
    }

    public String getFilename(String string) {
        Entry entry = (Entry)this.d_fileTypes.get(string);
        if (entry != null && entry.i_filelist.getNumEntries() > 0) {
            return entry.i_filelist.getFilename(0);
        }
        return null;
    }

    public String getFilename(String string, int n, int n2) {
        int n3;
        Entry entry = (Entry)this.d_fileTypes.get(string);
        File file = new File("");
        if (entry == null) {
            return null;
        }
        if (entry.i_filelist.getNumEntries() > 0 && (file = new File(entry.i_filelist.getFilename(0))).exists() && n != 0) {
            return file.getPath();
        }
        if (n == 2) {
            return null;
        }
        guiFileChooser guiFileChooser2 = this.getFileChooser();
        guiFileChooser2.resetChoosableFileFilters();
        guiFileChooser2.addChoosableFileFilter(entry.i_filter);
        if (file.exists()) {
            guiFileChooser2.setSelectedFile(file);
        }
        if ((n3 = n2 == 0 ? guiFileChooser2.showOpenDialog(Application.getApp().getMainFrame()) : guiFileChooser2.showSaveDialog(Application.getApp().getMainFrame())) == 0) {
            entry.i_filelist.usedFile(guiFileChooser2.getFilename());
            return guiFileChooser2.getFilename();
        }
        return null;
    }

    public void load(Properties properties) {
        Object[] objectArray = this.d_fileTypes.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Entry)objectArray[i]).i_filelist.load(properties);
        }
    }

    public void store(Properties properties) {
        Object[] objectArray = this.d_fileTypes.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Entry)objectArray[i]).i_filelist.store(properties);
        }
    }

    public static boolean equal(File file, File file2) {
        try {
            file = file.getCanonicalFile();
            file2 = file2.getCanonicalFile();
            return file.equals(file2);
        }
        catch (IOException iOException) {
            return file.equals(file2);
        }
    }

    private class Entry {
        public FileFilter i_filter;
        public MRUFileList i_filelist;

        Entry(FileFilter fileFilter, MRUFileList mRUFileList) {
            this.i_filter = fileFilter;
            this.i_filelist = mRUFileList;
        }
    }
}

