/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IFileSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class FileSystem
implements IFileSystem,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final IFileSystem INSTANCE = new FileSystem();

    protected static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    @Override
    public InputStream open(String string, boolean bl) throws IOException, FileNotFoundException {
        return new FileInputStream(string);
    }

    @Override
    public long getSize(String string) throws IOException, FileNotFoundException {
        return new File(string).length();
    }

    @Override
    public IStreamSrc getStreamSrc(String string, int n) {
        boolean bl = FileSystem.test(n, 2);
        IStreamSrc iStreamSrc = new FileSrc(this, string, bl);
        if (FileSystem.test(n, 1)) {
            iStreamSrc = new DecryptStreamSrc(iStreamSrc);
        }
        return iStreamSrc;
    }

    @Override
    public long getModTime(String string) {
        return new File(string).lastModified();
    }

    @Override
    public void transferData(String string, boolean bl, OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = outputStream;
        if (bl && !(outputStream2 instanceof BufferedOutputStream)) {
            outputStream2 = new BufferedOutputStream(outputStream);
        }
        byte[] byArray = new byte[8192];
        InputStream inputStream = new FileInputStream(string);
        try {
            int n;
            if (bl) {
                inputStream = new BufferedInputStream(inputStream);
            }
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream2.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (outputStream2 != outputStream) {
            outputStream2.flush();
        }
    }

    protected static class FileSrc
    implements IFileSrc,
    Serializable {
        private static final long serialVersionUID = 0L;
        public final String filename;
        public final IFileSystem fileSystem;
        public final boolean buffered;

        public FileSrc(IFileSystem iFileSystem, String string, boolean bl) {
            this.fileSystem = iFileSystem;
            this.filename = string;
            this.buffered = bl;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public IFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public boolean isBuffered() {
            return this.buffered;
        }

        @Override
        public InputStream open(int n) throws IOException {
            return this.fileSystem.open(this.filename, this.buffered);
        }

        @Override
        public long getSize(int n) throws IOException {
            return this.fileSystem.getSize(this.filename);
        }

        @Override
        public long getModTime() {
            return this.fileSystem.getModTime(this.filename);
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        public void transferData(OutputStream outputStream) throws IOException {
            this.fileSystem.transferData(this.filename, this.buffered, outputStream);
        }

        @Override
        public IStreamSrc refilter(IStreamSrc iStreamSrc) {
            return iStreamSrc;
        }
    }
}

