/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class ExtensionFileFilter
implements FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private List<String> d_filters = new ArrayList<String>();
    private String d_description = null;
    private String d_fullDescription = null;
    private boolean d_useExtensionsInDescription = true;

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String string) {
        this(string, (String)null);
    }

    public ExtensionFileFilter(String string, String string2) {
        this();
        this.addExtension(string);
        this.setDescription(string2);
    }

    public ExtensionFileFilter(String ... stringArray) {
        this(stringArray, (String)null);
    }

    public ExtensionFileFilter(String[] stringArray, String string) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        this.setDescription(string);
    }

    public ExtensionFileFilter(String string, String ... stringArray) {
        this(stringArray, string);
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = ExtensionFileFilter.getExtension(file);
            if (string != null && this.d_filters.contains(string)) {
                return true;
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public File appendExtension(File file) {
        if (file == null) {
            return null;
        }
        String[] stringArray = this.getFilters();
        if (stringArray.length <= 0) {
            return file;
        }
        String string = ExtensionFileFilter.getExtension(file);
        if (string != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return file;
            }
        }
        String string2 = file.getAbsolutePath();
        string2 = string2 + "." + stringArray[0];
        return new File(string2);
    }

    public void addExtension(String string) {
        if (string == null) {
            return;
        }
        this.d_filters.add(string.toLowerCase());
        this.d_fullDescription = null;
    }

    public String[] getFilters() {
        String[] stringArray = new String[this.d_filters.size()];
        return this.d_filters.toArray(stringArray);
    }

    public String getDescription() {
        if (this.d_fullDescription == null) {
            if (this.d_description == null || this.isExtensionListInDescription()) {
                this.d_fullDescription = this.d_description == null ? "(" : this.d_description + " (";
                int n = this.d_filters.size();
                if (n > 0) {
                    this.d_fullDescription = this.d_fullDescription + "." + this.d_filters.get(0);
                    for (int i = 1; i < n; ++i) {
                        this.d_fullDescription = this.d_fullDescription + ", ." + this.d_filters.get(i);
                    }
                }
                this.d_fullDescription = this.d_fullDescription + ")";
            } else {
                this.d_fullDescription = this.d_description;
            }
        }
        return this.d_fullDescription;
    }

    public void setDescription(String string) {
        this.d_description = string;
        this.d_fullDescription = null;
    }

    public String getPartialDescription() {
        return this.d_description;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.d_useExtensionsInDescription = bl;
        this.d_fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.d_useExtensionsInDescription;
    }

    public String toString() {
        return this.getDescription();
    }
}

