/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import thunderheadeng.Intl;
import thunderheadeng.io.TeciEncrypt;

public class DecryptInputStream
extends InputStream
implements Closeable {
    private final InputStream d_stream;
    private final TeciEncrypt.Type d_type;
    private final long d_dataLen;
    private DecryptData d_data;
    private DecryptData d_markedData;

    public static boolean isEncryped(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            return false;
        }
        try {
            Header header = DecryptInputStream.readHeader(inputStream, true);
            return header.type.encrypted;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Header getEncryptionHeader(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            return null;
        }
        try {
            return DecryptInputStream.readHeader(inputStream, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DecryptInputStream(InputStream inputStream) throws IOException {
        this.d_stream = !inputStream.markSupported() ? new BufferedInputStream(inputStream) : inputStream;
        Header header = DecryptInputStream.readHeader(this.d_stream, false);
        this.d_type = header != null ? header.type : TeciEncrypt.Type.UNENCRYPTED;
        this.d_dataLen = header != null ? header.dataLen : 0L;
        int n = 0;
        switch (this.d_type) {
            case SIMPLE: {
                n = 4;
            }
        }
        this.d_data = new DecryptData(n);
        this.d_markedData = null;
    }

    @Override
    public void close() throws IOException {
        this.d_stream.close();
    }

    public TeciEncrypt.Type getType() {
        return this.d_type;
    }

    @Override
    public boolean markSupported() {
        return this.d_stream.markSupported();
    }

    @Override
    public synchronized void mark(int n) {
        this.d_markedData = this.d_data.clone();
        this.d_stream.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.d_markedData == null) {
            throw new IOException(Intl.intl("DecryptInputStream.reset() was called when stream was not previously marked."));
        }
        this.d_data = this.d_markedData.clone();
        this.d_stream.reset();
    }

    @Override
    public int available() throws IOException {
        return Math.min((int)Math.min(Integer.MAX_VALUE, this.d_dataLen - this.d_data.readPos), this.d_stream.available());
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        if (!this.d_type.encrypted) {
            return this.d_stream.skip(l);
        }
        if (this.d_data.readPos + l > this.d_dataLen) {
            l = this.d_dataLen - this.d_data.readPos;
        }
        long l2 = (this.d_data.readPos + l) % (long)this.d_data.buffer.length;
        long l3 = l - l2;
        long l4 = this.d_stream.skip(l3);
        this.d_data.readPos += l4;
        if (l4 < l3) {
            throw new IOException(Intl.intl("Stream could not be skipped by expected amount."));
        }
        if (l2 > 0L) {
            assert (this.d_data.readPos < this.d_dataLen);
            this.decrypt();
            this.d_data.readPos += l2;
        }
        return l;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        this.read(byArray);
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.d_type == TeciEncrypt.Type.UNENCRYPTED) {
            return this.d_stream.read(byArray, n, n2);
        }
        if ((n2 = (int)Math.min(this.d_dataLen - this.d_data.readPos, (long)n2)) == 0) {
            return -1;
        }
        int n3 = n2;
        while (n3 > 0) {
            this.decrypt();
            int n4 = (int)(this.d_data.decryptEnd - this.d_data.readPos);
            int n5 = Math.min(n3, n4);
            int n6 = (int)(this.d_data.readPos - this.d_data.decryptStart);
            System.arraycopy(this.d_data.buffer, n6, byArray, n, n5);
            this.d_data.readPos += (long)n5;
            n3 -= n5;
            n += n5;
        }
        return n2;
    }

    protected void decrypt() throws IOException {
        if (this.d_data.readPos >= this.d_data.decryptStart && this.d_data.readPos < this.d_data.decryptEnd) {
            return;
        }
        long l = this.d_data.buffer.length;
        long l2 = this.d_data.readPos / l * l;
        this.d_stream.read(this.d_data.buffer);
        switch (this.d_type) {
            case SIMPLE: {
                int n = TeciEncrypt.getSimpleShift();
                byte[] byArray = TeciEncrypt.getSimpleMask();
                TeciEncrypt.eor(this.d_data.buffer, byArray);
                TeciEncrypt.rorInverted(this.d_data.buffer, n);
            }
        }
        this.d_data.decryptStart = l2;
        this.d_data.decryptEnd = this.d_data.decryptStart + (long)this.d_data.buffer.length;
    }

    protected static Header readHeader(InputStream inputStream, boolean bl) throws IOException {
        assert (inputStream.markSupported());
        byte[] byArray = TeciEncrypt.getHeader();
        inputStream.mark(byArray.length + 4);
        try {
            DataInputStream dataInputStream;
            int n;
            byte[] byArray2 = new byte[byArray.length];
            int n2 = inputStream.read(byArray2);
            if (n2 == byArray.length && Arrays.equals(byArray, byArray2) && (n = (dataInputStream = new DataInputStream(inputStream)).readInt()) < TeciEncrypt.Type.values().length) {
                long l = dataInputStream.readLong();
                if (bl) {
                    inputStream.reset();
                }
                return new Header(TeciEncrypt.Type.values()[n], l);
            }
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw iOException;
        }
        inputStream.reset();
        return new Header(TeciEncrypt.Type.UNENCRYPTED, 0L);
    }

    protected static class DecryptData
    implements Cloneable {
        public byte[] buffer;
        public long readPos;
        public long decryptStart;
        public long decryptEnd;

        public DecryptData(int n) {
            this.buffer = new byte[n];
            this.readPos = 0L;
            this.decryptEnd = 0L;
            this.decryptStart = 0L;
        }

        public DecryptData clone() {
            try {
                DecryptData decryptData = (DecryptData)super.clone();
                decryptData.buffer = Arrays.copyOf(this.buffer, this.buffer.length);
                return decryptData;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static class Header {
        public final TeciEncrypt.Type type;
        public final long dataLen;

        public Header(TeciEncrypt.Type type, long l) {
            this.type = type;
            this.dataLen = l;
        }
    }
}

