/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;

public class CopyFile {
    public static void copy(File file, File file2) throws IOException {
        CopyFile.copyFileChannel(file, file2, file.length());
    }

    public static void copyFileStream(File file, File file2) throws IOException {
        CopyFile.copyFileStream(file, file2, 0x200000);
    }

    public static void copyFileStream(File file, File file2, int n) throws IOException {
        if (FilenameManager.equal(file, file2)) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[n];
        int n2 = fileInputStream.read(byArray);
        while (n2 != -1) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileChannel(File file, File file2, long l) throws IOException {
        if (FilenameManager.equal(file, file2)) {
            return;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel = fileInputStream.getChannel();
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            long l2 = fileChannel.size();
            for (long i = 0L; i < l2; i += fileChannel.transferTo(i, l, fileChannel2)) {
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilently(fileInputStream);
            IOUtil.closeSilently(fileOutputStream);
            throw throwable;
        }
        IOUtil.closeSilently(fileInputStream);
        IOUtil.closeSilently(fileOutputStream);
    }
}

