/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer d_buffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.d_buffer = byteBuffer.duplicate();
    }

    @Override
    public synchronized void mark(int n) {
        this.d_buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.d_buffer.reset();
    }

    @Override
    public int available() throws IOException {
        return this.d_buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (this.d_buffer.remaining() == 0) {
            return -1;
        }
        return this.d_buffer.get();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.d_buffer.remaining();
        if (n == 0) {
            return -1;
        }
        int n2 = Math.min(n, byArray.length);
        this.d_buffer.get(byArray, 0, n2);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.d_buffer.remaining();
        if (n3 == 0) {
            return -1;
        }
        int n4 = Math.min(n3, n2);
        this.d_buffer.get(byArray, n, n4);
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        int n = this.d_buffer.remaining();
        int n2 = Math.min(n, (int)Math.min(Integer.MAX_VALUE, l));
        this.d_buffer.position(this.d_buffer.position() + n2);
        return n2;
    }
}

