/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageInfo;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable,
IImage {
    static final long serialVersionUID = 1L;
    private final String d_filename;
    private final IInfo d_iinfo;
    private final IStreamSrc d_source;

    protected Image(String string, IStreamSrc iStreamSrc, IInfo iInfo) {
        this.d_filename = string;
        this.d_iinfo = iInfo;
        this.d_source = iStreamSrc;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public String getFilename() {
        return this.d_filename;
    }

    @Override
    public int getHeight() {
        return this.d_iinfo.height;
    }

    @Override
    public int getWidth() {
        return this.d_iinfo.width;
    }

    @Override
    public boolean hasTransparency() {
        return this.d_iinfo.hasTransparency;
    }

    @Override
    public int getBitsPerPixel() {
        return this.d_iinfo.bpp;
    }

    @Override
    public IStreamSrc getSource() {
        return this.d_source;
    }

    public static Image loadUnchecked(String string, IStreamSrc iStreamSrc) {
        IInfo iInfo = null;
        try {
            iInfo = Image.retrieveImageInfo(iStreamSrc);
        }
        catch (IOException iOException) {
            iInfo = new IInfo();
        }
        return new Image(string, iStreamSrc, iInfo);
    }

    public static Image load(String string, IStreamSrc iStreamSrc) throws IOException {
        IInfo iInfo = Image.retrieveImageInfo(iStreamSrc);
        return new Image(string, iStreamSrc, iInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IInfo retrieveImageInfo(IStreamSrc iStreamSrc) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = iStreamSrc.open(0);
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setInput(inputStream);
            if (!imageInfo.check()) {
                IInfo iInfo = new IInfo();
                return iInfo;
            }
            IInfo iInfo = new IInfo(imageInfo.getWidth(), imageInfo.getHeight(), imageInfo.getBitsPerPixel(), imageInfo.hasTransparency());
            return iInfo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] compress(BufferedImage bufferedImage) throws IOException {
        CustomByteArrayOutputStream customByteArrayOutputStream = new CustomByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", customByteArrayOutputStream);
        return customByteArrayOutputStream.toByteArray();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(Version.curr().ordinal());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        IStreamSrc iStreamSrc;
        Image image;
        HashableImage hashableImage;
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        if (this.d_filename != null && new File(this.d_filename).exists() && (hashableImage = new HashableImage(this)).equals(image = Image.loadUnchecked(this.d_filename, iStreamSrc = FileSystem.INSTANCE.getStreamSrc(this.d_filename, 3)))) {
            ImageManager.registerImage(this.d_filename, this);
        }
    }

    public static ByteBuffer allocate(long l) {
        if (l == 0L || l > Integer.MAX_VALUE) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)l);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    protected static class IInfo
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final int width;
        public final int height;
        public final int bpp;
        public final boolean hasTransparency;

        public IInfo() {
            this(0, 0, 0, false);
        }

        public IInfo(int n, int n2, int n3, boolean bl) {
            this.width = n;
            this.height = n2;
            this.bpp = n3;
            this.hasTransparency = bl;
        }
    }

    private static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int getSize() {
            return this.count;
        }
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

