/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public interface IImage {
    default public boolean isCached() {
        return this.getSource().isLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isValid() {
        if (this.isCached()) {
            return true;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getSource().open(0);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    default public IImage cacheImage() {
        if (this.isCached()) {
            return this;
        }
        try {
            ByteBuffer byteBuffer = (ByteBuffer)IOUtil.loadData((IStreamSrc)this.getSource(), (int)1, (boolean)true, (ByteOrder)ByteOrder.nativeOrder()).v1;
            IStreamSrc iStreamSrc = this.getSource().refilter(new ByteBufferStreamSrc(byteBuffer));
            return Image.loadUnchecked(this.getFilename(), iStreamSrc);
        }
        catch (IOException iOException) {
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public BufferedImage toBufferedImage() {
        InputStream inputStream = null;
        try {
            inputStream = this.getSource().open(0);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean save(String string, int n) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            this.save(fileOutputStream, n);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void save(OutputStream outputStream, int n) throws IOException {
        IStreamSrc iStreamSrc = this.getSource();
        byte[] byArray = new byte[8192];
        try (InputStream inputStream = iStreamSrc.open(n);){
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
        }
    }

    default public HashableImage makeHashable() {
        return new HashableImage(this);
    }

    public String getFilename();

    public int getHeight();

    public int getWidth();

    public boolean hasTransparency();

    public int getBitsPerPixel();

    public IStreamSrc getSource();
}

