/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.io.IOException;
import thunderheadeng.image.IImage;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class HashableImage
implements IImage {
    public final IImage image;

    public HashableImage(IImage iImage) {
        this.image = iImage;
    }

    public boolean equals(Object object) {
        return HashableImage.equalsImpl(this, object);
    }

    public static boolean equalsImpl(HashableImage hashableImage, Object object) {
        if (hashableImage == object) {
            return true;
        }
        if (!(object instanceof IImage)) {
            return false;
        }
        IImage iImage = (IImage)object;
        return hashableImage.getWidth() == iImage.getWidth() && hashableImage.getHeight() == iImage.getHeight() && HashableImage.getFileSize(hashableImage, 0) == HashableImage.getFileSize(iImage, 0);
    }

    public int hashCode() {
        return (int)HashableImage.getFileSize(this, 0) + this.getWidth() + this.getHeight();
    }

    private static long getFileSize(IImage iImage, int n) {
        try {
            return iImage.getSource().getSize(n);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public String getFilename() {
        return this.image.getFilename();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public boolean hasTransparency() {
        return this.image.hasTransparency();
    }

    @Override
    public int getBitsPerPixel() {
        return this.image.getBitsPerPixel();
    }

    @Override
    public IStreamSrc getSource() {
        return this.image.getSource();
    }

    @Override
    public HashableImage makeHashable() {
        return this;
    }
}

