/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.image;

import java.io.IOException;
import thunderheadeng.image.IImage;
import thunderheadeng.image.IImageCreator;
import thunderheadeng.image.Image;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class FileImageCreator
implements IImageCreator {
    public static final int OPT_CACHE_IMAGE_DATA = 2;
    private final IFileSystem d_fileSystem;
    private final int d_options;
    private final int d_fsOptions;

    public FileImageCreator(IFileSystem iFileSystem, int n, int n2) {
        this.d_fileSystem = iFileSystem;
        this.d_options = n;
        this.d_fsOptions = n2;
    }

    public int getOptions() {
        return this.d_options;
    }

    protected boolean opt(int n) {
        return (this.d_options & n) == n;
    }

    @Override
    public IImage create(String string) {
        try {
            IStreamSrc iStreamSrc = this.d_fileSystem.getStreamSrc(string, this.d_fsOptions);
            IImage iImage = Image.load(string, iStreamSrc);
            if (this.opt(2)) {
                iImage = iImage.cacheImage();
            }
            return iImage;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

