/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.wizard;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.wizard.AWizardCard;

public class WizardDlg<T>
extends JDialog
implements Observer {
    public static final int FINISH = 1;
    public static final int CANCEL = 8;
    private Stack<AWizardCard> d_prevCards = new Stack();
    private AWizardCard<T> d_card;
    private TopBanner d_banner;
    private ButtonBar d_buttonBar;
    private T d_data;
    private int d_status;

    public WizardDlg(Window window, String string, String string2, AWizardCard<T> aWizardCard) {
        super(window, string, JDialog.DEFAULT_MODALITY_TYPE);
        this.d_card = aWizardCard;
        this.d_data = null;
        this.d_status = -1;
        this.d_banner = new TopBanner();
        this.d_buttonBar = new ButtonBar();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        guiSeparator guiSeparator2 = new guiSeparator();
        guiSeparator guiSeparator3 = new guiSeparator();
        GridBagUtil.add(container, this.d_banner, 0, 0, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0);
        GridBagUtil.add(container, guiSeparator2, 0, 1, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0);
        GridBagUtil.add(container, this.d_card, 0, 2, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        GridBagUtil.add(container, guiSeparator3, 0, 3, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0);
        GridBagUtil.add(container, this.d_buttonBar, 0, 4, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0);
        this.d_banner.setTitle(string2);
        this.d_banner.setSubTitle(this.d_card.getSubTitle());
        this.d_card.addObserver(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WizardDlg.this.cancel();
            }
        });
    }

    public T getData() {
        return this.d_data;
    }

    public int doModal() {
        this.d_status = 8;
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.d_status;
    }

    public void init(T t) {
        this.d_data = t;
        this.d_card.initFrom(this.d_data);
        this.updateButtons();
    }

    private void switchTo(AWizardCard aWizardCard) {
        Container container = this.getContentPane();
        container.remove(this.d_card);
        GridBagUtil.add(container, aWizardCard, 0, 2, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        container.validate();
        container.repaint();
        this.d_card.removeObserver(this);
        this.d_card = aWizardCard;
        this.d_card.initFrom(this.d_data);
        this.d_card.addObserver(this);
        this.updateBanner();
        this.updateButtons();
    }

    public void back() {
        this.d_card.cancel();
        this.switchTo(this.d_prevCards.pop());
    }

    public void next() {
        this.next(true);
    }

    public void skip() {
        this.next(false);
    }

    private void next(boolean bl) {
        if (this.d_card.validateData(true, true)) {
            this.d_card.saveTo(this.d_data);
            if (bl) {
                this.d_prevCards.push(this.d_card);
            }
            this.switchTo(this.d_card.getNext());
        }
    }

    public void finish() {
        if (this.d_card.validateData(true, true)) {
            this.d_card.saveTo(this.d_data);
            this.d_status = 1;
            this.setVisible(false);
        }
    }

    public boolean cancel() {
        String string = Intl.intl("Are you sure you want to cancel?");
        int n = JOptionPane.showConfirmDialog(this, string, Intl.intl("Confirm Cancel"), 0, 3);
        if (n != 0) {
            return false;
        }
        this.d_card.cancel();
        this.d_status = 8;
        this.setVisible(false);
        return true;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.updateBanner();
        this.updateButtons();
        this.repaint();
    }

    private void updateBanner() {
        this.d_banner.setSubTitle(this.d_card.getSubTitle());
    }

    private void updateButtons() {
        this.d_buttonBar.back.setEnabled(!this.d_prevCards.isEmpty());
        this.d_buttonBar.next.setEnabled(this.d_card.isActionEnabled(this.d_data, 1));
        this.d_buttonBar.finish.setEnabled(this.d_card.isActionEnabled(this.d_data, 4));
        this.d_buttonBar.cancel.setEnabled(this.d_card.isActionEnabled(this.d_data, 0));
    }

    public void setBannerIcon(Icon icon) {
        this.d_banner.setIcon(icon);
    }

    private static class TopBanner
    extends guiPanel {
        private String d_title;
        private String d_subTitle;
        private Icon d_icon;

        public TopBanner() {
            this.setPreferredSize(new Dimension(10, 59));
            this.d_title = null;
            this.d_subTitle = null;
            this.d_icon = null;
        }

        public void setTitle(String string) {
            this.d_title = string;
        }

        public void setSubTitle(String string) {
            this.d_subTitle = string;
        }

        public void setIcon(Icon icon) {
            this.d_icon = icon;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.WHITE, this.getWidth(), 0.0f, new Color(0.61f, 0.76f, 0.93f));
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.d_icon != null) {
                int n3 = this.d_icon.getIconWidth();
                int n4 = this.d_icon.getIconHeight();
                n2 = (this.getHeight() - n4) / 2;
                n = this.getWidth() - (n2 > 0 ? n2 : 8) - n3;
                this.d_icon.paintIcon(this, graphics2D, n, n2);
            }
            graphics2D.setFont(this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds("M", graphics2D);
            graphics2D.setColor(Color.BLACK);
            n2 = (int)rectangle2D.getWidth() * 2;
            n = (int)rectangle2D.getHeight() * 3 / 2;
            graphics2D.setFont(this.getFont().deriveFont(1));
            graphics2D.drawString(this.d_title, n2, n);
            graphics2D.setFont(this.getFont());
            graphics2D.drawString(this.d_subTitle, n2 += (int)rectangle2D.getWidth() * 2, n += (int)rectangle2D.getHeight() * 5 / 4);
        }
    }

    private class ButtonBar
    extends guiPanel
    implements ActionListener {
        private final JButton back = new JButton(Intl.intl("< Back"));
        private final JButton next = new JButton(Intl.intl("Next >"));
        private final JButton finish = new JButton(Intl.intl("Finish"));
        private final JButton cancel = new JButton(Intl.intl("Cancel"));

        public ButtonBar() {
            this.back.addActionListener(this);
            this.next.addActionListener(this);
            this.finish.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setLayout(new GridBagLayout());
            GridBagUtil.add(this, Box.createGlue(), 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
            GridBagUtil.add(this, Box.createHorizontalStrut(100), 1, 0, 1, 1, 0, 0, 0, 0, 0, 1.0, 0.0);
            GridBagUtil.add(this, this.back, 2, 0, 1, 1, 12, 0, 12, 2, 0, 0.0, 0.0);
            GridBagUtil.add(this, this.next, 3, 0, 1, 1, 12, 0, 12, 12, 0, 0.0, 0.0);
            GridBagUtil.add(this, this.finish, 4, 0, 1, 1, 12, 0, 12, 12, 0, 0.0, 0.0);
            GridBagUtil.add(this, this.cancel, 5, 0, 1, 1, 12, 0, 12, 12, 0, 0.0, 0.0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.back) {
                WizardDlg.this.back();
                return;
            }
            if (actionEvent.getSource() == this.next) {
                WizardDlg.this.next();
                return;
            }
            if (actionEvent.getSource() == this.finish) {
                WizardDlg.this.finish();
                return;
            }
            if (actionEvent.getSource() == this.cancel) {
                WizardDlg.this.cancel();
                return;
            }
        }
    }
}

