/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.video;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.InvisibleSplitPane;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSliderVal;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;
import thunderheadeng.video.IVideoCompressor;
import thunderheadeng.video.IVideoCompressors;

public class VideoCompressorPnl
extends guiPanel {
    private final JList<IVideoCompressor> d_compressorsList;
    private final guiSliderVal d_quality;
    private final guiLabel d_defQualityLbl;
    private final guiCheckBox d_dataRateCB;
    private final ValueField<UnitDouble> d_dataRateFld;
    private final guiCheckBox d_keyframeCB;
    private final ValueField<Integer> d_keyframeFld;
    private final guiLabel d_defKeyframeLbl;
    private final JButton d_configureBtn;
    private final JButton d_aboutBtn;
    private IVideoCompressor d_selCompressor;

    public VideoCompressorPnl(IVideoCompressors.Type type, List<IVideoCompressor> list, IUnitSrc iUnitSrc) {
        ArrayList<IVideoCompressor> arrayList = new ArrayList<IVideoCompressor>(list);
        arrayList.sort((iVideoCompressor, iVideoCompressor2) -> iVideoCompressor.get(IVideoCompressor.DESCRIPTION).compareToIgnoreCase(iVideoCompressor2.get(IVideoCompressor.DESCRIPTION)));
        this.d_compressorsList = new JList<IVideoCompressor>(theUtil.toArray(arrayList, IVideoCompressor.class));
        this.d_compressorsList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                IVideoCompressor iVideoCompressor = (IVideoCompressor)object;
                this.setText(iVideoCompressor.get(IVideoCompressor.DESCRIPTION));
                return this;
            }
        });
        this.d_compressorsList.setSelectionMode(0);
        this.d_compressorsList.addListSelectionListener(listSelectionEvent -> {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.syncSelection();
        });
        JScrollPane jScrollPane = new JScrollPane(this.d_compressorsList);
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        this.d_quality = new guiSliderVal();
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Default Quality:"));
        this.d_defQualityLbl = new guiLabel("");
        this.group(IVideoCompressor.QUALITY, new JComponent[]{this.d_quality, guiLabel2, this.d_defQualityLbl});
        this.d_dataRateCB = new guiCheckBox(Intl.intl("Specify target data rate:"));
        this.d_dataRateFld = ValueFields.udFld(iUnitSrc, UnitDoubleVR.above(0.0, SI.BIT.divide(SI.SECOND), false));
        this.group(IVideoCompressor.DATARATE, new JComponent[]{this.d_dataRateCB, this.d_dataRateFld});
        this.d_keyframeCB = new guiCheckBox(Intl.intl("Keyframe interval:"));
        this.d_keyframeFld = ValueFields.intFld(IntVR.above(1, true));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("frames"));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Default Keyframe Interval:"));
        this.d_defKeyframeLbl = new guiLabel("");
        this.group(IVideoCompressor.KEYFRAME_INTERVAL, new JComponent[]{this.d_keyframeCB, this.d_keyframeFld, guiLabel3, guiLabel4, this.d_defKeyframeLbl});
        this.d_configureBtn = new JButton(Intl.intl("Configure..."));
        this.d_configureBtn.addActionListener(actionEvent -> this.d_selCompressor.showPropsDlg(this));
        this.d_aboutBtn = new JButton(Intl.intl("About..."));
        this.d_aboutBtn.addActionListener(actionEvent -> this.d_selCompressor.showAboutDlg(this));
        guiUtil.link((AbstractButton)this.d_dataRateCB, this.d_dataRateFld);
        guiUtil.link((AbstractButton)this.d_keyframeCB, this.d_keyframeFld, guiLabel3);
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(guiLabel2, this.d_defQualityLbl);
        gridBagHelper.addRow(guiLabel4, this.d_defKeyframeLbl);
        gridBagHelper.finalizeRows();
        guiPanel guiPanel3 = new guiPanel();
        gridBagHelper = new GridBagHelper(guiPanel3);
        gridBagHelper.add(this.d_configureBtn, this.d_aboutBtn);
        gridBagHelper.finalizeRows();
        guiPanel guiPanel4 = new guiPanel();
        gridBagHelper = new GridBagHelper(guiPanel4);
        gridBagHelper.addRow(Intl.intl("Quality:"), this.d_quality, 1.0, 0);
        guiPanel guiPanel5 = new guiPanel();
        gridBagHelper = new GridBagHelper(guiPanel5);
        gridBagHelper.addRow(guiPanel4, 1.0, 0);
        gridBagHelper.addRow(this.d_dataRateCB, this.d_dataRateFld, 1.0);
        gridBagHelper.addRow(this.d_keyframeCB, this.d_keyframeFld, 1.0, guiLabel3);
        gridBagHelper.addFilledRow(guiPanel2);
        gridBagHelper.addRow(new Object[]{guiPanel3, GridBagHelper.Anchor.CENTER, 0.0, 0});
        gridBagHelper.finalizeRows();
        guiPanel5.setMinimumSize(guiPanel5.getPreferredSize());
        InvisibleSplitPane invisibleSplitPane = new InvisibleSplitPane(1, jScrollPane, guiPanel5);
        this.setLayout(new BorderLayout());
        this.add((Component)invisibleSplitPane, "Center");
        if (!arrayList.isEmpty()) {
            this.d_compressorsList.setSelectedIndex(0);
        } else {
            this.setEnabled(false);
        }
    }

    private void syncSelection() {
        IVideoCompressor iVideoCompressor = this.d_compressorsList.getSelectedValue();
        if (iVideoCompressor != null && iVideoCompressor != this.d_selCompressor) {
            if (this.d_selCompressor != null) {
                this.save(this.d_selCompressor);
            }
            this.d_selCompressor = iVideoCompressor;
            this.syncCompressor(iVideoCompressor);
        }
    }

    private void syncCompressor(IVideoCompressor iVideoCompressor) {
        int n;
        this.syncButtons(iVideoCompressor);
        boolean bl = iVideoCompressor.isSupported(IVideoCompressor.QUALITY);
        this.setGroupEnabled(IVideoCompressor.QUALITY, bl);
        if (bl) {
            this.d_quality.setValue((float)iVideoCompressor.get(IVideoCompressor.QUALITY).abs().get(Unit.ONE));
            this.d_defQualityLbl.setText(Global.format(iVideoCompressor.getDefault(IVideoCompressor.QUALITY).abs().convert(NonSI.PERCENT)));
        } else {
            this.d_quality.setValue(1.0f);
            this.d_defQualityLbl.setText("");
        }
        boolean bl2 = iVideoCompressor.isSupported(IVideoCompressor.KEYFRAME_INTERVAL);
        this.setGroupEnabled(IVideoCompressor.KEYFRAME_INTERVAL, bl2);
        if (bl2) {
            n = iVideoCompressor.get(IVideoCompressor.KEYFRAME_INTERVAL);
            this.d_keyframeCB.setSelected(n >= 0);
            this.d_keyframeFld.setValue(Math.abs(n));
            this.d_defKeyframeLbl.setText(Integer.toString(Math.abs(iVideoCompressor.getDefault(IVideoCompressor.KEYFRAME_INTERVAL))));
        } else {
            this.d_keyframeCB.setSelected(false);
            this.d_keyframeFld.setValue(null);
            this.d_defKeyframeLbl.setText("");
        }
        n = iVideoCompressor.isSupported(IVideoCompressor.DATARATE) ? 1 : 0;
        this.setGroupEnabled(IVideoCompressor.DATARATE, n != 0);
        if (n) {
            UnitDouble unitDouble = iVideoCompressor.get(IVideoCompressor.DATARATE);
            this.d_dataRateCB.setSelected(unitDouble.getValueNoUnit() >= 0.0);
            this.d_dataRateFld.setValue(unitDouble.abs());
        } else {
            this.d_dataRateCB.setSelected(false);
            this.d_dataRateFld.setValue(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.syncButtons(this.d_selCompressor);
    }

    private void syncButtons(IVideoCompressor iVideoCompressor) {
        if (this.isDisplayable()) {
            this.d_aboutBtn.setEnabled(iVideoCompressor.hasAboutDlg(this));
            this.d_configureBtn.setEnabled(iVideoCompressor.hasPropsDlg(this));
        }
    }

    public void load(IVideoCompressor iVideoCompressor) {
        if (iVideoCompressor == null) {
            this.d_compressorsList.setSelectedIndex(-1);
        } else {
            this.d_compressorsList.setSelectedValue(iVideoCompressor, true);
        }
    }

    public IVideoCompressor save() {
        IVideoCompressor iVideoCompressor = this.d_selCompressor;
        if (iVideoCompressor == null) {
            return null;
        }
        this.save(iVideoCompressor);
        return iVideoCompressor;
    }

    private void save(IVideoCompressor iVideoCompressor) {
        if (iVideoCompressor.isSupported(IVideoCompressor.DATARATE)) {
            UnitDouble unitDouble = (UnitDouble)this.d_dataRateFld.getValue();
            if (!this.d_dataRateCB.isSelected()) {
                unitDouble = unitDouble.negate();
            }
            iVideoCompressor.set(IVideoCompressor.DATARATE, unitDouble);
        }
        if (iVideoCompressor.isSupported(IVideoCompressor.KEYFRAME_INTERVAL)) {
            int n = (Integer)this.d_keyframeFld.getValue();
            if (!this.d_keyframeCB.isSelected()) {
                n = -n;
            }
            iVideoCompressor.set(IVideoCompressor.KEYFRAME_INTERVAL, n);
        }
        if (iVideoCompressor.isSupported(IVideoCompressor.QUALITY)) {
            iVideoCompressor.set(IVideoCompressor.QUALITY, new UnitDouble(this.d_quality.getValue(), Unit.ONE));
        }
    }

    static {
        SI.GIGA(SI.BIT).label("Gb");
        SI.MEGA(SI.BIT).label("Mb");
        SI.KILO(SI.BIT).label("Kb");
        SI.GIGA(NonSI.BYTE).label("GB");
        SI.MEGA(NonSI.BYTE).label("MB");
        SI.KILO(NonSI.BYTE).label("KB");
    }
}

