/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.value;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JComponent;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.value.IValEditor;

public abstract class AValEditor<T>
extends guiPanel
implements IValEditor<T>,
PropertyChangeListener {
    private final Class<T> d_type;
    private T d_value;

    public AValEditor(Class<T> clazz) {
        this.d_type = clazz;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Class<T> getType() {
        return this.d_type;
    }

    protected <T2> T2 registerEd(T2 T2) {
        if (T2 instanceof Component) {
            ((Component)T2).addPropertyChangeListener("value", this);
        } else if (T2 instanceof IValEditor) {
            ((IValEditor)T2).addValueListener(this);
        }
        return T2;
    }

    protected <T2> T2 unregisterEd(T2 T2) {
        if (T2 instanceof Component) {
            ((Component)T2).removePropertyChangeListener("value", this);
        } else if (T2 instanceof IValEditor) {
            ((IValEditor)T2).removeValueListener(this);
        }
        return T2;
    }

    @Override
    public void setValue(T t) {
        if (Objects.equals(t, this.d_value)) {
            return;
        }
        T t2 = this.d_value;
        this.d_value = t;
        this.loadValue(this.d_value);
        this.fireValueChange(t2, this.d_value);
        this.setModified(true);
    }

    @Override
    public T getValue() {
        return this.d_value;
    }

    protected abstract void loadValue(T var1);

    protected abstract T saveValue();

    protected void updateValue() {
        if (this.validateData(false, false)) {
            this.setValue(this.saveValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateValue();
    }

    protected void fireValueChange(T t, T t2) {
        this.firePropertyChange("value", t, t2);
    }
}

