/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EventListener;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.DefaultDeviceMgr;
import thunderheadeng.gui.tool.IDeviceListener;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.IToolListener;
import thunderheadeng.gui.tool.PropertyEditor;
import thunderheadeng.gui.tool.SwingKeyboard;
import thunderheadeng.gui.tool.SwingMouse;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class ToolManager
implements IToolListener {
    private final Component d_target;
    private Tool d_currentTool;
    private final ToolPropsAction d_propsAction;
    private final ButtonGroup d_toolbarGroup;
    private final ButtonGroup d_menuGroup;
    private final Map<Tool, ToolProps> d_tools;
    private final ToolActivatedListener d_toolListener;
    private final DefaultDeviceMgr d_devices;
    private final EventDispatcher d_eventDispatcher;
    private final FocusListener d_focusListener;
    private final Deque<ToolMode> d_toolStack;
    private final Set<ToolChangeListener> d_toolChangeListeners;
    private static final ImageIcon s_stickyIcon = guiUtil.loadTeciIcon("pin.png");

    public ToolManager(Component component) {
        this.d_target = component;
        this.d_tools = new IdentityHashMap<Tool, ToolProps>();
        this.d_propsAction = new ToolPropsAction();
        this.d_toolbarGroup = new ButtonGroup();
        this.d_menuGroup = new ButtonGroup();
        this.d_toolListener = new ToolActivatedListener();
        this.d_devices = new DefaultDeviceMgr(new SwingKeyboard(), new SwingMouse());
        this.d_eventDispatcher = new EventDispatcher(this.d_devices);
        this.d_toolChangeListeners = new LinkedIdentityHashSet<ToolChangeListener>();
        this.d_toolStack = new ArrayDeque<ToolMode>();
        this.d_focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ToolManager.this.getDevices().getKeyboard().clearPressedKeys();
                ToolManager.this.d_eventDispatcher.clearPressedKeys();
            }
        };
    }

    public IDeviceManager getDevices() {
        return this.d_devices;
    }

    public void addToolChangeListener(ToolChangeListener toolChangeListener) {
        this.d_toolChangeListeners.add(toolChangeListener);
    }

    public void removeToolChangeListener(ToolChangeListener toolChangeListener) {
        this.d_toolChangeListeners.remove(toolChangeListener);
    }

    public void addTool(Tool tool, String string, String string2, Icon icon) {
        this.addTool(tool, string, string2, icon, false, null);
    }

    public void addTool(Tool tool, String string, String string2, Icon icon, boolean bl, Object object) {
        ToolAction toolAction = new ToolAction(tool, string, string2, icon);
        toolAction.addPropertyChangeListener(this.d_toolListener);
        JToggleButton jToggleButton = this.createToolbarBtn(tool, toolAction);
        JRadioButtonMenuItem jRadioButtonMenuItem = this.createRadioItem(tool, toolAction);
        ToolProps toolProps = new ToolProps(toolAction, jToggleButton, jRadioButtonMenuItem, bl, object);
        this.d_tools.put(tool, toolProps);
    }

    public Collection<Tool> getTools() {
        return this.d_tools.keySet();
    }

    public void removeTool(Tool tool) {
        ToolProps toolProps;
        if (tool == this.d_currentTool) {
            this.setCurrentTool(null);
        }
        if ((toolProps = this.d_tools.remove(tool)) != null) {
            if (toolProps.menuItem != null) {
                this.d_menuGroup.remove(toolProps.menuItem);
            }
            if (toolProps.toolbarBtn != null) {
                this.d_toolbarGroup.remove(toolProps.toolbarBtn);
            }
        }
    }

    private JToggleButton createToolbarBtn(Tool tool, ToolAction toolAction) {
        JToggleButton jToggleButton = new JToggleButton(toolAction);
        if (toolAction.getIcon() != null) {
            jToggleButton.setText("");
        }
        this.d_toolbarGroup.add(jToggleButton);
        jToggleButton.addPropertyChangeListener(toolAction);
        return jToggleButton;
    }

    private JRadioButtonMenuItem createRadioItem(Tool tool, ToolAction toolAction) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(toolAction);
        this.d_menuGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addPropertyChangeListener(toolAction);
        return jRadioButtonMenuItem;
    }

    public ToolAction getToolAction(Tool tool) {
        ToolProps toolProps = this.d_tools.get(tool);
        if (toolProps != null) {
            return toolProps.action;
        }
        return null;
    }

    public AbstractButton getToolbarButton(Tool tool) {
        ToolProps toolProps = this.d_tools.get(tool);
        if (toolProps != null) {
            return toolProps.toolbarBtn;
        }
        return null;
    }

    public JMenuItem getMenuItem(Tool tool) {
        ToolProps toolProps = this.d_tools.get(tool);
        if (toolProps != null) {
            return toolProps.menuItem;
        }
        return null;
    }

    public void setCurrentTool(Tool tool) {
        this.setCurrentTool(tool, false);
    }

    public void setCurrentTool(Tool tool, boolean bl) {
        this.setCurrentTool(tool, true, false, !bl);
    }

    public void repaintTarget() {
        this.d_target.repaint();
    }

    public Tool getCurrentTool() {
        return this.d_currentTool;
    }

    public Tool getRootTool() {
        return this.d_toolStack.isEmpty() ? this.d_currentTool : this.d_toolStack.getLast().tool;
    }

    public Action getToolPropsAction() {
        return this.d_propsAction;
    }

    protected void setCurrentTool(Tool tool, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        if (tool == this.d_currentTool) {
            return;
        }
        Tool tool2 = this.d_currentTool;
        this.d_currentTool = tool;
        int n3 = n2 = this.d_currentTool != null ? this.getProps((Tool)this.d_currentTool).modal : 0;
        if (bl3) {
            int n4 = n = n2 != 0 ? 1 : 0;
            while (this.d_toolStack.size() > n) {
                ToolMode toolMode = this.d_toolStack.pop();
                toolMode.tool.removeToolListener(this);
                toolMode.tool.cancel();
                toolMode.tool.addToolListener(this);
                toolMode.end();
            }
        }
        if (this.d_currentTool != null) {
            n = n2;
            boolean bl4 = bl2 || n2 == 0;
            ToolMode toolMode = new ToolMode(this.d_currentTool, bl4, n != 0);
            this.d_toolStack.push(toolMode);
            toolMode.begin();
        }
        for (ToolChangeListener toolChangeListener : this.d_toolChangeListeners) {
            toolChangeListener.toolWillChanged(tool2, this.d_currentTool);
        }
        if (tool2 != null) {
            tool2.removeToolListener(this);
            if (this.d_target != null) {
                this.d_target.removeMouseMotionListener(this.d_eventDispatcher);
                this.d_target.removeMouseListener(this.d_eventDispatcher);
                this.d_target.removeKeyListener(this.d_eventDispatcher);
                this.d_target.removeMouseWheelListener(this.d_eventDispatcher);
                this.d_target.removeFocusListener(this.d_focusListener);
                this.d_eventDispatcher.setTool(null);
            }
            tool2.deactivate();
            this.getToolAction(tool2).setSelected(false);
        }
        this.d_propsAction.setEnabled(this.d_currentTool instanceof PropertyEditor);
        if (this.d_currentTool != null) {
            this.d_currentTool.activate();
            if (bl) {
                this.getToolAction(this.d_currentTool).setSelected(true);
            }
            if (this.d_target != null) {
                this.d_eventDispatcher.setTool(this.d_currentTool);
                this.d_target.addMouseMotionListener(this.d_eventDispatcher);
                this.d_target.addMouseListener(this.d_eventDispatcher);
                this.d_target.addKeyListener(this.d_eventDispatcher);
                this.d_target.addMouseWheelListener(this.d_eventDispatcher);
                this.d_target.addFocusListener(this.d_focusListener);
            }
            this.d_currentTool.addToolListener(this);
            this.d_currentTool.repaintSurface();
        }
    }

    public ToolProps getProps(Tool tool) {
        return this.d_tools.get(tool);
    }

    public void enableTool(Tool tool, boolean bl) {
        this.getToolAction(tool).setEnabled(bl);
        if (!bl && this.getCurrentTool() == tool) {
            assert (!this.d_toolStack.isEmpty());
            this.setCurrentTool(this.d_toolStack.getLast().tool, false);
        }
    }

    @Override
    public void toolEnded(Tool tool, boolean bl) {
        if (this.d_toolStack.size() <= 1 || !bl && this.d_toolStack.peek().isSticky()) {
            return;
        }
        ToolMode toolMode = this.d_toolStack.pop();
        assert (toolMode.tool == tool);
        toolMode.end();
        ToolMode toolMode2 = this.d_toolStack.pop();
        boolean bl2 = toolMode2.isSticky();
        toolMode2.end();
        this.setCurrentTool(toolMode2.tool, true, bl2, false);
    }

    public void cancelCurrentTool() {
        Tool tool = this.getCurrentTool();
        if (tool != null) {
            tool.cancel();
        }
    }

    public void setDeviceIntercept(IDeviceListener iDeviceListener) {
        this.d_eventDispatcher.setIntercept(iDeviceListener);
    }

    private static class ChainedDeviceListener
    implements IDeviceListener {
        private final List<EventListener> d_listeners;

        public ChainedDeviceListener(EventListener ... eventListenerArray) {
            this(Arrays.asList(eventListenerArray));
        }

        public ChainedDeviceListener(List<EventListener> list) {
            this.d_listeners = list;
        }

        private <T> Collection<T> filter(Class<T> clazz) {
            return theUtil.filter(this.d_listeners, clazz);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            for (MouseMotionListener mouseMotionListener : this.filter(MouseMotionListener.class)) {
                mouseMotionListener.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            for (MouseMotionListener mouseMotionListener : this.filter(MouseMotionListener.class)) {
                mouseMotionListener.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : this.filter(MouseListener.class)) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : this.filter(MouseListener.class)) {
                mouseListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : this.filter(MouseListener.class)) {
                mouseListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : this.filter(MouseListener.class)) {
                mouseListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            for (MouseListener mouseListener : this.filter(MouseListener.class)) {
                mouseListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            for (KeyListener keyListener : this.filter(KeyListener.class)) {
                keyListener.keyTyped(keyEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            for (KeyListener keyListener : this.filter(KeyListener.class)) {
                keyListener.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            for (KeyListener keyListener : this.filter(KeyListener.class)) {
                keyListener.keyReleased(keyEvent);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            for (MouseWheelListener mouseWheelListener : this.filter(MouseWheelListener.class)) {
                mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            }
        }
    }

    protected static class EventDispatcher
    implements IDeviceListener {
        private final IDeviceManager d_devcMgr;
        private final Set<Integer> d_pressedKeys;
        private final Set<Integer> d_pressedBtns;
        private IDeviceListener d_intercept;
        private Tool d_tool;
        private IDeviceListener d_eventListener;
        private IDeviceListener d_devicesListener;

        private EventDispatcher(IDeviceManager iDeviceManager) {
            this.d_devcMgr = iDeviceManager;
            this.d_pressedKeys = new HashSet<Integer>();
            this.d_pressedBtns = new HashSet<Integer>();
        }

        private static boolean isEnabled(ComponentEvent componentEvent) {
            Application application = Application.getApp();
            if (application == null) {
                return true;
            }
            return !application.isInputBlocking(componentEvent.getComponent());
        }

        public void setIntercept(IDeviceListener iDeviceListener) {
            this.d_intercept = iDeviceListener;
            this.updateListener();
        }

        public void setTool(Tool tool) {
            this.d_tool = tool;
            this.updateListener();
            this.d_pressedKeys.clear();
            this.d_pressedBtns.clear();
        }

        private void updateListener() {
            ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
            ArrayList<EventListener> arrayList2 = new ArrayList<EventListener>();
            BiConsumer<Object, List> biConsumer = (object, list) -> {
                if (object instanceof EventListener) {
                    list.add((EventListener)object);
                }
            };
            biConsumer.accept(this.d_devcMgr.getKeyboard(), arrayList2);
            biConsumer.accept(this.d_devcMgr.getMouse(), arrayList2);
            this.d_devicesListener = new ChainedDeviceListener(arrayList2);
            biConsumer.accept(this.d_intercept, arrayList);
            arrayList.add(this.d_tool);
            this.d_eventListener = arrayList.size() == 1 ? this.d_tool : new ChainedDeviceListener(arrayList);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.d_pressedKeys.add(keyEvent.getKeyCode())) {
                this.d_devicesListener.keyPressed(keyEvent);
                if (EventDispatcher.isEnabled(keyEvent)) {
                    this.d_eventListener.keyPressed(keyEvent);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.d_pressedKeys.remove(keyEvent.getKeyCode())) {
                this.d_devicesListener.keyReleased(keyEvent);
                if (EventDispatcher.isEnabled(keyEvent)) {
                    this.d_eventListener.keyReleased(keyEvent);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.d_devicesListener.keyTyped(keyEvent);
            if (EventDispatcher.isEnabled(keyEvent)) {
                this.d_eventListener.keyTyped(keyEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.d_pressedBtns.add(mouseEvent.getButton())) {
                this.d_devicesListener.mousePressed(mouseEvent);
                if (EventDispatcher.isEnabled(mouseEvent)) {
                    this.d_eventListener.mousePressed(mouseEvent);
                }
            }
        }

        private static boolean testBit(int n, int n2) {
            return (n & n2) == n2;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiersEx();
            boolean bl = EventDispatcher.testBit(n, 1024);
            boolean bl2 = EventDispatcher.testBit(n, 2048);
            boolean bl3 = EventDispatcher.testBit(n, 4096);
            if (bl && this.d_pressedBtns.contains(1) || bl2 && this.d_pressedBtns.contains(2) || bl3 && this.d_pressedBtns.contains(3)) {
                this.d_devicesListener.mouseDragged(mouseEvent);
                if (EventDispatcher.isEnabled(mouseEvent)) {
                    this.d_eventListener.mouseDragged(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.d_pressedBtns.remove(mouseEvent.getButton())) {
                this.d_devicesListener.mouseReleased(mouseEvent);
                if (EventDispatcher.isEnabled(mouseEvent)) {
                    this.d_eventListener.mouseReleased(mouseEvent);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.d_devicesListener.mouseClicked(mouseEvent);
            if (EventDispatcher.isEnabled(mouseEvent)) {
                this.d_eventListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.d_devicesListener.mouseEntered(mouseEvent);
            if (EventDispatcher.isEnabled(mouseEvent)) {
                this.d_eventListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.d_devicesListener.mouseExited(mouseEvent);
            if (EventDispatcher.isEnabled(mouseEvent)) {
                this.d_eventListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.d_devicesListener.mouseMoved(mouseEvent);
            if (EventDispatcher.isEnabled(mouseEvent)) {
                this.d_eventListener.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.d_devicesListener.mouseWheelMoved(mouseWheelEvent);
            if (EventDispatcher.isEnabled(mouseWheelEvent)) {
                this.d_eventListener.mouseWheelMoved(mouseWheelEvent);
            }
        }

        public void clearPressedKeys() {
            this.d_pressedKeys.clear();
        }
    }

    private class ToolMode {
        public final Tool tool;
        private final boolean d_stickyModifiable;
        private final MouseAdapter d_stickyListener;
        private boolean d_sticky = false;

        public ToolMode(Tool tool, boolean bl, boolean bl2) {
            this.tool = tool;
            this.d_stickyModifiable = bl2;
            this.d_stickyListener = this.d_stickyModifiable ? new MouseAdapter(){
                private boolean d_pressed = false;

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.d_pressed = true;
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && this.d_pressed) {
                        this.d_pressed = false;
                        ToolMode.this.setSticky(!ToolMode.this.isSticky());
                    }
                }
            } : null;
            this.d_sticky = bl;
        }

        public boolean isSticky() {
            return this.d_sticky;
        }

        public void setSticky(boolean bl) {
            if (!this.d_stickyModifiable) {
                return;
            }
            this.d_sticky = bl;
            AbstractButton abstractButton = ToolManager.this.getToolbarButton(this.tool);
            if (this.d_sticky) {
                ImageIcon imageIcon = abstractButton.getIcon() != null ? new DecoratedIcon(abstractButton.getIcon(), s_stickyIcon, 3) : s_stickyIcon;
                abstractButton.setIcon(imageIcon);
            } else {
                Icon icon = abstractButton.getIcon();
                if (icon instanceof DecoratedIcon) {
                    abstractButton.setIcon(((DecoratedIcon)icon).getBase());
                } else if (icon == s_stickyIcon) {
                    abstractButton.setIcon(null);
                }
            }
        }

        void begin() {
            this.setSticky(this.d_sticky);
            if (this.d_stickyListener != null) {
                ToolManager.this.getToolbarButton(this.tool).addMouseListener(this.d_stickyListener);
            }
        }

        void end() {
            if (this.d_stickyListener != null) {
                ToolManager.this.getToolbarButton(this.tool).removeMouseListener(this.d_stickyListener);
            }
            if (this.isSticky()) {
                this.setSticky(false);
            }
        }
    }

    public static interface ToolChangeListener {
        public void toolWillChanged(Tool var1, Tool var2);
    }

    public static class ToolProps {
        public final ToolAction action;
        public final JToggleButton toolbarBtn;
        public final JMenuItem menuItem;
        public final boolean modal;
        public final Object meta;

        public ToolProps(ToolAction toolAction, JToggleButton jToggleButton, JMenuItem jMenuItem, boolean bl, Object object) {
            this.action = toolAction;
            this.toolbarBtn = jToggleButton;
            this.menuItem = jMenuItem;
            this.modal = bl;
            this.meta = object;
        }
    }

    private class ToolActivatedListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("SwingSelectedKey") && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                ToolAction toolAction = (ToolAction)propertyChangeEvent.getSource();
                Tool tool = toolAction.getTool();
                ToolManager.this.setCurrentTool(tool, false, false, true);
            }
        }
    }

    public class ToolPropsAction
    extends AbstractAction {
        public ToolPropsAction() {
            super(Intl.intl("Tool Properties"), guiUtil.loadTeciIcon("Preferences16.gif"));
            this.putValue("ShortDescription", Intl.intl("Tool Properties"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolManager.this.d_currentTool instanceof PropertyEditor) {
                ((PropertyEditor)((Object)ToolManager.this.d_currentTool)).editProperties();
            }
        }
    }

    public class ToolAction
    extends BooleanAction {
        private Tool d_tool;
        private Icon d_icon;

        public ToolAction(Tool tool, String string, String string2, Icon icon) {
            super(string, false, icon);
            this.d_icon = icon;
            this.d_tool = tool;
            this.putValue("ShortDescription", string2);
        }

        @Override
        public Icon getIcon() {
            return this.d_icon;
        }

        @Override
        public boolean isSelected() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        @Override
        public void setSelected(boolean bl) {
            this.putValue("SwingSelectedKey", bl);
        }

        public Tool getTool() {
            return this.d_tool;
        }
    }
}

