/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import thunderheadeng.gui.tool.IMouseDevc;

public class SwingMouse
extends MouseAdapter
implements IMouseDevc {
    private static final IMouseDevc.MouseButtonHistory DEF_HISTORY = new IMouseDevc.MouseButtonHistory();
    private final Map<Integer, IMouseDevc.MouseButtonHistory> d_buttons = new HashMap<Integer, IMouseDevc.MouseButtonHistory>();
    private final Robot d_robot;
    private Point d_location = new Point(0, 0);

    public SwingMouse() {
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this.d_robot = robot;
    }

    @Override
    public IMouseDevc.MouseButtonHistory getHistory(IMouseDevc.Button button) {
        return this.getHistory(SwingMouse.getSwingButton(button));
    }

    @Override
    public IMouseDevc.MouseButtonHistory getHistory(int n) {
        return this.d_buttons.getOrDefault(n, DEF_HISTORY);
    }

    private IMouseDevc.MouseButtonHistory history(int n2) {
        return this.d_buttons.computeIfAbsent(n2, n -> new IMouseDevc.MouseButtonHistory());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.d_location = mouseEvent.getPoint();
        IMouseDevc.MouseButtonHistory mouseButtonHistory = this.history(mouseEvent.getButton());
        if (mouseButtonHistory.isPressed) {
            mouseButtonHistory.lastReleased = mouseEvent.getWhen();
        }
        mouseButtonHistory.lastPressed = mouseEvent.getWhen();
        mouseButtonHistory.isPressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.d_location = mouseEvent.getPoint();
        IMouseDevc.MouseButtonHistory mouseButtonHistory = this.history(mouseEvent.getButton());
        if (!mouseButtonHistory.isPressed) {
            mouseButtonHistory.lastPressed = mouseEvent.getWhen();
        }
        mouseButtonHistory.lastReleased = mouseEvent.getWhen();
        mouseButtonHistory.isPressed = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.d_location = mouseEvent.getPoint();
        this.d_buttons.values().stream().filter(mouseButtonHistory -> mouseButtonHistory.isPressed).forEach(mouseButtonHistory -> {
            mouseButtonHistory.lastDragged = mouseEvent.getWhen();
        });
    }

    @Override
    public void moveMouse(Point point) {
        this.d_robot.mouseMove(point.x, point.y);
    }

    public static IMouseDevc.Button getPredef(MouseEvent mouseEvent) {
        return SwingMouse.getPredef(mouseEvent.getButton());
    }

    public static IMouseDevc.Button getPredef(int n) {
        IMouseDevc.Button[] buttonArray = new IMouseDevc.Button[]{null};
        SwingMouse.ifPredef(n, (IMouseDevc.Button button) -> {
            buttonArray[0] = button;
        });
        return buttonArray[0];
    }

    public static void ifPredef(MouseEvent mouseEvent, Consumer<IMouseDevc.Button> consumer) {
        SwingMouse.ifPredef(mouseEvent.getButton(), consumer);
    }

    public static void ifPredef(int n, Consumer<IMouseDevc.Button> consumer) {
        switch (n) {
            case 1: {
                consumer.accept(IMouseDevc.Button.LEFT);
                break;
            }
            case 2: {
                consumer.accept(IMouseDevc.Button.MIDDLE);
                break;
            }
            case 3: {
                consumer.accept(IMouseDevc.Button.RIGHT);
            }
        }
    }

    public static int getSwingButton(IMouseDevc.Button button) {
        switch (button) {
            case LEFT: {
                return 1;
            }
            case MIDDLE: {
                return 2;
            }
            case RIGHT: {
                return 3;
            }
        }
        assert (false);
        return 1;
    }
}

