/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.gui.tool.ButtonHistory;
import thunderheadeng.gui.tool.IKeyboardDevc;

public class SwingKeyboard
extends KeyAdapter
implements IKeyboardDevc {
    private static final ButtonHistory DEF_HISTORY = new ButtonHistory();
    private final Map<Integer, ButtonHistory> d_pressedKeys = new HashMap<Integer, ButtonHistory>();

    @Override
    public ButtonHistory getHistory(int n) {
        return this.d_pressedKeys.getOrDefault(n, DEF_HISTORY);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        ButtonHistory buttonHistory = this.d_pressedKeys.computeIfAbsent(keyEvent.getKeyCode(), n -> new ButtonHistory());
        buttonHistory.isPressed = true;
        buttonHistory.lastPressed = keyEvent.getWhen();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        ButtonHistory buttonHistory = this.d_pressedKeys.computeIfAbsent(keyEvent.getKeyCode(), n -> new ButtonHistory());
        buttonHistory.isPressed = false;
        buttonHistory.lastReleased = keyEvent.getWhen();
    }

    @Override
    public void clearPressedKeys() {
        this.d_pressedKeys.clear();
    }
}

