/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.tool;

import java.awt.Point;
import java.util.stream.Stream;
import thunderheadeng.gui.tool.ButtonHistory;

public interface IMouseDevc {
    public void moveMouse(Point var1);

    public MouseButtonHistory getHistory(Button var1);

    public MouseButtonHistory getHistory(int var1);

    default public boolean isPressed(Button button) {
        return this.getHistory((Button)button).isPressed;
    }

    default public boolean isPressed(int n) {
        return this.getHistory((int)n).isPressed;
    }

    default public int getMostRecentlyPressed(Stream<Integer> stream) {
        return stream.filter(n -> this.getHistory((int)n.intValue()).isPressed).max((n, n2) -> Long.compare(this.getHistory((int)n.intValue()).lastPressed, this.getHistory((int)n2.intValue()).lastPressed)).get();
    }

    default public Button getMostRecentlyPressedPredef(Stream<Button> stream) {
        return stream.filter(button -> this.getHistory((Button)button).isPressed).max((button, button2) -> Long.compare(this.getHistory((Button)button).lastPressed, this.getHistory((Button)button2).lastPressed)).orElse(null);
    }

    public static class MouseButtonHistory
    extends ButtonHistory {
        public long lastDragged = Long.MAX_VALUE;

        public boolean isDragging() {
            return this.lastDragged >= this.lastPressed;
        }

        public boolean wasDragged() {
            return this.lastDragged <= this.lastReleased;
        }
    }

    public static enum Button {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

