/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class DefaultTableClipboard
implements guiTableClipboard {
    @Override
    public boolean pasteObject(guiTable guiTable2, Object object, int n, int n2) {
        try {
            if (object != null) {
                if ((object = this.formatData(guiTable2, object, n, n2)) == null) {
                    return false;
                }
                if ((object = this.checkData(guiTable2, object, n, n2)) == null) {
                    return false;
                }
            }
            guiTable2.getModel().setValueAt(object, guiTable2.convertRowIndexToModel(n), guiTable2.convertColumnIndexToModel(n2));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Object formatData(guiTable guiTable2, Object object, int n, int n2) {
        Component component;
        Class<Object> clazz = guiTable2.getColumnClass(n2);
        if (clazz.isInstance(object)) {
            return object;
        }
        TableCellEditor tableCellEditor = guiTable2.getCellEditor(n, n2);
        if (tableCellEditor != null && (component = guiTable2.prepareEditor(tableCellEditor, n, n2)) instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.setText(object.toString());
            if (tableCellEditor.stopCellEditing()) {
                return tableCellEditor.getCellEditorValue();
            }
            tableCellEditor.cancelCellEditing();
        }
        if (clazz.isAssignableFrom(String.class)) {
            return object.toString();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (object instanceof Number) {
                return this.castNumberToDesiredNumberType(clazz, (Number)object);
            }
            try {
                return this.getStringAsNumber(clazz, object.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (clazz.isAssignableFrom(UnitDouble.class)) {
            try {
                return Global.parseUnitDouble(object.toString(), null);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Object checkData(guiTable guiTable2, Object object, int n, int n2) {
        TableCellEditor tableCellEditor;
        if (object instanceof UnitDouble && (tableCellEditor = guiTable2.getCellEditor(n, n2)) instanceof guiTable.UnitDoubleEditor) {
            UnitDouble unitDouble = (UnitDouble)object;
            Unit unit = ((guiTable.UnitDoubleEditor)tableCellEditor).getDefaultUnit();
            return unitDouble.reinterpret(unit);
        }
        return object;
    }

    private Object getStringAsNumber(Class clazz, String string) throws NumberFormatException {
        if (clazz.isAssignableFrom(Double.class)) {
            try {
                return Global.parseDouble(string);
            }
            catch (ParseException parseException) {
                return new Double(string);
            }
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return new Float(string);
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return new Integer(string);
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return new Long(string);
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return new Short(string);
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return new Byte(string);
        }
        assert (false);
        return null;
    }

    public Object castNumberToDesiredNumberType(Class clazz, Number number) {
        if (clazz.isAssignableFrom(Double.class)) {
            return number.doubleValue();
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return number.intValue();
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return number.longValue();
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return number.shortValue();
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return number.byteValue();
        }
        assert (false);
        return null;
    }
}

