/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import thunderheadeng.gui.colorscheme.ColorButton;

public class ColorTableCell
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final ColorButton d_editor = new ColorButton(){

        @Override
        protected void editingFinished(boolean bl) {
            if (bl) {
                ColorTableCell.this.stopCellEditing();
            } else {
                ColorTableCell.this.cancelCellEditing();
            }
        }
    };
    private final ColorButton d_renderer = new ColorButton();
    private DefaultTableCellRenderer d_defaultRend = new DefaultTableCellRenderer();
    private DefaultCellEditor d_defaultEditor = new DefaultCellEditor(new JTextField());

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.d_editor.getColor();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = this.d_defaultEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        return this.getComponent(this.d_editor, component, jTable, object, n, n2, true, true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.d_defaultRend.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        return this.getComponent(this.d_renderer, component, jTable, object, n, n2, bl, bl2);
    }

    private Component getComponent(ColorButton colorButton, Component component, JTable jTable, Object object, int n, int n2, boolean bl, boolean bl2) {
        colorButton.setColor((Color)object);
        colorButton.setModified(false);
        Color color = component.getBackground();
        Color color2 = component.getForeground();
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        if (component instanceof JComponent) {
            border = ((JComponent)component).getBorder();
        }
        colorButton.setContentAreaFilled(false);
        colorButton.setBorder(border);
        colorButton.setBackground(color);
        colorButton.setForeground(color2);
        colorButton.setText("");
        return colorButton;
    }
}

