/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.print;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PrintableDocument
implements Pageable,
Printable {
    View root;
    PageFormat format;
    double scalefactor;
    int numPages;
    double printX;
    double printY;
    double printWidth;
    double printHeight;
    Rectangle drawRect;
    static final double MARGIN_ADJUST = 0.97;
    static final Font headerFont = new Font("Serif", 0, 12);
    double pageStart = 0.0;
    ArrayList pageLengths = new ArrayList();
    ArrayList pageOffsets = new ArrayList();

    public PrintableDocument(JTextComponent jTextComponent) {
        this(jTextComponent, new PageFormat(), 0.75);
    }

    public PrintableDocument(JTextComponent jTextComponent, PageFormat pageFormat, double d) {
        this.format = pageFormat;
        this.scalefactor = d;
        this.printX = pageFormat.getImageableX() / d;
        this.printY = pageFormat.getImageableY() / d;
        this.printWidth = pageFormat.getImageableWidth() / d;
        this.printHeight = pageFormat.getImageableHeight() / d;
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
        ViewFactory viewFactory = editorKit.getViewFactory();
        this.root = viewFactory.create(element);
        this.root.setParent(new ParentView(this.root, viewFactory, jTextComponent));
        this.root.setSize((float)this.printWidth, (float)this.printHeight);
        double d2 = this.root.getPreferredSpan(1);
        this.drawRect = new Rectangle(0, 0, (int)this.printWidth, (int)d2);
        if (d2 > this.printHeight) {
            this.paginate(this.root, this.drawRect);
        }
        this.numPages = this.pageLengths.size() + 1;
    }

    protected void paginate(View view, Rectangle2D rectangle2D) {
        double d = view.getPreferredSpan(1);
        view.setSize((float)this.printWidth, (float)d);
        int n = view.getViewCount();
        for (int i = 0; i < n; ++i) {
            View view2 = view.getView(i);
            Shape shape = view.getChildAllocation(i, rectangle2D);
            if (shape == null) continue;
            Rectangle2D rectangle2D2 = shape.getBounds2D();
            double d2 = rectangle2D2.getY() + rectangle2D2.getHeight() - this.pageStart;
            if (n > 1 && i == 0) {
                if (d2 < this.printY + this.printHeight * 0.97) continue;
                this.breakPage(rectangle2D2.getY());
                continue;
            }
            if (n > 1 && i == n - 1) {
                if (d2 < this.printY + this.printHeight) continue;
                if (d2 < this.printY + this.printHeight / 0.97) {
                    this.breakPage(rectangle2D.getY() + rectangle2D.getHeight());
                    continue;
                }
            }
            if (d2 < this.printY + this.printHeight) continue;
            if (view2.getViewCount() == 0) {
                this.breakPage(rectangle2D2.getY());
                continue;
            }
            this.paginate(view2, rectangle2D2);
        }
    }

    void breakPage(double d) {
        double d2 = d - this.pageStart - this.printY;
        this.pageStart = d - this.printY;
        this.pageLengths.add(new Double(d2));
        this.pageOffsets.add(new Double(this.pageStart));
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        if (n == this.numPages - 1) {
            return this.format;
        }
        double d = (Double)this.pageLengths.get(n);
        PageFormat pageFormat = (PageFormat)this.format.clone();
        Paper paper = pageFormat.getPaper();
        if (pageFormat.getOrientation() == 1) {
            paper.setImageableArea(this.printX * this.scalefactor, this.printY * this.scalefactor, this.printWidth * this.scalefactor, d * this.scalefactor);
        } else {
            paper.setImageableArea(this.printY * this.scalefactor, this.printX * this.scalefactor, d * this.scalefactor, this.printWidth * this.scalefactor);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n >= this.numPages) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.scale(this.scalefactor, this.scalefactor);
        if (n > 0) {
            Shape shape = graphics.getClip();
            graphics.setClip(new Rectangle(0, (int)(-this.printY), (int)this.printWidth, (int)this.printY));
            String string = "- " + (n + 1) + " -";
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = headerFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = headerFont.getLineMetrics(string, fontRenderContext);
            graphics.setFont(headerFont);
            graphics.setColor(Color.black);
            graphics.drawString(string, (int)((this.printWidth - rectangle2D.getWidth()) / 2.0), (int)(-(this.printY - rectangle2D.getHeight()) / 2.0 + (double)lineMetrics.getAscent()));
            graphics.setClip(shape);
        }
        double d = 0.0;
        if (n > 0) {
            d = (Double)this.pageOffsets.get(n - 1);
        }
        graphics2D.translate(0.0, -d);
        this.root.paint(graphics, this.drawRect);
        return 0;
    }

    static class ParentView
    extends View {
        ViewFactory viewFactory;
        Container container;

        public ParentView(View view, ViewFactory viewFactory, Container container) {
            super(view.getElement());
            this.viewFactory = viewFactory;
            this.container = container;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }

        @Override
        public Container getContainer() {
            return this.container;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
        }

        @Override
        public float getPreferredSpan(int n) {
            return 0.0f;
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return 0;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return shape;
        }
    }
}

