/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import thunderheadeng.Intl;
import thunderheadeng.gui.guiField;
import thunderheadeng.util.Pair;
import thunderheadeng.util.ValueRange;
import thunderheadeng.util.theUtil;

public abstract class guiValueField<T>
extends guiField {
    private T d_value;
    private ValueRange<T> d_range;
    private boolean d_modified;
    private DocumentListener d_modListener;
    private final Map<String, T> d_specialValMap = new LinkedHashMap<String, T>(1);
    private final Semaphore d_writeLock = new Semaphore(1);

    protected abstract String format(T var1);

    public abstract T parse(String var1) throws ParseException;

    protected abstract ValueRange<T> getUncheckedRange(T var1);

    protected guiValueField() {
    }

    public guiValueField(T t, ValueRange<T> valueRange) {
        this.init(t, valueRange);
    }

    public void aliasValue(T t, String ... stringArray) {
        for (String string : stringArray) {
            this.addSpecialValue(string, t);
        }
    }

    public T addSpecialValue(String string, T t) {
        return this.d_specialValMap.put(string, t);
    }

    public T removeSpecialValue(String string) {
        T t = this.d_specialValMap.remove(string);
        return t;
    }

    public T getSpecialValue(String string) {
        return this.d_specialValMap.get(string);
    }

    protected void init(T t, ValueRange<T> valueRange) {
        this.d_modified = false;
        this.setHorizontalAlignment(2);
        this.d_range = valueRange;
        if (this.d_range == null) {
            this.d_range = this.getUncheckedRange(t);
        }
        this.setValue(t);
        this.d_modListener = new ModifyListener();
        this.getDocument().addDocumentListener(this.d_modListener);
    }

    public boolean getConvertDecimalToLocaleSeparator() {
        return true;
    }

    @Override
    public String getText() {
        return super.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T t) {
        if (!this.d_writeLock.tryAcquire()) {
            return;
        }
        try {
            boolean bl = false;
            String string = "";
            for (Map.Entry<String, T> entry : this.d_specialValMap.entrySet()) {
                if (!theUtil.equal(entry.getValue(), t)) continue;
                bl = true;
                string = entry.getKey();
                break;
            }
            if (!bl) {
                assert (t != null && this.d_range.checkValue(t)) : "Value cannot be null and must lie in range.";
                string = this.format(t);
            }
            try {
                super.setText(string);
            }
            catch (IllegalStateException illegalStateException) {
                this.d_writeLock.release();
                return;
            }
            this.d_value = t;
            this.d_modified = false;
        }
        finally {
            this.d_writeLock.release();
        }
    }

    @Override
    public void setText(String string) {
        Pair<T, Exception> pair = this.getValue(string);
        if (pair.v2 == null) {
            this.setValue(pair.v1);
        }
    }

    protected Pair<T, Exception> getValue(String string) {
        if (this.d_specialValMap.containsKey(string)) {
            T t = this.d_specialValMap.get(string);
            return new Pair<T, Object>(t, null);
        }
        try {
            T t = this.parse(string);
            return new Pair<T, Object>(t, null);
        }
        catch (Exception exception) {
            return new Pair<Object, Exception>(null, exception);
        }
    }

    public T getValue() {
        return this.d_value;
    }

    public ValueRange<T> getValueRange() {
        return this.d_range;
    }

    public void setValueRange(ValueRange<T> valueRange) {
        this.d_range = valueRange;
        if (this.d_range == null) {
            this.d_range = this.getUncheckedRange(this.d_value);
        }
        this.setValue(this.d_range.clampValue(this.d_value));
    }

    protected ParseException getDefaultNumParseException() {
        String string = String.format(Intl.intl("The entry \"%1$s\" is invalid. \n%2$s."), this.getText(), this.d_range.describeRange());
        return new ParseException(string, 0);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        Pair<T, Exception> pair = this.getValue(this.getText());
        if (pair.v2 != null) {
            if (bl) {
                this.showMessageBox(((Exception)pair.v2).getLocalizedMessage(), true);
                this.requestFocusHack();
            }
            return false;
        }
        Object T1 = pair.v1;
        if (T1 != null && !this.d_range.checkValue(T1)) {
            if (bl) {
                String string = String.format(Intl.intl("The entry \"%1$s\" is out of range. \n%2$s."), this.getText(), this.d_range.describeRange());
                this.showMessageBox(string, true);
                this.requestFocusHack();
            }
            return false;
        }
        if (bl2) {
            if (this.isModified()) {
                this.setValue(T1);
                this.setModified(true);
            }
        } else {
            this.d_value = T1;
        }
        return true;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    public void setEmptyAllowed(boolean bl) {
        if (bl) {
            this.addSpecialValue("", null);
        } else {
            this.removeSpecialValue("");
        }
    }

    public boolean getEmptyAllowed() {
        return this.d_specialValMap.containsKey("");
    }

    public boolean isEmpty() {
        return this.getText().equals("");
    }

    private class ModifyListener
    implements DocumentListener {
        private ModifyListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            guiValueField.this.d_modified = true;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            guiValueField.this.d_modified = true;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            guiValueField.this.d_modified = true;
        }
    }
}

