/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.NoIcon;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriConsumer;

public class guiUtil {
    public static final GrayFilter DISABLED_FILTER = new GrayFilter(true, 50);
    private static final HashMap<ImageKey, WeakReference<Image>> s_images = new HashMap();
    private static final WeakHashMap<IImage, WeakReference<BufferedImage>> s_imageCache = new WeakHashMap();
    public static final int VALIDATE_HIDDEN = 1;
    public static final int VALIDATE_DISABLED = 2;

    public static Image loadImage(String string) {
        return guiUtil.loadImages(string, -1, -1, ImageFilter.NORMAL)[0];
    }

    public static Image[] loadImages(String string, int n, int n2, ImageFilter ... imageFilterArray) {
        IImageRetriever<String> iImageRetriever = new IImageRetriever<String>(){

            @Override
            public BufferedImage getImage(String string) throws IOException {
                return guiUtil.forceImageLoad(string);
            }
        };
        return guiUtil.loadImages(string, iImageRetriever, n, n2, imageFilterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Image[] loadImages(T t, IImageRetriever<T> iImageRetriever, int n, int n2, ImageFilter ... imageFilterArray) {
        HashMap<ImageKey, WeakReference<Image>> hashMap = s_images;
        synchronized (hashMap) {
            Image image = null;
            Image[] imageArray = new Image[imageFilterArray.length];
            for (int i = 0; i < imageFilterArray.length; ++i) {
                try {
                    Image image2;
                    ImageKey imageKey = new ImageKey(t, imageFilterArray[i], n, n2);
                    WeakReference<Image> weakReference = s_images.get(imageKey);
                    Image image3 = image2 = weakReference != null ? (Image)weakReference.get() : null;
                    if (image2 == null) {
                        if (image == null) {
                            ImageKey imageKey2 = new ImageKey(t, ImageFilter.NORMAL, n, n2);
                            WeakReference<Image> weakReference2 = s_images.get(imageKey2);
                            Image image4 = image = weakReference2 != null ? (Image)weakReference2.get() : null;
                            if (image == null) {
                                image = guiUtil.resizeImage(iImageRetriever.getImage(t), n, n2);
                            }
                        }
                        assert (image != null);
                        image2 = guiUtil.filterImage(image, imageKey.filter);
                        s_images.put(imageKey, new WeakReference<Image>(image2));
                    }
                    imageArray[i] = image2;
                    continue;
                }
                catch (Exception exception) {
                    imageArray[i] = null;
                }
            }
            return imageArray;
        }
    }

    private static BufferedImage forceImageLoad(String string) throws IOException {
        URL uRL;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if ((uRL = guiUtil.class.getResource(string)) == null) {
            throw new FileNotFoundException(string);
        }
        return ImageIO.read(uRL);
    }

    private static Image resizeImage(BufferedImage bufferedImage, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (!(n > 0 && n5 != n || n2 > 0 && n6 != n2)) {
            return bufferedImage;
        }
        if (n > 0 && n2 > 0) {
            n4 = n;
            n3 = n2;
        } else if (n > 0) {
            n4 = n;
            n3 = Math.round((float)n6 / (float)n5 * (float)n4);
        } else {
            assert (n2 > 0);
            n3 = n2;
            n4 = Math.round((float)n5 / (float)n6 * (float)n3);
        }
        double d = (double)n4 / (double)n5;
        double d2 = (double)n3 / (double)n6;
        double d3 = d < d2 ? d : d2;
        double d4 = ((double)n4 - (double)n5 * d3) / 2.0 / d3;
        double d5 = ((double)n3 - (double)n6 * d3) / 2.0 / d3;
        BufferedImage bufferedImage2 = new BufferedImage(n4, n3, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n5, n6);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d3, d3);
        affineTransform.translate(d4, d5);
        graphics2D.drawImage(bufferedImage, affineTransform, new ImageObserver(){

            @Override
            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                return true;
            }
        });
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static Image filterImage(Image image, ImageFilter imageFilter) {
        if (imageFilter == ImageFilter.DISABLED) {
            return GrayFilter.createDisabledImage(image);
        }
        return image;
    }

    public static ImageIcon loadTeciIcon(String string) {
        return guiUtil.loadTeciIcon(string, -1);
    }

    public static ImageIcon loadTeciIcon(String string, int n) {
        return guiUtil.loadIcon("thunderheadeng/gui/graphics/" + string, n);
    }

    public static ImageIcon loadIcon(String string) {
        return guiUtil.loadIcon(string, -1);
    }

    public static ImageIcon loadIcon(String string, int n) {
        Image image = guiUtil.loadImages(string, -1, n, ImageFilter.NORMAL)[0];
        return image == null ? null : new ImageIcon(image);
    }

    public static Cursor createTeciCursor(String string, String string2, int n, int n2) {
        return guiUtil.createCursor(string, "thunderheadeng/gui/graphics/" + string2, n, n2);
    }

    public static Cursor createCursor(String string, String string2, int n, int n2) {
        Image image = guiUtil.loadImage(string2);
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(n, n2), string);
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    public static void addSelectableMenuItem(JMenu jMenu, SelectableAction selectableAction) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(selectableAction);
        jMenu.add(guiUtil.initMenuItem(jCheckBoxMenuItem, selectableAction, null));
    }

    public static void addSelectableMenuItem(JPopupMenu jPopupMenu, SelectableAction selectableAction) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(selectableAction);
        jPopupMenu.add(guiUtil.initMenuItem(jCheckBoxMenuItem, selectableAction, null));
    }

    public static JToggleButton createToolbarToggleButton(SelectableAction selectableAction) {
        JToggleButton jToggleButton = new JToggleButton(selectableAction);
        guiUtil.initToolbarBtn(selectableAction, jToggleButton);
        jToggleButton.addItemListener(selectableAction);
        return jToggleButton;
    }

    public static JButton createToolbarButton(Action action) {
        JButton jButton = new JButton(action);
        guiUtil.initToolbarBtn(action, jButton);
        return jButton;
    }

    private static void initToolbarBtn(Action action, AbstractButton abstractButton) {
        Object object;
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon != null) {
            abstractButton.setText("");
            object = (String)action.getValue("ShortDescription");
            if (object == null || ((String)object).trim().equals("")) {
                abstractButton.setToolTipText((String)action.getValue("Name"));
            }
        }
        if ((object = action.getValue("guiAction.DISABLED_ICON")) instanceof Icon) {
            abstractButton.setDisabledIcon((Icon)object);
        }
    }

    public static <T extends JMenuItem> T initMenuItem(T t, Action action, ButtonGroup buttonGroup) {
        Object object;
        String string = (String)action.getValue("ShortDescription");
        if (string != null && !string.trim().isEmpty()) {
            t.setToolTipText(string.trim());
        }
        if (action instanceof ItemListener) {
            t.addItemListener((ItemListener)((Object)action));
        }
        if (buttonGroup != null) {
            buttonGroup.add(t);
        }
        if ((object = action.getValue("guiAction.DISABLED_ICON")) instanceof Icon) {
            t.setDisabledIcon((Icon)object);
        }
        return t;
    }

    public static void addMEMenuItems(JMenu jMenu, SelectableAction ... selectableActionArray) {
        guiUtil.addMEMenuItems(jMenu, Arrays.asList(selectableActionArray));
    }

    public static void addMEMenuItems(JMenu jMenu, Collection<? extends SelectableAction> collection) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (SelectableAction selectableAction : collection) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(selectableAction);
            jMenu.add(guiUtil.initMenuItem(jRadioButtonMenuItem, selectableAction, buttonGroup));
        }
    }

    public static void addMEMenuItems(JPopupMenu jPopupMenu, SelectableAction ... selectableActionArray) {
        guiUtil.addMEMenuItems(jPopupMenu, Arrays.asList(selectableActionArray));
    }

    public static void addMEMenuItems(JPopupMenu jPopupMenu, Collection<? extends SelectableAction> collection) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (SelectableAction selectableAction : collection) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(selectableAction);
            jPopupMenu.add(guiUtil.initMenuItem(jRadioButtonMenuItem, selectableAction, buttonGroup));
        }
    }

    public static void addMEToolbarItems(JToolBar jToolBar, SelectableAction ... selectableActionArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < selectableActionArray.length; ++i) {
            JToggleButton jToggleButton = guiUtil.createToolbarToggleButton(selectableActionArray[i]);
            jToolBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
        }
    }

    public static Icon createDisabledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static Pair<JTabbedPane, Component> findTab(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null && !(container instanceof JTabbedPane)) {
            component = container;
            container = component.getParent();
        }
        return container instanceof JTabbedPane ? new Pair<JTabbedPane, Component>((JTabbedPane)container, component) : null;
    }

    public static void showAncestorTab(Component component) {
        Pair<JTabbedPane, Component> pair = guiUtil.findTab(component);
        if (pair == null) {
            return;
        }
        ((JTabbedPane)pair.v1).setSelectedComponent((Component)pair.v2);
    }

    private static int[] getSquareDims(int n, int n2) {
        assert (n > 0 || n2 > 0);
        int n3 = n > 0 ? n : n2;
        int n4 = n2 > 0 ? n2 : n;
        return new int[]{n3, n4};
    }

    public static Icon[] getIcons(IMaterial iMaterial, int n, int n2, int n3, ImageFilter ... imageFilterArray) {
        if (iMaterial != null) {
            IMatAttrs iMatAttrs = iMaterial.getAttributes();
            Texture texture = iMatAttrs.getTexture(MatChannel.DIFFUSE);
            if (texture != null) {
                return guiUtil.getIcons(texture.image, n, n2, imageFilterArray);
            }
            int[] nArray = guiUtil.getSquareDims(n, n2);
            Color color = iMatAttrs.getColor(MatChannel.DIFFUSE);
            if (color == null) {
                color = new Color(0, 0, 0, 0);
            }
            ColorIcon colorIcon = new ColorIcon(color, nArray[0], nArray[1], n3);
            Object[] objectArray = new Icon[imageFilterArray.length];
            Arrays.fill(objectArray, colorIcon);
            return objectArray;
        }
        int[] nArray = guiUtil.getSquareDims(n, n2);
        Object[] objectArray = new Icon[imageFilterArray.length];
        Arrays.fill(objectArray, new NoIcon(Color.BLACK, nArray[0], nArray[1]));
        return objectArray;
    }

    public static Icon[] getIcons(IImage iImage, int n, int n2, ImageFilter ... imageFilterArray) {
        if (iImage != null) {
            Image[] imageArray = guiUtil.getImages(iImage, n, n2, imageFilterArray);
            Icon[] iconArray = new Icon[imageFilterArray.length];
            for (int i = 0; i < imageArray.length; ++i) {
                Image image = imageArray[i];
                iconArray[i] = image == null ? null : new ImageIcon(image);
            }
            return iconArray;
        }
        int[] nArray = guiUtil.getSquareDims(n, n2);
        Object[] objectArray = new Icon[imageFilterArray.length];
        Arrays.fill(objectArray, new NoIcon(Color.BLACK, nArray[0], nArray[1]));
        return objectArray;
    }

    public static Image[] getImages(IImage iImage, int n, int n2, ImageFilter ... imageFilterArray) {
        IImageRetriever<IImage> iImageRetriever = new IImageRetriever<IImage>(){

            @Override
            public BufferedImage getImage(IImage iImage) throws IOException {
                return guiUtil.getBufferedImage(iImage);
            }
        };
        return guiUtil.loadImages(iImage, iImageRetriever, n, n2, imageFilterArray);
    }

    public static void paintComponent(Component component, Graphics graphics, IMaterial iMaterial) {
        Icon icon;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        Icon[] iconArray = guiUtil.getIcons(iMaterial, rectangle.width, rectangle.height, 0, ImageFilter.NORMAL, ImageFilter.DISABLED);
        Icon icon2 = icon = component.isEnabled() || iconArray[1] == null ? iconArray[0] : iconArray[1];
        if (icon != null) {
            icon.paintIcon(component, graphics, rectangle.x, rectangle.y);
        }
    }

    public static void paintComponent(Component component, Graphics graphics, IImage iImage) {
        Icon icon;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        Icon[] iconArray = guiUtil.getIcons(iImage, rectangle.width, rectangle.height, ImageFilter.NORMAL, ImageFilter.DISABLED);
        Icon icon2 = icon = component.isEnabled() || iconArray[1] == null ? iconArray[0] : iconArray[1];
        if (icon != null) {
            icon.paintIcon(component, graphics, rectangle.x, rectangle.y);
        }
    }

    public static void initButton(AbstractButton abstractButton, IMaterial iMaterial, int n, int n2) {
        Insets insets = abstractButton.getBorder().getBorderInsets(abstractButton);
        int n3 = Math.min(insets.left, insets.bottom);
        int n4 = n + n3 * 2;
        int n5 = n2 + n3 * 2;
        abstractButton.setPreferredSize(new Dimension(n4, n5));
        Icon[] iconArray = guiUtil.getIcons(iMaterial, n, n2, 0, ImageFilter.NORMAL, ImageFilter.DISABLED);
        abstractButton.setIcon(iconArray[0]);
        abstractButton.setDisabledIcon(iconArray[1]);
    }

    public static void initButton(AbstractButton abstractButton, IImage iImage) {
        if (iImage != null) {
            abstractButton.setToolTipText(iImage.getFilename());
        } else {
            abstractButton.setToolTipText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImage(IImage iImage) {
        WeakHashMap<IImage, WeakReference<BufferedImage>> weakHashMap = s_imageCache;
        synchronized (weakHashMap) {
            BufferedImage bufferedImage;
            WeakReference<BufferedImage> weakReference = s_imageCache.get(iImage);
            BufferedImage bufferedImage2 = bufferedImage = weakReference != null ? (BufferedImage)weakReference.get() : null;
            if (bufferedImage == null) {
                bufferedImage = iImage.toBufferedImage();
                s_imageCache.put(iImage, new WeakReference<BufferedImage>(bufferedImage));
            }
            return bufferedImage;
        }
    }

    public static void showError(Application application, String string, String string2, Throwable throwable) {
        guiUtil.showError(application.getActiveFrame(), string, string2, throwable);
    }

    public static void showError(Component component, String string, String string2, Throwable throwable) {
        string2 = guiUtil.formatError(string2, throwable);
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        JOptionPane.showMessageDialog(window, string2, string, 0);
    }

    public static String formatError(String string, Throwable throwable) {
        throwable.printStackTrace();
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String string2 = throwable.getLocalizedMessage() != null && !throwable.getLocalizedMessage().isEmpty() ? throwable.getClass().getSimpleName() + ": " + throwable.getLocalizedMessage() : throwable.getClass().getSimpleName();
        String string3 = String.format(Intl.intl("Cause: %s"), string2);
        string = string == null || string.isEmpty() ? string3 : string + "\n" + string3;
        return string;
    }

    public static WaitCursorMgr getWaitMgr(Component component) {
        while (component != null) {
            if (component instanceof guiFrame) {
                return ((guiFrame)component).getWaitCursorMgr();
            }
            if (component instanceof guiDialog) {
                return ((guiDialog)component).getWaitCursorMgr();
            }
            component = component.getParent();
        }
        return null;
    }

    public static IListenerStripper stripListeners(JComboBox jComboBox) {
        return new ComboBoxListenerStripper(jComboBox);
    }

    public static IListenerStripper stripListeners(AbstractButton abstractButton) {
        return new ButtonListenerStripper(abstractButton);
    }

    public static IListenerStripper stripListeners(JList jList) {
        return new ListListenerStripper(jList);
    }

    public static IListenerStripper stripListeners(JCheckBox jCheckBox) {
        IListenerStripper[] iListenerStripperArray = new IListenerStripper[4];
        iListenerStripperArray[0] = guiUtil.stripListeners(jCheckBox::addItemListener, jCheckBox::getItemListeners, jCheckBox::removeItemListener);
        iListenerStripperArray[1] = guiUtil.stripListeners(jCheckBox::addActionListener, jCheckBox::getActionListeners, jCheckBox::removeActionListener);
        iListenerStripperArray[2] = guiUtil.stripListeners(jCheckBox::addChangeListener, jCheckBox::getChangeListeners, jCheckBox::removeChangeListener);
        iListenerStripperArray[3] = guiUtil.stripListeners(jCheckBox::addPropertyChangeListener, jCheckBox::getPropertyChangeListeners, jCheckBox::removePropertyChangeListener);
        return new DefaultListenerStripper<JCheckBox>(jCheckBox, iListenerStripperArray);
    }

    public static IListenerStripper stripListeners(JTable jTable) {
        return new TableListenerStripper(jTable);
    }

    public static IListenerStripper stripListeners(Component component) {
        if (component instanceof JComboBox) {
            return guiUtil.stripListeners((JComboBox)component);
        }
        if (component instanceof AbstractButton) {
            return guiUtil.stripListeners((AbstractButton)component);
        }
        if (component instanceof JList) {
            return guiUtil.stripListeners((JList)component);
        }
        if (component instanceof JCheckBox) {
            return guiUtil.stripListeners((JCheckBox)component);
        }
        if (component instanceof JTable) {
            return guiUtil.stripListeners((JTable)component);
        }
        return new DefaultListenerStripper<Component>(component, new IListenerStripper[0]);
    }

    public static <LType> IListenerStripper stripListeners(Consumer<LType> consumer, Supplier<LType[]> supplier, Consumer<LType> consumer2) {
        return new ListenerStripper<LType>(consumer, supplier, consumer2);
    }

    public static ButtonGroup group(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : abstractButtonArray) {
            buttonGroup.add(abstractButton);
        }
        return buttonGroup;
    }

    public static void addItemListener(ButtonGroup buttonGroup, ItemListener itemListener) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().addItemListener(itemListener);
        }
    }

    public static void removeItemListener(ButtonGroup buttonGroup, ItemListener itemListener) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().removeItemListener(itemListener);
        }
    }

    public static <T extends Component> ComponentGroup2<T> group(Class<T> clazz, T ... TArray) {
        return new ComponentGroup2(TArray);
    }

    public static <T extends Component> ComponentGroup2<T> group(T ... TArray) {
        return new ComponentGroup2(TArray);
    }

    public static <T extends Component> ComponentGroup2<T> group(Collection<T> collection) {
        return new ComponentGroup2<T>(collection);
    }

    public static void link(AbstractButton abstractButton, boolean bl, Component ... componentArray) {
        LinkStatus.link(abstractButton, bl, componentArray);
    }

    public static void link(AbstractButton abstractButton, boolean bl, ComponentGroup componentGroup) {
        LinkStatus.link(abstractButton, bl, componentGroup);
    }

    public static void link(AbstractButton abstractButton, Component ... componentArray) {
        LinkStatus.link(abstractButton, componentArray);
    }

    public static void link(AbstractButton abstractButton, ComponentGroup componentGroup) {
        LinkStatus.link(abstractButton, componentGroup);
    }

    public static void link2(AbstractButton abstractButton, Component ... componentArray) {
        LinkStatus.link2(abstractButton, componentArray);
    }

    public static void link2(AbstractButton abstractButton, boolean bl, Component ... componentArray) {
        LinkStatus.link2(abstractButton, bl, componentArray);
    }

    public static String formatText(JComponent jComponent, String string) {
        FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
        int n = Math.max(0, jComponent.getPreferredSize().width - jComponent.getInsets().left - jComponent.getInsets().right);
        return guiUtil.formatText(fontMetrics, string, n);
    }

    public static String formatText(FontMetrics fontMetrics, String string, int n) {
        int n2;
        char[] cArray = string.toCharArray();
        if (fontMetrics.charsWidth(cArray, 0, cArray.length) <= n) {
            return string;
        }
        for (int i = 0; i < string.length() && (n2 = fontMetrics.charsWidth(cArray, 0, i + 1)) <= n; ++i) {
        }
        for (n2 = i; n2 >= 0; --n2) {
            cArray[n2] = 8230;
            int n3 = fontMetrics.charsWidth(cArray, 0, n2 + 1);
            if (n3 > n) continue;
            return new String(cArray, 0, n2 + 1);
        }
        return "";
    }

    public static String escapeHTML(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        string = string.replace("\"", "&quot;");
        return string;
    }

    public static boolean shouldValidateChild(Component component, int n) {
        return !(!guiUtil.test(n, 1) && !component.isVisible() && !(component.getParent() instanceof JTabbedPane) || !guiUtil.test(n, 2) && !component.isEnabled());
    }

    private static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public static JButton newMediaBtn(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton();
        guiUtil.setMediaIcons(jButton, string2);
        jButton.addActionListener(actionListener);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setFocusable(false);
        return jButton;
    }

    public static void setMediaIcons(JButton jButton, String string) {
        jButton.setIcon(guiUtil.loadTeciIcon(string + "Normal.png"));
        jButton.setPressedIcon(guiUtil.loadTeciIcon(string + "Pressed.png"));
        jButton.setRolloverIcon(guiUtil.loadTeciIcon(string + "Hot.png"));
        jButton.setDisabledIcon(guiUtil.loadTeciIcon(string + "Disabled.png"));
    }

    public static javax.swing.filechooser.FileFilter toChooserFileFilter(final FileFilter fileFilter) {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public String getDescription() {
                return fileFilter.toString();
            }

            @Override
            public boolean accept(File file) {
                return fileFilter.accept(file);
            }
        };
    }

    public static <T> guiComboBox<T> newCombo(T t, String string2, Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        BiConsumer<Object, String> biConsumer = (object, string) -> {
            arrayList.add(object);
            hashMap.put(object, string);
        };
        biConsumer.accept(t, string2);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n++];
            String string3 = (String)objectArray[n++];
            biConsumer.accept(object2, string3);
        }
        return guiUtil.newCombo((T object) -> new Pair(hashMap.get(object), null), arrayList);
    }

    public static <T> guiComboBox<T> newCombo(T t, String string3, String string4, Object ... objectArray) {
        assert (objectArray.length % 3 == 0);
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        TriConsumer<Object, String, String> triConsumer = (object, string, string2) -> {
            arrayList.add(object);
            hashMap.put(object, new Pair<String, String>((String)string, (String)string2));
        };
        triConsumer.accept(t, string3, string4);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n++];
            String string5 = (String)objectArray[n++];
            String string6 = (String)objectArray[n++];
            triConsumer.accept(object2, string5, string6);
        }
        return guiUtil.newCombo((T object) -> (Pair)hashMap.get(object), arrayList);
    }

    public static <T> guiComboBox<T> newCombo(Function<T, Pair<String, String>> function, T ... TArray) {
        return guiUtil.newCombo(function, Arrays.asList(TArray));
    }

    public static <T> guiComboBox<T> newCombo(final Function<T, Pair<String, String>> function, Collection<T> collection) {
        final guiComboBox<T> guiComboBox2 = new guiComboBox<T>(collection);
        guiComboBox2.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                Pair pair = (Pair)function.apply(object);
                this.setText((String)pair.v1);
                if (pair.v2 != null && !((String)pair.v2).isEmpty()) {
                    guiComboBox2.setToolTipText((String)pair.v2);
                    this.setToolTipText((String)pair.v2);
                } else {
                    guiComboBox2.setToolTipText(null);
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        return guiComboBox2;
    }

    public static void showIntelWarning(Component component, String string, Supplier<IRenderSurface.OpenGLInfo> supplier, Consumer<Boolean> consumer) {
        IRenderSurface.OpenGLInfo openGLInfo = supplier.get();
        String string2 = String.format(Intl.intl("%1$s has detected Intel graphics. In some cases, out-of-date drivers for this adapter\n(%2$s) have been associated with rendering errors, including\nblank and corrupted visualization.\n\nIf you experience display issues, go to the <b>File</b> menu and select <b>Preferences</b>.\nOn the <b>Rendering</b> tab, choose <b>Max Compatibility</b>."), string, openGLInfo.renderer);
        string2 = "<html>" + string2.replace("\n", "<br>");
        guiDialog guiDialog2 = new guiDialog(SwingUtilities.getWindowAncestor(component), Intl.intl("Intel Graphics Detected"), 1);
        guiCheckBox guiCheckBox2 = new guiCheckBox(Intl.intl("Do not show this warning again."));
        guiCheckBox2.setSelected(true);
        GridBagHelper gridBagHelper = new GridBagHelper(guiDialog2.getDialogPane());
        gridBagHelper.addRow(string2, 1, 1.0);
        gridBagHelper.addRow(guiCheckBox2);
        gridBagHelper.finalizeRows();
        guiDialog2.doModal();
        consumer.accept(guiCheckBox2.isSelected());
    }

    public static guiPanel getRenderPrefsBtns(Supplier<IPropertySet> supplier2, Supplier<IPropertySet> supplier3, Consumer<IPropertySet> consumer) {
        JButton jButton = new JButton(Intl.intl("Max Quality"));
        jButton.setToolTipText(Intl.intl("Loads rendering preferences for maximum quality rendering."));
        JButton jButton2 = new JButton(Intl.intl("Max Compatibility"));
        jButton2.setToolTipText(Intl.intl("Loads rendering preferences for maximum compatibility with older graphics cards and drivers."));
        Function<Supplier, ActionListener> function = supplier -> arg_0 -> guiUtil.lambda$null$386((Supplier)supplier, consumer, arg_0);
        jButton.addActionListener(function.apply(supplier2));
        jButton2.addActionListener(function.apply(supplier3));
        guiPanel guiPanel2 = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(jButton, jButton2);
        return guiPanel2;
    }

    public static <T> boolean canLoadPref(IPropertySet iPropertySet, boolean bl, IPropertySet.Prop<T> prop) {
        return !bl || iPropertySet.isDefined(prop);
    }

    public static void loadPref(IPropertySet iPropertySet, boolean bl, guiCheckBox guiCheckBox2, IPropertySet.Prop<Boolean> prop) {
        if (guiUtil.canLoadPref(iPropertySet, bl, prop)) {
            guiCheckBox2.setSelected(iPropertySet.get(prop));
        }
    }

    public static <T> void loadPref(IPropertySet iPropertySet, boolean bl, guiComboBox<T> guiComboBox2, IPropertySet.Prop<T> prop) {
        if (guiUtil.canLoadPref(iPropertySet, bl, prop)) {
            guiComboBox2.setSelectedItem(iPropertySet.get(prop));
        }
    }

    private static /* synthetic */ void lambda$null$386(Supplier supplier, Consumer consumer, ActionEvent actionEvent) {
        IPropertySet iPropertySet = (IPropertySet)supplier.get();
        consumer.accept(iPropertySet);
    }

    private static class ImageKey {
        public final Object resource;
        public final ImageFilter filter;
        public final int width;
        public final int height;

        public ImageKey(Object object, ImageFilter imageFilter, int n, int n2) {
            this.resource = object;
            this.filter = imageFilter;
            this.width = n;
            this.height = n2;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof ImageKey && ((ImageKey)object).filter == this.filter && ((ImageKey)object).width == this.width && ((ImageKey)object).height == this.height && ((ImageKey)object).resource.equals(this.resource);
        }

        public int hashCode() {
            return 0xFAA344D ^ this.resource.hashCode() + this.width + this.height + this.filter.hashCode();
        }
    }

    private static class ButtonListenerStripper
    extends DefaultListenerStripper<AbstractButton> {
        public final ActionListener[] d_actionListeners;
        public final ItemListener[] d_itemListeners;

        public ButtonListenerStripper(AbstractButton abstractButton) {
            super(abstractButton, new IListenerStripper[0]);
            this.d_itemListeners = abstractButton.getItemListeners();
            for (ItemListener eventListener : this.d_itemListeners) {
                abstractButton.removeItemListener(eventListener);
            }
            this.d_actionListeners = abstractButton.getActionListeners();
            for (EventListener eventListener : this.d_actionListeners) {
                abstractButton.removeActionListener((ActionListener)eventListener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (ItemListener eventListener : this.d_itemListeners) {
                ((AbstractButton)this.getComponent()).addItemListener(eventListener);
            }
            for (EventListener eventListener : this.d_actionListeners) {
                ((AbstractButton)this.getComponent()).addActionListener((ActionListener)eventListener);
            }
        }
    }

    private static class TableListenerStripper
    extends DefaultListenerStripper<JTable> {
        private final TableModelListener[] d_modelListeners;

        public TableListenerStripper(JTable jTable) {
            super(jTable, new IListenerStripper[0]);
            this.d_modelListeners = jTable.getModel() instanceof AbstractTableModel ? ((AbstractTableModel)jTable.getModel()).getTableModelListeners() : new TableModelListener[0];
            for (TableModelListener tableModelListener : this.d_modelListeners) {
                jTable.getModel().removeTableModelListener(tableModelListener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (TableModelListener tableModelListener : this.d_modelListeners) {
                ((JTable)this.getComponent()).getModel().addTableModelListener(tableModelListener);
            }
        }
    }

    private static class ListListenerStripper
    extends DefaultListenerStripper<JList> {
        private final ListSelectionListener[] d_listSelListeners;

        public ListListenerStripper(JList jList) {
            super(jList, new IListenerStripper[0]);
            for (ListSelectionListener listSelectionListener : this.d_listSelListeners = jList.getListSelectionListeners()) {
                jList.removeListSelectionListener(listSelectionListener);
            }
        }

        @Override
        public void restore() {
            super.restore();
            for (ListSelectionListener listSelectionListener : this.d_listSelListeners) {
                ((JList)this.getComponent()).addListSelectionListener(listSelectionListener);
            }
        }
    }

    private static class ComboBoxListenerStripper
    implements IListenerStripper {
        private final JComboBox d_cb;
        private final ItemListener[] d_listeners;
        private final ActionListener[] d_actionListeners;

        public ComboBoxListenerStripper(JComboBox jComboBox) {
            this.d_cb = jComboBox;
            this.d_listeners = jComboBox.getItemListeners();
            for (ItemListener eventListener : this.d_listeners) {
                jComboBox.removeItemListener(eventListener);
            }
            this.d_actionListeners = jComboBox.getActionListeners();
            for (EventListener eventListener : this.d_actionListeners) {
                jComboBox.removeActionListener((ActionListener)eventListener);
            }
        }

        @Override
        public void restore() {
            for (ItemListener eventListener : this.d_listeners) {
                this.d_cb.addItemListener(eventListener);
            }
            for (EventListener eventListener : this.d_actionListeners) {
                this.d_cb.addActionListener((ActionListener)eventListener);
            }
        }
    }

    private static class DefaultListenerStripper<T extends Component>
    implements IListenerStripper {
        private final T d_comp;
        private final KeyListener[] d_keyListeners;
        private final IListenerStripper[] d_strippers;

        public DefaultListenerStripper(T t, IListenerStripper ... iListenerStripperArray) {
            this.d_comp = t;
            this.d_strippers = iListenerStripperArray;
            for (KeyListener keyListener : this.d_keyListeners = ((Component)t).getKeyListeners()) {
                ((Component)this.d_comp).removeKeyListener(keyListener);
            }
        }

        public T getComponent() {
            return this.d_comp;
        }

        @Override
        public void restore() {
            for (KeyListener object : this.d_keyListeners) {
                ((Component)this.d_comp).addKeyListener(object);
            }
            for (IListenerStripper iListenerStripper : this.d_strippers) {
                iListenerStripper.restore();
            }
        }
    }

    private static class ListenerStripper<LType>
    implements IListenerStripper {
        private final Consumer<LType> add;
        private final LType[] d_listeners;

        public ListenerStripper(Consumer<LType> consumer, Supplier<LType[]> supplier, Consumer<LType> consumer2) {
            this.add = consumer;
            for (LType LType : this.d_listeners = supplier.get()) {
                consumer2.accept(LType);
            }
        }

        @Override
        public void restore() {
            for (LType LType : this.d_listeners) {
                this.add.accept(LType);
            }
        }
    }

    private static interface IImageRetriever<T> {
        public BufferedImage getImage(T var1) throws IOException;
    }

    public static enum ImageFilter {
        NORMAL,
        DISABLED;

    }
}

