/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.text.ParseException;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.ValueRange;

public class guiUnitDoubleField
extends guiValueField<UnitDouble> {
    private Unit d_displayUnit;

    public guiUnitDoubleField(Unit unit) {
        this(new UnitDouble(0.0, unit));
    }

    public guiUnitDoubleField(double d, Unit unit) {
        this(new UnitDouble(d, unit));
    }

    public guiUnitDoubleField(UnitDouble unitDouble) {
        this(unitDouble, UnitDoubleVR.unbounded());
    }

    public guiUnitDoubleField(Unit unit, DoubleVR doubleVR) {
        this(unit, UnitDoubleVR.from(doubleVR, unit));
    }

    public guiUnitDoubleField(Unit unit, UnitDoubleVR unitDoubleVR) {
        this(unitDoubleVR.clampValue(new UnitDouble(0.0, unit)), unitDoubleVR);
    }

    public guiUnitDoubleField(double d, DoubleVR doubleVR, Unit unit) {
        this(new UnitDouble(d, unit), UnitDoubleVR.from(doubleVR, unit));
    }

    public guiUnitDoubleField(UnitDouble unitDouble, UnitDoubleVR unitDoubleVR) {
        super(unitDouble, unitDoubleVR);
        this.d_displayUnit = unitDouble.getUnit();
    }

    public Unit getDisplayUnit() {
        return this.d_displayUnit;
    }

    public void setDisplayUnit(Unit unit) {
        if (unit.equals(this.d_displayUnit)) {
            return;
        }
        if (this.validateData(false, false)) {
            UnitDouble unitDouble = (UnitDouble)this.getValue();
            if (unitDouble != null && !unitDouble.isCompatible(unit)) {
                unitDouble = unitDouble.reinterpret(unit);
            }
            this.d_displayUnit = unit;
            this.setValue(unitDouble);
        } else {
            this.d_displayUnit = unit;
        }
    }

    private static String format(double d, Unit unit) {
        return Global.format(d, unit);
    }

    private String format(UnitDouble unitDouble, Unit unit) {
        return guiUnitDoubleField.format(unitDouble.getValue(unit), unit);
    }

    @Override
    protected String format(UnitDouble unitDouble) {
        Unit unit = this.d_displayUnit == null ? unitDouble.getUnit() : this.d_displayUnit;
        return this.format(unitDouble, unit);
    }

    @Override
    public UnitDouble parse(String string) throws ParseException, IllegalArgumentException {
        UnitDouble unitDouble = Global.parseUnitDouble(string, this.d_displayUnit);
        if (unitDouble == null) {
            return this.getValueRange().clampValue(new UnitDouble(0.0, this.d_displayUnit));
        }
        return unitDouble;
    }

    @Override
    protected ValueRange<UnitDouble> getUncheckedRange(UnitDouble unitDouble) {
        return UnitDoubleVR.unbounded();
    }
}

