/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.guiStatusMessageListener;

public class guiStatusBar
extends JPanel
implements guiStatusMessageListener {
    public static Border BEVEL_BORDER = BorderFactory.createBevelBorder(1);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    public static final double SEPARATOR_HEIGHT_SCALE = 1.1;
    private ArrayList<JComponent> d_labels;
    private int d_paneHeight;
    private int d_nextX;
    private Border d_border = EMPTY_BORDER;
    private guiStatusMessage d_message;

    public guiStatusBar() {
        super(new GridBagLayout());
        this.init(new double[]{-1.0});
    }

    public guiStatusBar(String[] stringArray) {
        super(new GridBagLayout());
        this.init(new double[]{-1.0});
    }

    public guiStatusBar(double[] dArray) {
        super(new GridBagLayout());
        this.init(dArray);
    }

    private void init(double[] dArray) {
        this.d_labels = new ArrayList();
        this.d_nextX = 0;
        JLabel jLabel = new JLabel(" ");
        this.d_paneHeight = jLabel.getPreferredSize().height;
        for (int i = 0; i < dArray.length; ++i) {
            this.addNextPane(jLabel, dArray[i]);
            jLabel = new JLabel(" ");
        }
    }

    public void togglePane(int n, boolean bl) {
        if (bl) {
            if (this.getComponentCount() > 2 * n && this.getComponent(2 * n).equals(this.d_labels.get(n))) {
                return;
            }
            int n2 = n == 0 ? 0 : 2 * n - 1;
            this.addPane(this.d_labels.get(n), 0.0, n2, false);
        } else {
            this.removePane(n, true);
        }
    }

    public int addPane(JComponent jComponent, double d) {
        return this.addNextPane(jComponent, d);
    }

    public int addNextPane(JComponent jComponent, double d) {
        return this.addPane(jComponent, d, this.d_nextX++);
    }

    public int addPane(JComponent jComponent, double d, int n) {
        return this.addPane(jComponent, d, n, true);
    }

    protected int addPane(JComponent jComponent, double d, int n, boolean bl) {
        int n2;
        int n3 = n2 = bl ? this.d_labels.size() : this.d_labels.indexOf(jComponent);
        if (n2 > 0) {
            this.addSeparator(n++);
        }
        if (bl) {
            this.d_labels.add(jComponent);
            Border border = jComponent.getBorder();
            jComponent.setBorder(BorderFactory.createCompoundBorder(this.d_border, border));
        }
        int n4 = 3;
        double d2 = 0.0;
        if (d < 0.0) {
            n4 = 1;
            d2 = -d;
        } else if (d != 0.0) {
            jComponent.setPreferredSize(new Dimension((int)d, this.d_paneHeight));
        }
        GridBagUtil.add(this, jComponent, n, 0, 1, 1, 0, 0, 0, 0, n4, d2, 1.0);
        return n2;
    }

    public JComponent getPane(int n) {
        return this.d_labels.get(n);
    }

    public boolean removePane(JComponent jComponent) {
        int n = this.d_labels.indexOf(jComponent);
        if (n == -1) {
            return false;
        }
        return this.removePane(n);
    }

    public boolean removePane(int n) {
        return this.removePane(n, false);
    }

    protected boolean removePane(int n, boolean bl) {
        if (n < 0 || n >= this.d_labels.size() || 2 * n >= this.getComponentCount()) {
            return false;
        }
        JComponent jComponent = bl ? this.d_labels.get(n) : this.d_labels.remove(n);
        this.remove(jComponent);
        if (n != 0) {
            int n2 = n * 2 - 1;
            assert (this.getComponent(n2) instanceof JSeparator);
            this.remove(n2);
        }
        return true;
    }

    protected void addSeparator(int n) {
        JSeparator jSeparator = new JSeparator(1){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, (int)Math.round((double)guiStatusBar.this.d_paneHeight * 1.1));
            }
        };
        GridBagUtil.add(this, jSeparator, n, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 15);
    }

    public void setLabelBorder(Border border) {
        this.d_border = border;
        for (JComponent jComponent : this.d_labels) {
            jComponent.setBorder(border);
        }
    }

    public void setStatusMessage(guiStatusMessage guiStatusMessage2) {
        JButton jButton = new JButton();
        jButton.addActionListener(null);
        if (this.d_message != null) {
            this.d_message.removeStatusListener(this);
        }
        this.d_message = guiStatusMessage2;
        if (this.d_message != null) {
            this.d_message.addStatusListener(this);
        }
    }

    public guiStatusMessage getStatusMessage() {
        return this.d_message;
    }

    public void setMessage(String string) {
        this.setMessage(0, string);
    }

    public void setMessage(int n, String string) {
        JComponent jComponent;
        if (string == null || string.equals("")) {
            string = " ";
        }
        if ((jComponent = this.d_labels.get(n)) instanceof JLabel) {
            ((JLabel)jComponent).setText(string);
        } else {
            jComponent.setName(string);
        }
    }

    public Font getFont(int n) {
        JComponent jComponent = this.d_labels.get(n);
        return jComponent.getFont();
    }

    public void clearMessages() {
        for (int i = 0; i < this.d_labels.size(); ++i) {
            this.setMessage(i, "");
        }
    }

    @Override
    public void statusMessageChanged(String string, String string2) {
        this.setMessage(string2);
    }
}

