/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.TaskProgress;

public class guiProgressMonitor {
    private final Window d_parent;
    private final boolean d_modal;
    private final String d_title;
    private final TaskProgress d_progress;
    private MonitorDlg d_dialog;
    private boolean d_closed;
    private Timer d_showTimer;
    private int d_delayMS;
    private boolean d_confirmOnCancel;
    private Consumer<guiDialog> d_cancel;
    private String d_cancelText;

    public guiProgressMonitor(Window window, String string, boolean bl, TaskProgress taskProgress) {
        this(window, string, bl, taskProgress, 500);
    }

    public guiProgressMonitor(Window window, String string, boolean bl, TaskProgress taskProgress, int n) {
        this(window, string, bl, taskProgress, n, false);
    }

    public guiProgressMonitor(Window window, String string, boolean bl, TaskProgress taskProgress, int n, boolean bl2) {
        this.d_modal = bl;
        this.d_title = string;
        this.d_parent = window;
        this.d_closed = false;
        this.d_progress = taskProgress;
        this.d_delayMS = n;
        this.d_confirmOnCancel = bl2;
        this.d_cancel = guiDialog2 -> taskProgress.cancel();
    }

    public void setCancelOp(Consumer<guiDialog> consumer) {
        this.d_cancel = consumer;
    }

    public void setConfirmOnCancel(boolean bl) {
        this.d_confirmOnCancel = bl;
    }

    public boolean getConfirmOnCancel() {
        return this.d_confirmOnCancel;
    }

    public void setPopupDelay(int n) {
        this.d_delayMS = n;
    }

    public int getPopupDelay() {
        return this.d_delayMS;
    }

    public void setCancelText(String string) {
        if (this.d_dialog != null) {
            this.d_dialog.getButton(8).setText(string);
        }
        this.d_cancelText = string;
    }

    public void begin() {
        this.run(new Runnable(){

            @Override
            public void run() {
                guiProgressMonitor.this.beginEventThread();
            }
        });
    }

    private void beginEventThread() {
        if (this.d_showTimer != null || this.d_dialog != null) {
            return;
        }
        if (this.d_delayMS <= 0) {
            this.showDialog();
        } else {
            this.d_showTimer = new Timer(this.d_delayMS, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (guiProgressMonitor.this.d_progress == null || guiProgressMonitor.this.d_progress.isRunning()) {
                        guiProgressMonitor.this.showDialog();
                    }
                }
            });
            this.d_showTimer.setRepeats(false);
            this.d_showTimer.start();
        }
    }

    private void showDialog() {
        this.d_dialog = new MonitorDlg(this.d_parent, this.d_title, this.d_progress, this);
        this.d_dialog.setDefaultCloseOperation(0);
        this.d_dialog.setCancelValidator(guiDialog2 -> {
            int n;
            if (this.d_confirmOnCancel && this.d_progress.isRunning() && (n = JOptionPane.showConfirmDialog(this.d_dialog, Intl.intl("Are you sure you want to cancel?"), Intl.intl("Cancel?"), 0)) != 0) {
                return false;
            }
            this.d_cancel.accept((guiDialog)guiDialog2);
            return true;
        });
        if (this.d_cancelText != null) {
            this.d_dialog.getButton(8).setText(this.d_cancelText);
        }
        if (this.d_modal) {
            this.d_dialog.doModal();
        } else {
            this.d_dialog.doModeless();
        }
    }

    public void end() {
        this.run(new Runnable(){

            @Override
            public void run() {
                guiProgressMonitor.this.endEventThread();
            }
        });
    }

    private void endEventThread() {
        if (this.d_dialog != null) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        guiProgressMonitor.this.d_dialog.setVisible(false);
                    }
                });
            } else {
                this.d_dialog.setVisible(false);
            }
        }
        if (this.d_showTimer != null) {
            this.d_showTimer.stop();
        }
    }

    private void run(Runnable runnable) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private static class MonitorDlg
    extends guiDialog {
        private final guiLabel d_messageLbl;
        private final JProgressBar d_progBar;
        private final TaskProgress d_progress;
        private guiProgressMonitor d_guiProgressMonitor;

        public MonitorDlg(Window window, String string, TaskProgress taskProgress, guiProgressMonitor guiProgressMonitor2) {
            super(window, string, 8);
            this.d_progress = taskProgress;
            this.d_guiProgressMonitor = guiProgressMonitor2;
            Icon icon = UIManager.getIcon("OptionPane.informationIcon");
            guiLabel guiLabel2 = new guiLabel(icon);
            this.d_messageLbl = new guiLabel("testtext");
            this.d_messageLbl.setPreferredSize(new Dimension(200, this.d_messageLbl.getPreferredSize().height));
            this.d_messageLbl.setText("");
            this.d_progBar = new JProgressBar();
            this.d_progBar.setPreferredSize(new Dimension(200, this.d_progBar.getPreferredSize().height));
            guiPanel guiPanel2 = new guiPanel(new BorderLayout());
            guiPanel2.add((Component)guiLabel2, "North");
            guiPanel guiPanel3 = new guiPanel();
            guiPanel3.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel3);
            gridBagHelper.addFilledRow(this.d_messageLbl);
            gridBagHelper.addFilledRow(this.d_progBar);
            guiPanel guiPanel4 = this.getDialogPane();
            guiPanel4.setLayout(new BorderLayout());
            guiPanel4.add((Component)guiPanel2, "West");
            guiPanel4.add((Component)guiPanel3, "Center");
            this.setResizable(true);
            final Timer timer = new Timer(16, actionEvent -> this.update());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    timer.stop();
                }
            });
            timer.start();
            this.update();
        }

        public void update() {
            int[] nArray;
            if (!this.d_progress.isRunning()) {
                this.d_guiProgressMonitor.end();
            }
            if ((nArray = this.d_progress.getProgress()) == null) {
                this.d_progBar.setStringPainted(false);
                this.d_progBar.setIndeterminate(true);
            } else {
                this.d_progBar.setStringPainted(true);
                this.d_progBar.setIndeterminate(false);
                this.d_progBar.setMaximum(nArray[1]);
                this.d_progBar.setValue(nArray[0]);
            }
            this.d_messageLbl.setText(this.d_progress.getMessage());
            this.repaint();
        }
    }
}

