/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiUtil;

public class guiPanel
extends JPanel
implements Modifiable,
Validateable,
ContainerListener {
    protected final Comm d_comm;
    private WaitCursorMgr d_waitCursorMgr;
    private Map<Component, Integer> d_validateOpts = Collections.EMPTY_MAP;
    private Map<Object, ComponentGroup2<? extends Component>> d_groups = Collections.EMPTY_MAP;

    public guiPanel() {
        this(new BorderLayout());
    }

    public guiPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.d_comm = new Comm();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = SwingUtilities.getAncestorOfClass(RootPaneContainer.class, this);
        if (container != null) {
            this.d_waitCursorMgr = new WaitCursorMgr(container);
        }
    }

    public void setValidateOptions(Component component, int n) {
        if (n == 0) {
            this.d_validateOpts.remove(component);
            if (this.d_validateOpts.isEmpty()) {
                this.d_validateOpts = Collections.EMPTY_MAP;
            }
        } else {
            if (this.d_validateOpts.isEmpty()) {
                this.d_validateOpts = new IdentityHashMap<Component, Integer>();
            }
            this.d_validateOpts.put(component, n);
        }
    }

    public Comm getComm() {
        return this.d_comm;
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor();
        }
    }

    public void beginWaitCursor(boolean bl) {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor(bl);
        }
    }

    public void beginWaitCursor(int n) {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.beginWaitCursor(n);
        }
    }

    public void endWaitCursor() {
        if (this.d_waitCursorMgr != null) {
            this.d_waitCursorMgr.endWaitCursor();
        }
    }

    @Override
    public boolean isModified() {
        return guiPanel.isModified(this);
    }

    public <T extends Component> ComponentGroup2<T> group(Object object, T ... TArray) {
        return this.group(object, (Collection<T>)Arrays.asList(TArray));
    }

    public <T extends Component> ComponentGroup2<T> group(Object object, Collection<T> collection) {
        if (this.d_groups.isEmpty()) {
            this.d_groups = new HashMap<Object, ComponentGroup2<? extends Component>>();
        }
        ComponentGroup2<T> componentGroup2 = guiUtil.group(collection);
        this.d_groups.put(object, componentGroup2);
        return componentGroup2;
    }

    public ComponentGroup2<? extends Component> getGroup(Object object) {
        return this.d_groups.get(object);
    }

    public void setGroupEnabled(Object object, boolean bl) {
        ComponentGroup2<? extends Component> componentGroup2 = this.d_groups.get(object);
        if (componentGroup2 != null) {
            componentGroup2.setEnabled(bl);
        }
    }

    public void setGroupVisible(Object object, boolean bl) {
        ComponentGroup2<? extends Component> componentGroup2 = this.d_groups.get(object);
        if (componentGroup2 != null) {
            componentGroup2.setVisible(bl);
        }
    }

    protected void ungroup(Object object) {
        this.d_groups.remove(object);
        if (this.d_groups.isEmpty()) {
            this.d_groups = Collections.EMPTY_MAP;
        }
    }

    private static boolean isModified(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Modifiable && ((Modifiable)((Object)component)).isModified()) {
                return true;
            }
            if (!(component instanceof Container) || !guiPanel.isModified((Container)component)) continue;
            return true;
        }
        return false;
    }

    public final boolean validateData() throws Exception {
        throw new Exception("Fail. Epic Fail.");
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        return guiPanel.validateData(this, this.d_validateOpts, bl, bl2);
    }

    private static boolean validateData(Container container, Map<Component, Integer> map, boolean bl, boolean bl2) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            Component component = container.getComponent(i);
            if (!guiUtil.shouldValidateChild(component, n2 = map.getOrDefault(component, 0).intValue()) || !(component instanceof Validateable ? !((Validateable)((Object)component)).validateData(bl, bl2) : component instanceof Container && !guiPanel.validateData((Container)component, map, bl, bl2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setModified(boolean bl) {
        guiPanel.setModified(this, bl);
        this.d_comm.touch(this);
    }

    private static void setModified(Container container, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Modifiable) {
                ((Modifiable)((Object)component)).setModified(bl);
                continue;
            }
            if (!(component instanceof Container)) continue;
            guiPanel.setModified((Container)component, bl);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.register(component);
    }

    protected void register(Component component) {
        assert (component != this);
        if (component instanceof guiFormattedFld) {
            ((guiFormattedFld)component).addValueChangeListener(this.d_comm);
        } else if (component instanceof JTable) {
            ((JTable)component).getModel().addTableModelListener(this.d_comm);
        } else if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this.d_comm);
        } else if (component instanceof AbstractButton) {
            ((AbstractButton)component).addActionListener(this.d_comm);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(this.d_comm);
        } else if (component instanceof guiPanel) {
            ((guiPanel)component).addObserver(this.d_comm);
        } else if (component instanceof Container) {
            ((Container)component).addContainerListener(this);
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.register(componentArray[i]);
            }
        }
    }

    protected void unregister(Component component) {
        assert (component != this);
        if (component instanceof guiFormattedFld) {
            ((guiFormattedFld)component).removeValueChangeListener(this.d_comm);
        } else if (component instanceof JTextField) {
            ((JTextField)component).getDocument().removeDocumentListener(this.d_comm);
        } else if (component instanceof AbstractButton) {
            ((AbstractButton)component).removeActionListener(this.d_comm);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).removeActionListener(this.d_comm);
        } else if (component instanceof guiPanel) {
            ((guiPanel)component).addObserver(this.d_comm);
        } else if (component instanceof Container) {
            ((Container)component).removeContainerListener(this);
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.unregister(componentArray[i]);
            }
        }
    }

    public void addObserver(Observer observer) {
        this.d_comm.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.d_comm.deleteObserver(observer);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Utils.setEnabled(this.getComponents(), bl);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.register(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.unregister(containerEvent.getChild());
    }
}

