/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.guiCheckBox;

public class guiMultiStateCheckBox
extends guiCheckBox {
    public static final int MODE_TWOSTATE = 0;
    public static final int MODE_THREESTATE = 1;
    public static final int STATE_UNCHECKED = 0;
    public static final int STATE_CHECKED = 1;
    public static final int STATE_SEMICHECKED = 2;
    private static final int s_numStates = 3;
    public static final int ITEM_STATE_SET = 2000;
    private int d_mode = 0;
    private int d_state = 0;
    private boolean d_allowItemChangedFiring = true;

    public guiMultiStateCheckBox(Command command) {
        super(command);
        this.setupListeners();
    }

    public guiMultiStateCheckBox(String string) {
        super(string);
        this.setupListeners();
    }

    public guiMultiStateCheckBox(String string, boolean bl) {
        super(string, bl);
        this.setSelected(bl);
        this.setupListeners();
    }

    public guiMultiStateCheckBox(String string, int n) {
        super(string);
        this.setState(n);
        this.setupListeners();
    }

    public guiMultiStateCheckBox(String string, int n, int n2) {
        super(string);
        this.setMode(n2);
        this.setState(n);
        this.setupListeners();
    }

    private void setupListeners() {
    }

    private void updateSuperSelectedState(boolean bl) {
        this.d_allowItemChangedFiring = false;
        super.setSelected(bl);
        this.d_allowItemChangedFiring = true;
    }

    @Override
    public void setSelected(boolean bl) {
        this.updateSuperSelectedState(bl);
        this.setState(bl ? 1 : 0);
        this.fireItemStateChanged(new ItemEvent(this.getModel(), 2000, this.getModel(), bl ? 1 : 2));
    }

    @Override
    public boolean isSelected() {
        return this.d_state == 1;
    }

    public int getState() {
        return this.d_state;
    }

    public void setState(int n) {
        this.d_state = n;
        if (n == 2) {
            this.d_mode = 1;
        }
        this.updateSuperSelectedState(this.d_state == 1);
        this.repaint();
    }

    public void setMode(int n) {
        this.d_mode = n;
        if (n == 0 && this.d_state == 2) {
            this.setState(1);
        }
    }

    public int getMode() {
        return this.d_mode;
    }

    protected void incrState() {
        if (this.d_mode == 1) {
            this.setState((this.d_state + 1) % 3);
        } else {
            this.setState(this.d_state == 0 ? 1 : 0);
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent itemEvent) {
        if (!this.d_allowItemChangedFiring) {
            return;
        }
        if (itemEvent.getID() == 2000) {
            super.fireItemStateChanged(new ItemEvent(itemEvent.getItemSelectable(), 701, itemEvent.getItem(), itemEvent.getStateChange()));
        } else {
            this.incrState();
            super.fireItemStateChanged(itemEvent);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.d_state == 2) {
            Rectangle rectangle = this.getBounds();
            if (!this.isEnabled()) {
                graphics.setColor(Color.GRAY);
            } else {
                graphics.setColor(new Color(33, 161, 33));
            }
            graphics.fillRect(3, rectangle.height / 2 - 3, 7, 7);
        }
    }
}

