/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import thunderheadeng.Intl;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.CmdButton;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;

public class guiHelpDialog
extends JDialog
implements Validateable {
    private static String PAGE_NOT_FOUND = "/thunderheadeng/gui/pageNotFound.html";
    private guiPanel d_btnPanel;
    private guiPanel d_dialogPane;
    private Window d_owner;
    private Vector d_history;
    private int d_historyPos;
    private JEditorPane d_htmlView;
    private CmdButton d_forward;
    private CmdButton d_back;
    private URL d_notFoundURL;

    public guiHelpDialog(Dialog dialog, URL uRL) {
        super(dialog, Intl.intl("Help"));
        this.d_owner = dialog;
        this.d_history = new Vector(1);
        this.d_history.add(uRL);
        this.d_historyPos = this.d_history.indexOf(uRL);
        this.d_notFoundURL = this.getClass().getResource(PAGE_NOT_FOUND);
        this.getContentPane().setLayout(new BorderLayout());
        this.d_btnPanel = new guiPanel(new FlowLayout(2, 0, 0));
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.d_btnPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        this.d_btnPanel.add(jPanel);
        JButton jButton = new JButton(Intl.intl("Cancel"));
        JButton jButton2 = new JButton(Intl.intl("OK"));
        jButton2.setPreferredSize(jButton.getPreferredSize());
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (guiHelpDialog.this.validateData(true, true)) {
                    guiHelpDialog.this.dispose();
                }
            }
        });
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton2);
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(8, 2, 12, 2));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)this.d_btnPanel, "South");
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                guiHelpDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.d_dialogPane.add((Component)this.getToolBar(), "North");
        if (uRL != null) {
            try {
                this.d_htmlView = new JEditorPane(uRL);
                this.d_htmlView.addHyperlinkListener(new Hyperactive());
                this.d_htmlView.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(this.d_htmlView);
                jScrollPane.setVerticalScrollBarPolicy(22);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jScrollPane.setPreferredSize(new Dimension(600, 500));
                this.d_dialogPane.add((Component)jScrollPane, "Center");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.dispose();
            }
        }
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setLayout(new GridBagLayout());
        this.d_back = new CmdButton(new HelpBackCmd());
        this.d_forward = new CmdButton(new HelpForwardCmd());
        this.d_back.setToolTipText("Back");
        this.d_forward.setToolTipText("Forward");
        this.d_back.updateEnabled();
        this.d_forward.updateEnabled();
        GridBagUtil.add(jToolBar, this.d_back, 0, 0, 1, 1, 2, 0, 2, 2, 0, 0.0, 0.0);
        GridBagUtil.add(jToolBar, this.d_forward, 1, 0, 1, 1, 2, 0, 2, 12, 0, 0.0, 0.0);
        GridBagUtil.add(jToolBar, Box.createGlue(), 10, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        return jToolBar;
    }

    public void center() {
        Point point;
        Dimension dimension;
        Dimension dimension2 = this.getSize();
        if (this.d_owner == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            point = new Point(0, 0);
        } else {
            dimension = this.d_owner.getSize();
            point = this.d_owner.getLocation();
        }
        this.setLocation(point.x + dimension.width / 2 - dimension2.width / 2, point.y + dimension.height / 2 - dimension2.height / 2);
    }

    public void showHelp() {
        this.pack();
        this.center();
        this.setResizable(true);
        this.setModal(false);
        this.setVisible(true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        return !guiUtil.shouldValidateChild(this.d_dialogPane, 0) || this.d_dialogPane.validateData(bl, bl2);
    }

    private Vector truncate(Vector vector, int n) {
        if (n < 0 || n >= vector.size()) {
            return vector;
        }
        for (int i = n + 1; i < vector.size(); ++i) {
            vector.removeElementAt(i);
        }
        return vector;
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        jEditorPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Throwable throwable) {
                        if (guiHelpDialog.this.d_notFoundURL != null) {
                            try {
                                guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                            }
                            catch (IOException iOException) {
                                guiHelpDialog.this.d_htmlView.setText("");
                            }
                        }
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_history = guiHelpDialog.this.truncate(guiHelpDialog.this.d_history, guiHelpDialog.this.d_historyPos);
                guiHelpDialog.this.d_history.add(hyperlinkEvent.getURL());
                guiHelpDialog.this.d_historyPos = guiHelpDialog.this.d_history.indexOf(hyperlinkEvent.getURL());
                guiHelpDialog.this.d_back.updateEnabled();
                guiHelpDialog.this.d_forward.updateEnabled();
            }
        }
    }

    private class HelpForwardCmd
    extends AbstractCommand {
        public HelpForwardCmd() {
            super("", "/thunderheadeng/gui/graphics/right.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiHelpDialog.this.d_history.size() - 1 > guiHelpDialog.this.d_historyPos;
        }

        @Override
        public void execute() {
            if (guiHelpDialog.this.d_history.size() - 1 <= guiHelpDialog.this.d_historyPos) {
                return;
            }
            ++guiHelpDialog.this.d_historyPos;
            try {
                guiHelpDialog.this.d_htmlView.setPage((URL)guiHelpDialog.this.d_history.get(guiHelpDialog.this.d_historyPos));
            }
            catch (Throwable throwable) {
                if (guiHelpDialog.this.d_notFoundURL != null) {
                    try {
                        guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                    }
                    catch (IOException iOException) {
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_htmlView.setText("");
            }
            guiHelpDialog.this.d_back.updateEnabled();
            guiHelpDialog.this.d_forward.updateEnabled();
        }
    }

    private class HelpBackCmd
    extends AbstractCommand {
        public HelpBackCmd() {
            super("", "/thunderheadeng/gui/graphics/left.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiHelpDialog.this.d_historyPos > 0;
        }

        @Override
        public void execute() {
            if (guiHelpDialog.this.d_historyPos <= 0) {
                return;
            }
            --guiHelpDialog.this.d_historyPos;
            try {
                guiHelpDialog.this.d_htmlView.setPage((URL)guiHelpDialog.this.d_history.get(guiHelpDialog.this.d_historyPos));
            }
            catch (Throwable throwable) {
                if (guiHelpDialog.this.d_notFoundURL != null) {
                    try {
                        guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                    }
                    catch (IOException iOException) {
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_htmlView.setText("");
            }
            guiHelpDialog.this.d_back.updateEnabled();
            guiHelpDialog.this.d_forward.updateEnabled();
        }
    }
}

