/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.Command;
import thunderheadeng.gui.View;
import thunderheadeng.gui.WaitCursorMgr;

public class guiFrame
extends JFrame {
    private View d_view;
    private Command d_closeCommand;
    private final WaitCursorMgr d_waitCursorMgr;
    private final FrameProps d_frameProps;

    public guiFrame() {
        this((String)null);
    }

    public guiFrame(String string) {
        super(string, Application.getDefaultGraphicsConfiguration());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                Application application = Application.getApp();
                if (application != null) {
                    application.setActiveView(guiFrame.this.d_view);
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                guiFrame.this.close();
            }
        });
        this.d_waitCursorMgr = new WaitCursorMgr(this);
        this.d_frameProps = new FrameProps();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                this.saveBounds(componentEvent);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                this.saveBounds(componentEvent);
            }

            private void saveBounds(ComponentEvent componentEvent) {
                guiFrame.this.d_frameProps.update(guiFrame.this);
            }
        });
    }

    @Override
    public void setExtendedState(int n) {
        super.setExtendedState(n);
        this.d_frameProps.update(this);
    }

    public FrameProps getFrameProps() {
        return this.d_frameProps;
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        this.d_waitCursorMgr.beginWaitCursor();
    }

    public void beginWaitCursor(boolean bl) {
        this.d_waitCursorMgr.beginWaitCursor(bl);
    }

    public void beginWaitCursor(int n) {
        this.d_waitCursorMgr.beginWaitCursor(n);
    }

    public void endWaitCursor() {
        this.d_waitCursorMgr.endWaitCursor();
    }

    public boolean close() {
        if (this.d_closeCommand != null) {
            this.d_closeCommand.execute();
            return !this.d_closeCommand.breakCommandChain();
        }
        if (this.d_view != null) {
            if (!this.d_view.close()) {
                return false;
            }
            Application.getApp().getDocument().removeView(this.d_view);
        }
        this.dispose();
        return true;
    }

    @Override
    public void dispose() {
        Application application = Application.getApp();
        if (application != null) {
            application.removeFrame(this);
        }
        super.dispose();
    }

    public void setSize(double d) {
        if (d <= 0.0) {
            this.setExtendedState(1);
        } else if (d > 1.0) {
            this.setExtendedState(6);
        } else {
            this.setExtendedState(0);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (int)(d * (double)dimension.height);
            int n2 = n * 4 / 3;
            this.setSize(n2, n);
        }
    }

    public void center() {
        this.setLocationRelativeTo(null);
    }

    public void setView(View view) {
        this.d_view = view;
    }

    public View getView() {
        return this.d_view;
    }

    public void setCloseCommand(Command command) {
        this.d_closeCommand = command;
    }

    public static class FrameProps {
        public Rectangle lastBounds = null;
        public int lastExtendedState = 0;

        protected void update(guiFrame guiFrame2) {
            int n = guiFrame2.getExtendedState();
            if (n != 1) {
                this.lastExtendedState = n;
            }
            if (n == 0) {
                this.lastBounds = guiFrame2.getBounds();
            }
        }
    }
}

