/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.theUtil;

public class guiFormattedFld<T>
extends JFormattedTextField
implements Modifiable,
Validateable {
    public static final int VAL_COMMIT = ValueAction.COMMIT.id;
    public static final int VAL_CANCEL = ValueAction.CANCEL.id;
    public static final int VAL_CHANGE = ValueAction.CHANGE.id;
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll;
    private boolean d_modified;
    private boolean d_selectAllOnFocusEnabled;
    private PropertyChangeListener d_highlightOnErrorListener;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;
    private static final KeyStroke s_commitKS = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke s_cancelKS = KeyStroke.getKeyStroke(27, 0);

    public guiFormattedFld(Format format, T t) {
        this(new Formatter(format), t);
    }

    public guiFormattedFld(Formatter<T> formatter, T t) {
        this((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(formatter), t);
    }

    public guiFormattedFld(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, T t) {
        super(new FormatterFactory(abstractFormatterFactory, false));
        this.init(t);
    }

    private void init(T t) {
        this.d_selectAll = true;
        this.d_selectAllOnFocusEnabled = true;
        this.d_highlightOnErrorListener = null;
        Dimension dimension = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, dimension.height));
        this.setHorizontalAlignment(2);
        this.setInputVerifier(new Verifier(true));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                guiFormattedFld.this.d_selectAll = false;
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component.isEnabled() && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = guiFormattedFld.this.getRightClickMenu();
                    jPopupMenu.setLocation(mouseEvent.getPoint());
                    jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addValueListener(VAL_CHANGE, propertyChangeEvent -> {
            if (!theUtil.equal(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue())) {
                this.d_modified = true;
            }
        });
        this.setHighlightOnError(true);
        this.setFocusLostBehavior(0);
        this.setValue(t);
        this.setModified(false);
    }

    @Override
    public void commitEdit() throws ParseException {
        super.commitEdit();
        this.firePropertyChange(ValueAction.COMMIT.name, false, true);
    }

    public Format getFormat() {
        if (this.getFormatter() instanceof Formatter) {
            return ((Formatter)this.getFormatter()).getFormat();
        }
        return null;
    }

    public Predicate<T> getFilter() {
        return this.getFormatter() instanceof Formatter ? ((Formatter)this.getFormatter()).getFilter() : Filters.acceptAll();
    }

    public void setFilter(Predicate<T> predicate) {
        if (this.getFormatter() instanceof Formatter) {
            ((Formatter)this.getFormatter()).setFilter(predicate);
        }
    }

    public boolean getNullAllowed() {
        return this.getFormatter() instanceof Formatter ? ((Formatter)this.getFormatter()).d_nullAllowed : true;
    }

    public void setNullAllowed(boolean bl) {
        if (this.getFormatter() instanceof Formatter) {
            ((Formatter)this.getFormatter()).setNullAllowed(bl);
        }
    }

    public void setHighlightOnError(boolean bl) {
        if (bl && this.d_highlightOnErrorListener == null) {
            this.d_highlightOnErrorListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    guiFormattedFld.this.updateValidState();
                }
            };
            this.addPropertyChangeListener("editValid", this.d_highlightOnErrorListener);
        } else if (!bl && this.d_highlightOnErrorListener != null) {
            this.removePropertyChangeListener("editValid", this.d_highlightOnErrorListener);
            this.d_highlightOnErrorListener = null;
        }
        this.updateValidState();
    }

    public boolean getHightlightOnError() {
        return this.d_highlightOnErrorListener != null;
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.isTemporary()) {
            return;
        }
        if (focusEvent.getID() == 1005) {
            this.d_selectAll = true;
        } else if (this.d_selectAllOnFocusEnabled && this.d_selectAll) {
            this.selectAll();
        }
    }

    protected void updateValidState() {
        if (!this.getHightlightOnError() || this.isEditValid()) {
            Border border = this.getBorder();
            if (border instanceof InvalidBorder) {
                InvalidBorder invalidBorder = (InvalidBorder)border;
                Border border2 = invalidBorder.getInsideBorder();
                this.setBorder(border2);
            }
        } else {
            Border border = this.getBorder();
            if (!(border instanceof InvalidBorder)) {
                this.setBorder(new InvalidBorder(border));
            }
        }
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.d_selectAllOnFocusEnabled = bl;
    }

    public boolean getSelectAllOnFocus() {
        return this.d_selectAllOnFocusEnabled;
    }

    public void setYieldFocusOnError(boolean bl) {
        ((Verifier)this.getInputVerifier()).setYieldFocusOnErrorEnabled(bl);
    }

    public boolean getYieldFocusOnError() {
        return ((Verifier)this.getInputVerifier()).isYieldFocusOnErrorEnabled();
    }

    public void setDefaultCommand(final Consumer<? super ActionEvent> consumer) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "defaultCommand");
        this.getActionMap().put("defaultCommand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                consumer.accept(actionEvent);
            }
        });
    }

    public void setCommitOnValidEdit(boolean bl) {
        FormatterFactory formatterFactory = this.getFormatterFactory();
        if (formatterFactory != null) {
            formatterFactory.setCommitOnValidEdit(this, bl);
        }
    }

    public boolean getCommitOnValidEdit() {
        return this.getFormatterFactory().d_commitOnValidEdit;
    }

    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addValueListener(VAL_CHANGE, propertyChangeListener);
    }

    public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removeValueListener(VAL_CHANGE, propertyChangeListener);
    }

    public PropertyChangeListener[] getValueChangeListeners() {
        return theUtil.toArray(this.getValueListeners(VAL_CHANGE), PropertyChangeListener.class);
    }

    public void addValueCommitListener(PropertyChangeListener propertyChangeListener) {
        this.addValueListener(VAL_COMMIT, propertyChangeListener);
    }

    public void removeValueCommitListener(PropertyChangeListener propertyChangeListener) {
        this.removeValueListener(VAL_COMMIT, propertyChangeListener);
    }

    public PropertyChangeListener[] getValueCommitListeners() {
        return theUtil.toArray(this.getValueListeners(VAL_COMMIT), PropertyChangeListener.class);
    }

    public static int getValueChangeId(String string) {
        for (ValueAction valueAction : ValueAction.values()) {
            if (!string.equals(valueAction.name)) continue;
            return valueAction.id;
        }
        return -1;
    }

    public void addValueListener(int n, PropertyChangeListener propertyChangeListener) {
        for (ValueAction valueAction : ValueAction.values()) {
            if ((n & valueAction.id) != valueAction.id) continue;
            this.addPropertyChangeListener(valueAction.name, propertyChangeListener);
        }
    }

    public void removeValueListener(int n, PropertyChangeListener propertyChangeListener) {
        for (ValueAction valueAction : ValueAction.values()) {
            if ((n & valueAction.id) != valueAction.id) continue;
            this.removePropertyChangeListener(valueAction.name, propertyChangeListener);
        }
    }

    public Collection<PropertyChangeListener> getValueListeners(int n) {
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>();
        for (ValueAction valueAction : ValueAction.values()) {
            if ((n & valueAction.id) != valueAction.id) continue;
            arrayList.addAll(Arrays.asList(this.getPropertyChangeListeners(valueAction.name)));
        }
        return arrayList;
    }

    private JPopupMenu getRightClickMenu() {
        Object object;
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            object = new DefaultEditorKit.CutAction();
            object.putValue("Name", Intl.intl("Cut"));
            object.putValue("SmallIcon", guiUtil.loadTeciIcon("Cut16.gif"));
            DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
            copyAction.putValue("Name", Intl.intl("Copy"));
            copyAction.putValue("SmallIcon", guiUtil.loadTeciIcon("Copy16.gif"));
            DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
            pasteAction.putValue("Name", Intl.intl("Paste"));
            pasteAction.putValue("SmallIcon", guiUtil.loadTeciIcon("Paste16.gif"));
            AbstractAction abstractAction = new AbstractAction(Intl.intl("Delete")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiFormattedFld.this.replaceSelection("");
                }
            };
            abstractAction.putValue("SmallIcon", guiUtil.loadTeciIcon("Delete16.gif"));
            AbstractAction abstractAction2 = new AbstractAction(Intl.intl("Select All")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiFormattedFld.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, (Action)object);
            this.d_rightClickMenuActions.put(COPY, copyAction);
            this.d_rightClickMenuActions.put(PASTE, pasteAction);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, abstractAction);
            this.d_rightClickMenuActions.put(SELECT_ALL, abstractAction2);
            this.d_rightClickMenu.add((Action)object);
            this.d_rightClickMenu.add(copyAction);
            this.d_rightClickMenu.add(pasteAction);
            this.d_rightClickMenu.add(abstractAction);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(abstractAction2);
        }
        object = this.getSelectedText();
        boolean bl = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(COPY).setEnabled(object != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(bl);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (object == null || ((String)object).length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public T getValue() {
        return (T)super.getValue();
    }

    public boolean isEmpty() {
        return this.getText().trim().equals("");
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (bl2 && keyStroke.equals(s_commitKS) && this.isEditValid()) {
            this.setValue(this.getValue());
            this.selectAll();
        } else if (bl2 && keyStroke.equals(s_cancelKS)) {
            this.selectAll();
            this.firePropertyChange(ValueAction.CANCEL.name, false, true);
        }
        return bl2;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        try {
            InputVerifier inputVerifier = this.getInputVerifier();
            ((Verifier)inputVerifier).check(this);
            if (bl2) {
                this.commitEdit();
            }
        }
        catch (ParseException parseException) {
            if (bl) {
                this.showMessageBox(parseException.getLocalizedMessage(), true);
            }
            if (bl2) {
                this.requestFocusHack();
            }
            return false;
        }
        return true;
    }

    protected void showMessageBox(String string) {
        this.showMessageBox(string, false);
    }

    protected void showMessageBox(String string, boolean bl) {
        int n = this.getFocusLostBehavior();
        FocusListener[] focusListenerArray = null;
        if (bl) {
            this.setFocusLostBehavior(3);
            for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
                this.removeFocusListener(focusListener);
            }
        }
        FocusListener[] focusListenerArray2 = (FocusListener[])SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog((Component)focusListenerArray2, string, Intl.intl("Invalid Entry"), 2);
        if (bl) {
            for (FocusListener focusListener : focusListenerArray) {
                this.addFocusListener(focusListener);
            }
            this.setFocusLostBehavior(n);
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiFormattedFld.this.requestFocus();
            }
        });
    }

    @Override
    public final void setInputVerifier(InputVerifier inputVerifier) {
        if (!(inputVerifier instanceof Verifier)) {
            return;
        }
        this.setInputVerifier((Verifier)inputVerifier);
    }

    public void setInputVerifier(Verifier<T> verifier) {
        super.setInputVerifier(verifier);
    }

    @Override
    public Verifier<T> getInputVerifier() {
        return (Verifier)super.getInputVerifier();
    }

    @Override
    public JFormattedTextField.AbstractFormatter getFormatter() {
        return super.getFormatter();
    }

    public void setFormatter(Formatter formatter) {
        this.setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    @Override
    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
        if (!(abstractFormatterFactory instanceof FormatterFactory)) {
            FormatterFactory formatterFactory = this.getFormatterFactory();
            abstractFormatterFactory = formatterFactory != null ? formatterFactory.newFactory(abstractFormatterFactory) : new FormatterFactory(abstractFormatterFactory, false);
        }
        super.setFormatterFactory(abstractFormatterFactory);
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return (FormatterFactory)super.getFormatterFactory();
    }

    public static class Verifier<T>
    extends InputVerifier {
        private boolean d_yieldFocusOnError;

        public Verifier(boolean bl) {
            this.d_yieldFocusOnError = bl;
        }

        public boolean isYieldFocusOnErrorEnabled() {
            return this.d_yieldFocusOnError;
        }

        public void setYieldFocusOnErrorEnabled(boolean bl) {
            this.d_yieldFocusOnError = bl;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            try {
                this.check(jComponent);
            }
            catch (ParseException parseException) {
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldYieldFocus(JComponent jComponent) {
            return this.isYieldFocusOnErrorEnabled() || super.shouldYieldFocus(jComponent);
        }

        public void check(JComponent jComponent) throws ParseException {
            assert (jComponent instanceof guiFormattedFld);
            guiFormattedFld guiFormattedFld2 = (guiFormattedFld)jComponent;
            JFormattedTextField.AbstractFormatter abstractFormatter = guiFormattedFld2.getFormatter();
            if (abstractFormatter != null) {
                String string = guiFormattedFld2.getText();
                abstractFormatter.stringToValue(string);
            }
        }
    }

    public static class Formatter<T>
    extends InternationalFormatter
    implements IObserver {
        private Predicate<T> d_filter;
        private boolean d_nullAllowed;

        public Formatter(Format format) {
            this(format, null, false);
        }

        public Formatter(Format format, Predicate<T> predicate) {
            this(format, predicate, false);
        }

        public Formatter(Format format, boolean bl) {
            this(format, null, bl);
        }

        public Formatter(Format format, Predicate<T> predicate, boolean bl) {
            super(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
            this.d_filter = predicate;
            this.d_nullAllowed = bl;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Formatter formatter = (Formatter)super.clone();
            if (formatter.getFormat() instanceof IObservable) {
                ((IObservable)((Object)formatter.getFormat())).addObserver(formatter, true);
            }
            return formatter;
        }

        public Formatter newFormatter(Format format) {
            return this.newFormatter(format, null);
        }

        public Formatter newFormatter(Format format, Predicate<T> predicate) {
            try {
                Formatter formatter = (Formatter)this.clone();
                formatter.setFormat(format);
                formatter.d_filter = predicate;
                formatter.d_nullAllowed = this.d_nullAllowed;
                return formatter;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return new Formatter<T>(format);
            }
        }

        @Override
        public void setFormat(Format format) {
            if (this.getFormat() instanceof IObservable) {
                ((IObservable)((Object)this.getFormat())).deleteObserver(this);
            }
            super.setFormat(format);
            if (format instanceof IObservable) {
                ((IObservable)((Object)format)).addObserver(this, true);
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            Format format = this.getFormat();
            if (format == null) {
                if (object == null) {
                    return "";
                }
                return object.toString();
            }
            return format.format(object);
        }

        @Override
        public void install(JFormattedTextField jFormattedTextField) {
            if (jFormattedTextField != null) {
                JFormattedTextField jFormattedTextField2 = this.getFormattedTextField();
                int n = jFormattedTextField.getDocument().getLength();
                int n2 = jFormattedTextField.getCaretPosition();
                super.install(jFormattedTextField);
                if (jFormattedTextField2 == jFormattedTextField && n == jFormattedTextField.getDocument().getLength()) {
                    jFormattedTextField.setCaretPosition(n2);
                }
            } else {
                super.install(jFormattedTextField);
            }
        }

        @Override
        public void update(IObservable iObservable, Object object) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null && !jFormattedTextField.isFocusOwner()) {
                this.uninstall();
                if (jFormattedTextField.getFormatter() == this) {
                    this.install(jFormattedTextField);
                } else {
                    this.install(null);
                }
            }
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            Object object = super.stringToValue(string);
            if (object == null && !this.isNullAllowed()) {
                throw new ParseException(Intl.intl("Empty values are not allowed."), 0);
            }
            if (this.d_filter != null && object != null && !this.d_filter.test(object)) {
                throw new ParseException(this.d_filter.toString(), 0);
            }
            return object;
        }

        public Predicate<T> getFilter() {
            return this.d_filter;
        }

        public void setFilter(Predicate<T> predicate) {
            this.d_filter = predicate;
        }

        public boolean isNullAllowed() {
            return this.d_nullAllowed;
        }

        public void setNullAllowed(boolean bl) {
            this.d_nullAllowed = bl;
        }
    }

    public static class FormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory
    implements Cloneable {
        private boolean d_commitOnValidEdit;
        private JFormattedTextField.AbstractFormatterFactory d_baseFactory;

        public FormatterFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, boolean bl) {
            this.d_baseFactory = abstractFormatterFactory;
            this.d_commitOnValidEdit = bl;
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            JFormattedTextField.AbstractFormatter abstractFormatter = this.d_baseFactory.getFormatter(jFormattedTextField);
            this.updateFormatter(abstractFormatter);
            return abstractFormatter;
        }

        public FormatterFactory clone() {
            try {
                FormatterFactory formatterFactory = (FormatterFactory)super.clone();
                return formatterFactory;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }

        public FormatterFactory newFactory(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory) {
            FormatterFactory formatterFactory = this.clone();
            formatterFactory.d_baseFactory = abstractFormatterFactory;
            return formatterFactory;
        }

        public void setCommitOnValidEdit(JFormattedTextField jFormattedTextField, boolean bl) {
            this.d_commitOnValidEdit = bl;
            this.updateFormatter(jFormattedTextField.getFormatter());
        }

        public void updateFormatter(JFormattedTextField.AbstractFormatter abstractFormatter) {
            if (abstractFormatter instanceof DefaultFormatter) {
                ((DefaultFormatter)abstractFormatter).setCommitsOnValidEdit(this.d_commitOnValidEdit);
            }
        }
    }

    protected static class InvalidBorder
    extends CompoundBorder {
        public InvalidBorder(Border border) {
            super(BorderFactory.createLineBorder(Color.RED), border);
        }
    }

    private static enum ValueAction {
        COMMIT("commit", 1),
        CANCEL("cancel", 2),
        CHANGE("value", 4);

        public final String name;
        public final int id;

        private ValueAction(String string2, int n2) {
            this.name = string2;
            this.id = n2;
        }
    }
}

