/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.io.CompositeFileFilter;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.io.FilenameManager;

public class guiFileChooser
extends JFileChooser {
    private boolean d_mustExist = true;
    private boolean d_promptOverwrite = true;
    private boolean d_allowPathCreate = true;
    private final CompositeFileFilter d_allSupportedTypesFilter = new CompositeFileFilter(Intl.intl("All Supported Types"));

    public guiFileChooser() {
        String string = null;
        if (Application.getApp() != null) {
            string = Application.getApp().getWorkingDir();
        }
        if (string != null) {
            this.setCurrentDirectory(new File(string));
        }
    }

    public guiFileChooser(FileFilter fileFilter) {
        this();
        this.addChoosableFileFilter(fileFilter);
    }

    public guiFileChooser(String string, String string2) {
        this();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension(string);
        exampleFileFilter.setDescription(string2);
        this.addChoosableFileFilter(exampleFileFilter);
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        super.setFileFilter(fileFilter);
        if (fileFilter instanceof ExampleFileFilter && this.getUI() instanceof BasicFileChooserUI) {
            String[] stringArray;
            BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)this.getUI();
            ExampleFileFilter exampleFileFilter = (ExampleFileFilter)fileFilter;
            String[] stringArray2 = exampleFileFilter.getFilters();
            String string = basicFileChooserUI.getFileName();
            if (!(string.isEmpty() || stringArray2.length <= 0 || exampleFileFilter.accept(new File(string)) || (stringArray = FilenameManager.splitFilename(string))[0].isEmpty() || stringArray[1].isEmpty())) {
                string = stringArray[0] + "." + stringArray2[0];
                basicFileChooserUI.setFileName(string);
            }
        }
    }

    @Override
    public void setCurrentDirectory(File file) {
        this.setCurrentDirectory(file, true);
    }

    public void setCurrentDirectory(File file, boolean bl) {
        super.setCurrentDirectory(file);
        if (Application.getApp() != null && bl && file != null) {
            Application.getApp().setWorkingDir(file.getPath());
        }
    }

    public void setMustExist(boolean bl) {
        this.d_mustExist = bl;
    }

    public boolean getMustExist() {
        return this.d_mustExist;
    }

    public void setPromptOverwrite(boolean bl) {
        this.d_promptOverwrite = bl;
    }

    public boolean getPromptOverwrite() {
        return this.d_promptOverwrite;
    }

    public void setAllowPathCreate(boolean bl) {
        this.d_allowPathCreate = bl;
    }

    public boolean getAllowPathCreate() {
        return this.d_allowPathCreate;
    }

    public String getFilename() {
        try {
            return this.getSelectedFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.getSelectedFile().getAbsolutePath();
        }
    }

    @Override
    public int showDialog(Component component, String string) {
        int n = super.showDialog(component, string);
        if (n == 0 && Application.getApp() != null) {
            Application.getApp().setWorkingDir(this.getSelectedFile().getParent());
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void approveSelection() {
        block12: {
            File file;
            block11: {
                file = this.getSelectedFile();
                if (this.getDialogType() != 1) break block11;
                if ((file = this.addExtension(file)) != null && file.exists()) {
                    int n;
                    if (!file.canWrite()) {
                        JOptionPane.showMessageDialog(this, Intl.intl("File is read-only. Please choose another file name."), Intl.intl("Read-only"), 0);
                        return;
                    }
                    if (this.d_promptOverwrite && (n = JOptionPane.showOptionDialog(this, Intl.intl("File already exists. Overwrite?"), Intl.intl("Overwrite existing file?"), 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    break block12;
                } else {
                    if (file == null) {
                        JOptionPane.showMessageDialog(this, Intl.intl("The specified path does not exist. Please create the directory or save to an existing directory."), Intl.intl("Directory does not exist"), 1);
                        return;
                    }
                    if (!guiFileChooser.isFilenameLegal(file.getAbsolutePath())) {
                        JOptionPane.showMessageDialog(this, Intl.intl("Cannot create the specified path because it contains any of the following illegal characters:\n: * ? \" < > |"), Intl.intl("Illegal Characters"), 1);
                        return;
                    }
                    File file2 = file.getParentFile();
                    if (!file2.exists()) {
                        if (!this.getAllowPathCreate()) {
                            JOptionPane.showMessageDialog(this, Intl.intl("The specified path does not exist. Please create the directory or save to an existing directory."), Intl.intl("Directory does not exist"), 1);
                            return;
                        }
                        if (!file2.mkdir()) {
                            JOptionPane.showMessageDialog(this, Intl.intl("Could not create the specified path. Please enter a valid pathname where you have write access."), Intl.intl("Could not create path"), 1);
                            return;
                        }
                    }
                }
                break block12;
            }
            if (this.getDialogType() == 0) {
                file = this.addExtension(file);
                if (this.d_mustExist && (file == null || !file.exists())) {
                    JOptionPane.showMessageDialog(this, Intl.intl("Can't find selected file. Please select an existing file."), Intl.intl("Can't find file"), 1);
                    return;
                }
            }
        }
        super.approveSelection();
    }

    private File addExtension(File file) {
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter != null && fileFilter instanceof ExampleFileFilter) {
            String[] stringArray = ((ExampleFileFilter)fileFilter).getFilters();
            if (file != null && stringArray != null && stringArray.length > 0) {
                String string = null;
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = file.getAbsolutePath();
                }
                if (string.indexOf(46) < 0) {
                    file = new File(string + "." + stringArray[0]);
                    this.setSelectedFile(file);
                }
            }
        }
        return file;
    }

    @Override
    public void resetChoosableFileFilters() {
        this.d_allSupportedTypesFilter.resetFilters();
        super.resetChoosableFileFilters();
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
        super.addChoosableFileFilter(fileFilter);
        this.setFileFilter(fileFilter);
        if (this.d_allSupportedTypesFilter != null && fileFilter != this.getAcceptAllFileFilter()) {
            this.d_allSupportedTypesFilter.addFilter(fileFilter);
        }
    }

    @Override
    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        boolean bl = super.removeChoosableFileFilter(fileFilter);
        if (this.d_allSupportedTypesFilter != null) {
            this.d_allSupportedTypesFilter.removeFilter(fileFilter);
        }
        return bl;
    }

    public CompositeFileFilter getAllSupportedTypesFilter() {
        return this.d_allSupportedTypesFilter;
    }

    public void setAllSupportedTypesFilterEnabled(boolean bl) {
        if (bl) {
            super.addChoosableFileFilter(this.d_allSupportedTypesFilter);
            this.setFileFilter(this.d_allSupportedTypesFilter);
        } else {
            super.removeChoosableFileFilter(this.d_allSupportedTypesFilter);
        }
    }

    public void selectFirstAppropriateFilter(File file) {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        if (file != null && !file.getName().isEmpty()) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (!fileFilterArray[i].accept(file)) continue;
                this.setFileFilter(fileFilterArray[i]);
                return;
            }
        } else if (fileFilterArray.length > 0 && this.getFileFilter().equals(this.getAcceptAllFileFilter())) {
            this.setFileFilter(fileFilterArray[0]);
        }
    }

    private void prepareFilters() {
        if (this.isAcceptAllFileFilterUsed()) {
            this.setAcceptAllFileFilterUsed(true);
        }
        this.selectFirstAppropriateFilter(this.getSelectedFile());
    }

    @Override
    public int showOpenDialog(Component component) throws HeadlessException {
        this.prepareFilters();
        try {
            return super.showOpenDialog(component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    @Override
    public int showSaveDialog(Component component) throws HeadlessException {
        this.prepareFilters();
        int n = super.showSaveDialog(component);
        if (n == 0) {
            File file = super.getSelectedFile();
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof ExampleFileFilter) {
                ExampleFileFilter exampleFileFilter = (ExampleFileFilter)fileFilter;
                this.setSelectedFile(exampleFileFilter.appendExtension(file));
            }
        }
        return n;
    }

    public static boolean isFilenameLegal(String string) {
        return string.lastIndexOf(58) < 2 && string.indexOf(42) < 0 && string.indexOf(63) < 0 && string.indexOf(34) < 0 && string.indexOf(60) < 0 && string.indexOf(62) < 0 && string.indexOf(124) < 0;
    }
}

