/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import thunderheadeng.Intl;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;

public abstract class guiField
extends JTextField
implements Modifiable,
Validateable {
    private static final String CUT = "cut-to-clipboard";
    private static final String COPY = "copy-to-clipboard";
    private static final String PASTE = "paste-from-clipboard";
    private static final String DELETE_SELECTION = "delete-selection";
    private static final String SELECT_ALL = "select-all";
    private boolean d_selectAll = true;
    private boolean d_validate = false;
    private Map<Object, Action> d_rightClickMenuActions;
    private JPopupMenu d_rightClickMenu;

    public guiField() {
        Dimension dimension = this.getPreferredSize();
        this.setPreferredSize(new Dimension(90, dimension.height));
        this.setHorizontalAlignment(2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (guiField.this.d_selectAll) {
                            guiField.this.selectAll();
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    guiField.this.d_selectAll = true;
                    if (guiField.this.d_validate) {
                        guiField.this.validateData();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                guiField.this.d_selectAll = false;
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component.isEnabled() && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = guiField.this.getRightClickMenu();
                    jPopupMenu.setLocation(mouseEvent.getPoint());
                    jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private JPopupMenu getRightClickMenu() {
        Object object;
        if (this.d_rightClickMenu == null) {
            this.d_rightClickMenu = new JPopupMenu();
            this.d_rightClickMenuActions = new HashMap<Object, Action>();
            object = new DefaultEditorKit.CutAction();
            object.putValue("Name", Intl.intl("Cut"));
            DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
            copyAction.putValue("Name", Intl.intl("Copy"));
            DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
            pasteAction.putValue("Name", Intl.intl("Paste"));
            AbstractAction abstractAction = new AbstractAction(Intl.intl("Delete")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiField.this.replaceSelection("");
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(Intl.intl("Select All")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    guiField.this.selectAll();
                }
            };
            this.d_rightClickMenuActions.put(CUT, (Action)object);
            this.d_rightClickMenuActions.put(COPY, copyAction);
            this.d_rightClickMenuActions.put(PASTE, pasteAction);
            this.d_rightClickMenuActions.put(DELETE_SELECTION, abstractAction);
            this.d_rightClickMenuActions.put(SELECT_ALL, abstractAction2);
            this.d_rightClickMenu.add((Action)object);
            this.d_rightClickMenu.add(copyAction);
            this.d_rightClickMenu.add(pasteAction);
            this.d_rightClickMenu.add(abstractAction);
            this.d_rightClickMenu.addSeparator();
            this.d_rightClickMenu.add(abstractAction2);
        }
        object = this.getSelectedText();
        boolean bl = this.isEnabled() && this.isEditable();
        this.d_rightClickMenuActions.get(CUT).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(COPY).setEnabled(object != null);
        this.d_rightClickMenuActions.get(PASTE).setEnabled(bl);
        this.d_rightClickMenuActions.get(DELETE_SELECTION).setEnabled(object != null && bl);
        this.d_rightClickMenuActions.get(SELECT_ALL).setEnabled(!this.getText().isEmpty() && (object == null || ((String)object).length() < this.getText().length()));
        return this.d_rightClickMenu;
    }

    public void setAutoValidate(boolean bl) {
        this.d_validate = bl;
    }

    protected void showMessageBox(String string) {
        this.showMessageBox(string, false);
    }

    protected void showMessageBox(String string, boolean bl) {
        FocusListener[] focusListenerArray = null;
        if (bl) {
            for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
                this.removeFocusListener(focusListener);
            }
        }
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        JOptionPane.showMessageDialog(window, string, Intl.intl("Invalid Entry"), 2);
        if (bl) {
            for (FocusListener focusListener : focusListenerArray) {
                this.addFocusListener(focusListener);
            }
        }
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiField.this.requestFocus();
            }
        });
    }

    public boolean validateData() {
        return this.validateData(true, true);
    }
}

