/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiField;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;

public class guiDialog
extends JDialog
implements Modifiable,
Validateable {
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int RESET = 4;
    public static final int CANCEL = 8;
    public static final int CLOSE = 16;
    public static final int HELP = 32;
    private guiPanel d_btnPanel;
    private guiPanel d_dialogPane;
    protected int d_status;
    private Window d_owner = null;
    private Vector d_listeners = new Vector();
    private JButton d_helpButton;
    private JButton d_okButton;
    private JButton d_cancelButton;
    private JButton d_closeButton;
    private JButton d_resetButton;
    private JButton d_applyButton;
    protected CancelListener d_cancelListener;
    private boolean d_minimumSizeEnabled = false;
    private boolean d_disposeAfterModal = true;
    private Predicate<guiDialog> d_validateCancel = guiDialog2 -> true;
    private final WaitCursorMgr d_waitCursorMgr;

    public guiDialog(Window window) {
        this(window, "", 0);
    }

    public guiDialog(Window window, String string) {
        this(window, string, 0);
    }

    public guiDialog(Window window, String string, int n) {
        super(window, string, Dialog.DEFAULT_MODALITY_TYPE, Application.getDefaultGraphicsConfiguration());
        this.init(window, n);
        this.d_waitCursorMgr = new WaitCursorMgr(this);
    }

    private void init(Window window, int n) {
        JButton jButton;
        this.d_owner = window;
        this.setResizable(false);
        this.setModal(true);
        this.d_btnPanel = new guiPanel(new FlowLayout(2, 5, 0));
        this.d_btnPanel.setBorder(BorderFactory.createEmptyBorder(6, 7, 11, 6));
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)this.d_btnPanel, "South");
        this.d_cancelListener = new CancelListener();
        this.getRootPane().registerKeyboardAction(this.d_cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(this.d_cancelListener);
        if ((n & 2) != 0) {
            this.d_applyButton = new ApplyBtn(this);
            jButton = this.d_applyButton;
            this.addButton(jButton);
            this.getRootPane().setDefaultButton(jButton);
        }
        if ((n & 1) != 0) {
            this.d_okButton = new OkBtn(this);
            jButton = this.d_okButton;
            this.addButton(jButton);
            this.getRootPane().setDefaultButton(jButton);
        }
        if ((n & 4) != 0) {
            this.d_resetButton = new ResetBtn(this);
            jButton = this.d_resetButton;
            this.addButton(jButton);
        }
        if ((n & 8) != 0) {
            this.d_cancelButton = new CancelBtn(this);
            jButton = this.d_cancelButton;
            this.addButton(jButton);
        }
        if ((n & 0x10) != 0) {
            this.d_closeButton = new CloseBtn(this);
            jButton = this.d_closeButton;
            this.addButton(jButton);
        }
        if ((n & 0x20) != 0) {
            this.d_helpButton = new HelpBtn(this);
            this.addButton(this.d_helpButton);
        }
        this.setSize(0, 0);
    }

    public void setCancelValidator(Predicate<guiDialog> predicate) {
        this.d_validateCancel = predicate;
    }

    public WaitCursorMgr getWaitCursorMgr() {
        return this.d_waitCursorMgr;
    }

    public void beginWaitCursor() {
        this.d_waitCursorMgr.beginWaitCursor();
    }

    public void beginWaitCursor(boolean bl) {
        this.d_waitCursorMgr.beginWaitCursor(bl);
    }

    public void beginWaitCursor(int n) {
        this.d_waitCursorMgr.beginWaitCursor(n);
    }

    public void endWaitCursor() {
        this.d_waitCursorMgr.endWaitCursor();
    }

    public void setDialogComponent(JComponent jComponent) {
        this.getDialogPane().add((Component)jComponent, "Center");
    }

    public void setDialogComponents(JComponent[] jComponentArray, String[] stringArray) {
        assert (jComponentArray != null && stringArray != null);
        assert (jComponentArray.length == stringArray.length);
        JTabbedPane jTabbedPane = new JTabbedPane();
        for (int i = 0; i < jComponentArray.length; ++i) {
            FlowLayout flowLayout = new FlowLayout(0, 12, 12);
            guiPanel guiPanel2 = new guiPanel(flowLayout);
            guiPanel2.add(jComponentArray[i]);
            jTabbedPane.add(stringArray[i], guiPanel2);
        }
        this.setDialogComponent(jTabbedPane);
    }

    public JButton getButton(int n) {
        switch (n) {
            case 2: {
                return this.d_applyButton;
            }
            case 1: {
                return this.d_okButton;
            }
            case 4: {
                return this.d_resetButton;
            }
            case 8: {
                return this.d_cancelButton;
            }
            case 16: {
                return this.d_closeButton;
            }
            case 32: {
                return this.d_helpButton;
            }
        }
        return null;
    }

    public void setButtons(JComponent ... jComponentArray) {
        this.d_btnPanel.removeAll();
        for (int i = 0; i < jComponentArray.length; ++i) {
            this.addButton(jComponentArray[i]);
        }
    }

    public void addButton(JComponent jComponent) {
        JButton jButton = new JButton(Intl.intl("Cancel"));
        Dimension dimension = jButton.getPreferredSize();
        if (jComponent.getPreferredSize().getWidth() < (double)dimension.width) {
            jComponent.setPreferredSize(dimension);
        }
        this.d_btnPanel.add(jComponent);
    }

    public guiPanel getButtonPanel() {
        return this.d_btnPanel;
    }

    public guiPanel getDialogPane() {
        return this.d_dialogPane;
    }

    public void setHelpIDString(String string) {
    }

    public void prepareSize() {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0 || this.d_minimumSizeEnabled) {
            this.pack();
        }
        if (this.d_minimumSizeEnabled) {
            this.setMinimumSize(this.getPreferredSize());
        }
        if (dimension.width != 0 && dimension.height != 0) {
            this.setSize(dimension);
        }
    }

    private void beginShowing() {
        this.d_status = 8;
        this.prepareSize();
        this.setLocationRelativeTo(this.d_owner);
        this.setVisible(true);
    }

    public boolean doModeless() {
        if (this.isVisible()) {
            return false;
        }
        this.setModal(false);
        this.beginShowing();
        return true;
    }

    public int doModal() {
        this.setModal(true);
        this.beginShowing();
        return this.d_status;
    }

    protected void endModal(int n) {
        this.d_status = n;
        this.setVisible(false);
    }

    public void setDisposeAfterModal(boolean bl) {
        this.d_disposeAfterModal = bl;
    }

    public void setMinimumSizeEnabled(boolean bl) {
        if (bl) {
            this.enableEvents(101L);
        } else {
            this.disableEvents(101L);
        }
        this.d_minimumSizeEnabled = bl;
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        this.setSize(dimension);
    }

    public int getStatus() {
        return this.d_status;
    }

    public final boolean validateData() throws Exception {
        throw new Exception("No. You lose.");
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        return !guiUtil.shouldValidateChild(this.d_dialogPane, 0) || this.d_dialogPane.validateData(bl, bl2);
    }

    @Override
    public boolean isModified() {
        return this.d_dialogPane.isModified();
    }

    @Override
    public void setModified(boolean bl) {
        this.d_dialogPane.setModified(bl);
    }

    public void addDlgListener(DlgListener dlgListener) {
        this.d_listeners.add(dlgListener);
    }

    public void removeDlgListener(DlgListener dlgListener) {
        this.d_listeners.remove(dlgListener);
    }

    protected void fireButtonPressed(int n) {
        block8: for (int i = 0; i < this.d_listeners.size(); ++i) {
            DlgListener dlgListener = (DlgListener)this.d_listeners.get(i);
            switch (n) {
                case 1: {
                    dlgListener.okPressed();
                    continue block8;
                }
                case 2: {
                    dlgListener.applyPressed();
                    continue block8;
                }
                case 4: {
                    dlgListener.resetPressed();
                    continue block8;
                }
                case 8: {
                    dlgListener.cancelPressed();
                    continue block8;
                }
                case 16: {
                    dlgListener.closePressed();
                    continue block8;
                }
                case 32: {
                    dlgListener.helpPressed();
                    continue block8;
                }
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.d_disposeAfterModal) {
            this.dispose();
        }
    }

    protected boolean invalidateFld(boolean bl, boolean bl2, guiField guiField2, String string) {
        if (bl) {
            this.showMessageBox(string);
        }
        if (bl2) {
            guiField2.requestFocus();
        }
        return false;
    }

    protected boolean invalidateFormattedFld(boolean bl, boolean bl2, guiFormattedFld guiFormattedFld2, String string) {
        if (bl) {
            this.showMessageBox(string);
        }
        if (bl2) {
            guiFormattedFld2.requestFocus();
        }
        return false;
    }

    protected void showMessageBox(String string) {
        guiDialog.showInvalidEntryMessage(this, string);
    }

    public static void showInvalidEntryMessage(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, Intl.intl("Invalid Entry"), 2);
    }

    protected void requestFocusHack() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                guiDialog.this.requestFocus();
            }
        });
    }

    public void loadPreferredSize(String string, String string2) {
        if (Application.getApp() != null) {
            Object object;
            Dimension dimension = this.getSize();
            boolean bl = false;
            String string3 = Application.getApp().getPreference(string);
            if (string3 != null) {
                try {
                    object = new Integer(string3);
                    dimension.width = (Integer)object;
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = Application.getApp().getPreference(string2)) != null) {
                try {
                    Integer n = new Integer((String)object);
                    dimension.height = n;
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                this.setSize(dimension);
            }
        }
    }

    public void savePreferredSize(String string, String string2) {
        if (Application.getApp() != null) {
            Dimension dimension = this.getSize();
            Application.getApp().setPreference(string, new Integer(dimension.width).toString());
            Application.getApp().setPreference(string2, new Integer(dimension.height).toString());
        }
    }

    public static void main(String[] stringArray) {
        guiDialog guiDialog2 = new guiDialog(null, "Extra Button", 9);
        guiDialog2.setResizable(true);
        guiLabel guiLabel2 = new guiLabel("Hello, Dialog!");
        guiLabel2.setBorder(new LineBorder(Color.GREEN));
        guiLabel2.setPreferredSize(new Dimension(320, 240));
        guiDialog2.getDialogPane().add(guiLabel2);
        guiPanel guiPanel2 = guiDialog2.getButtonPanel();
        guiPanel2.removeAll();
        guiPanel2.setLayout(new GridBagLayout());
        guiPanel2.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(new JButton("Utility..."), Box.createHorizontalGlue(), 1.0, guiDialog2.getButton(1), guiDialog2.getButton(8));
        guiDialog2.getRootPane().setDefaultButton(guiDialog2.getButton(8));
        int n = guiDialog2.doModal();
        System.out.println(n);
        guiDialog2 = new guiDialog(null, "No Frills", 11);
        guiDialog2.getDialogPane().add(guiLabel2);
        n = guiDialog2.doModal();
        System.out.println(n);
    }

    public static class HelpBtn
    extends JButton {
        private guiDialog d_dlg;

        public HelpBtn(guiDialog guiDialog2) {
            super(Intl.intl("Help"));
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    d_dlg.fireButtonPressed(32);
                }
            });
        }
    }

    public static class CloseBtn
    extends JButton {
        private guiDialog d_dlg;

        public CloseBtn(guiDialog guiDialog2) {
            super(Intl.intl("Close"));
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((CloseBtn)this).d_dlg.d_status = 16;
                    d_dlg.fireButtonPressed(16);
                    d_dlg.setVisible(false);
                }
            });
        }
    }

    public static class CancelBtn
    extends JButton {
        private guiDialog d_dlg;

        public CancelBtn(guiDialog guiDialog2) {
            super(Intl.intl("Cancel"));
            this.d_dlg = guiDialog2;
            this.addActionListener(this.d_dlg.d_cancelListener);
        }
    }

    public static class ResetBtn
    extends JButton {
        private guiDialog d_dlg;

        public ResetBtn(guiDialog guiDialog2) {
            super("Reset");
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    d_dlg.fireButtonPressed(4);
                }
            });
        }
    }

    public static class ApplyBtn
    extends JButton {
        private guiDialog d_dlg;

        public ApplyBtn(guiDialog guiDialog2) {
            super(Intl.intl("Apply"));
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (d_dlg.validateData(true, true)) {
                        ((ApplyBtn)this).d_dlg.d_status = 2;
                        d_dlg.fireButtonPressed(2);
                    }
                }
            });
        }
    }

    public static class OkBtn
    extends JButton {
        private guiDialog d_dlg;

        public OkBtn(guiDialog guiDialog2) {
            super(Intl.intl("OK"));
            this.d_dlg = guiDialog2;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (d_dlg.validateData(true, true)) {
                        ((OkBtn)this).d_dlg.d_status = 1;
                        d_dlg.fireButtonPressed(1);
                        d_dlg.setVisible(false);
                    }
                }
            });
        }
    }

    private class CancelListener
    extends WindowAdapter
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel(true);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancel(false);
        }

        private void cancel(boolean bl) {
            if (!guiDialog.this.d_validateCancel.test(guiDialog.this)) {
                return;
            }
            guiDialog.this.d_status = 8;
            guiDialog.this.fireButtonPressed(8);
            if (bl) {
                guiDialog.this.setVisible(false);
            }
        }
    }
}

