/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class UnitDoubleFormat
extends AFormat<UnitDouble>
implements IObserver,
IObservable {
    private IUnitSrc d_unit;
    private final boolean d_formatWithUnit;
    private ObservableProxy d_observableHelper;

    public UnitDoubleFormat(IUnitSrc iUnitSrc) {
        this(iUnitSrc, true);
    }

    public UnitDoubleFormat(IUnitSrc iUnitSrc, boolean bl) {
        this.d_unit = iUnitSrc;
        this.d_unit.addObserver(this, true);
        this.d_formatWithUnit = bl;
        this.d_observableHelper = new ObservableProxy(this);
    }

    @Override
    public UnitDoubleFormat clone() {
        UnitDoubleFormat unitDoubleFormat = (UnitDoubleFormat)super.clone();
        unitDoubleFormat.resetObeservableHelper();
        unitDoubleFormat.d_unit.addObserver(unitDoubleFormat, true);
        return unitDoubleFormat;
    }

    public UnitDoubleFormat newFormat(IUnitSrc iUnitSrc) {
        return this.newFormat(iUnitSrc, Collections.EMPTY_MAP);
    }

    public UnitDoubleFormat newFormat(IUnitSrc iUnitSrc, Map<String, UnitDouble> map) {
        UnitDoubleFormat unitDoubleFormat = this.clone();
        unitDoubleFormat.clearAliases();
        for (Map.Entry<String, UnitDouble> entry : map.entrySet()) {
            unitDoubleFormat.alias(entry.getValue(), entry.getKey());
        }
        unitDoubleFormat.d_unit.deleteObserver(unitDoubleFormat);
        unitDoubleFormat.d_unit = iUnitSrc;
        unitDoubleFormat.d_unit.addObserver(unitDoubleFormat, true);
        return unitDoubleFormat;
    }

    @Override
    protected UnitDouble parse(String string) throws ParseException {
        Unit unit = this.d_unit.getUnit();
        return Global.parseUnitDouble(string, unit);
    }

    @Override
    protected String toString(UnitDouble unitDouble) {
        Unit unit = this.d_formatWithUnit && this.d_unit != null ? this.d_unit.getUnit() : unitDouble.getUnit();
        return Global.format(unitDouble.getValue(unit), unit);
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        this.d_observableHelper.setChanged(true);
    }

    @Override
    public void addObserver(IObserver iObserver, boolean bl) {
        this.d_observableHelper.addObserver(iObserver, bl);
    }

    @Override
    public void deleteObserver(IObserver iObserver) {
        this.d_observableHelper.deleteObserver(iObserver);
    }

    public void resetObeservableHelper() {
        this.d_observableHelper = new ObservableProxy(this);
    }

    public IUnitSrc getUnitType() {
        return this.d_unit;
    }

    public boolean getFormatWithUnit() {
        return this.d_formatWithUnit;
    }
}

