/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.format.FormatUtil;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class UDListFormat
extends AFormat<UnitDouble[]>
implements IObservable,
IObserver {
    private final IUnitSrc d_displayUnit;
    private final int d_minLen;
    private final int d_maxLen;
    private final ObservableProxy d_observable;

    public UDListFormat(IUnitSrc iUnitSrc) {
        this(iUnitSrc, 0, Integer.MAX_VALUE);
    }

    public UDListFormat(IUnitSrc iUnitSrc, int n, int n2) {
        this.d_minLen = n;
        this.d_maxLen = n2;
        this.d_displayUnit = iUnitSrc;
        this.d_displayUnit.addObserver(this, true);
        this.d_observable = new ObservableProxy(this);
    }

    @Override
    public void addObserver(IObserver iObserver, boolean bl) {
        this.d_observable.addObserver(iObserver, bl);
    }

    @Override
    public void deleteObserver(IObserver iObserver) {
        this.d_observable.deleteObserver(iObserver);
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        this.d_observable.setChanged(true);
    }

    @Override
    protected UnitDouble[] parse(String string) throws ParseException {
        Unit unit = this.d_displayUnit.getUnit();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        char c = UDListFormat.getCoordSeparator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " " + c);
        ArrayList<String> arrayList2 = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            arrayList2.add(stringTokenizer.nextToken().trim());
        }
        int n = 0;
        while (n < arrayList2.size()) {
            Object object;
            String string2 = (String)arrayList2.get(n);
            if (n < arrayList2.size() - 1) {
                object = (String)arrayList2.get(n + 1);
                String string3 = string2 + " " + (String)object;
                try {
                    UnitDouble unitDouble = Global.parseUnitDouble(string3, unit);
                    n += 2;
                    arrayList.add(unitDouble);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            object = Global.parseUnitDouble(string2, unit);
            ++n;
            arrayList.add(object);
        }
        if (arrayList.size() < this.d_minLen || arrayList.size() > this.d_maxLen) {
            String string4 = FormatUtil.formatLengthMessage(this.d_minLen, this.d_maxLen);
            throw new ParseException(string4, 0);
        }
        return arrayList.toArray(new UnitDouble[arrayList.size()]);
    }

    @Override
    protected String toString(UnitDouble[] unitDoubleArray) {
        Unit unit = this.d_displayUnit.getUnit();
        StringBuffer stringBuffer = new StringBuffer();
        char c = UDListFormat.getCoordSeparator();
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(c + " ");
            }
            UnitDouble unitDouble = unitDoubleArray[i];
            Unit unit2 = unit != null ? unit : unitDouble.getUnit();
            stringBuffer.append(Global.format(unitDouble.getValue(unit2), unit2));
        }
        return stringBuffer.toString();
    }

    private static char getCoordSeparator() {
        char c = FormatUtil.getDecimalSeparator();
        return c == ',' ? (char)';' : ',';
    }
}

