/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.ParseException;
import java.util.StringTokenizer;
import thunderheadeng.gui.format.AFormat;
import thunderheadeng.gui.format.FormatUtil;
import thunderheadeng.util.Global;

public class DoubleListFormat
extends AFormat<double[]> {
    private final int d_minLen;
    private final int d_maxLen;

    public DoubleListFormat() {
        this(0, Integer.MAX_VALUE);
    }

    public DoubleListFormat(int n, int n2) {
        this.d_minLen = n;
        this.d_maxLen = n2;
    }

    @Override
    protected double[] parse(String string) throws ParseException {
        String string2;
        char c = DoubleListFormat.getCoordSeparator();
        StringTokenizer stringTokenizer = new StringTokenizer(string, c + " ");
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken().trim();
            dArray[n++] = Global.parseDouble(string2);
        }
        if (dArray.length < this.d_minLen || dArray.length > this.d_maxLen) {
            string2 = FormatUtil.formatLengthMessage(this.d_minLen, this.d_maxLen);
            throw new ParseException(string2, 0);
        }
        return dArray;
    }

    @Override
    protected String toString(double[] dArray) {
        char c = DoubleListFormat.getCoordSeparator();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(c + " ");
            }
            stringBuffer.append(Global.format(dArray[i]));
        }
        return stringBuffer.toString();
    }

    private static char getCoordSeparator() {
        char c = FormatUtil.getDecimalSeparator();
        return c == ',' ? (char)';' : ',';
    }
}

