/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import thunderheadeng.gui.format.IValueFormat;
import thunderheadeng.util.theUtil;

public abstract class AFormat<T>
extends Format
implements IValueFormat<T>,
Cloneable {
    private Map<String, T> d_aliases = AFormat.newAliasMap();

    protected abstract T parse(String var1) throws ParseException;

    protected abstract String toString(T var1);

    @Override
    public Format get() {
        return this;
    }

    private static <T> Map<String, T> newAliasMap() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("", null);
        return linkedHashMap;
    }

    @Override
    public AFormat<T> clone() {
        AFormat aFormat = (AFormat)super.clone();
        aFormat.d_aliases = new LinkedHashMap<String, T>(this.d_aliases);
        return aFormat;
    }

    public Map<String, T> getAliases() {
        return Collections.unmodifiableMap(this.d_aliases);
    }

    public void setAliases(Map<String, T> map) {
        this.d_aliases = AFormat.newAliasMap();
        this.d_aliases.putAll(map);
    }

    @Override
    public void alias(T t, String ... stringArray) {
        for (String string : stringArray) {
            this.d_aliases.put(string, t);
        }
    }

    @Override
    public void removeAlias(String string) {
        if (string.isEmpty()) {
            this.d_aliases.put(string, null);
            return;
        }
        this.d_aliases.remove(string);
    }

    @Override
    public T getAliasedValue(String string) {
        return this.d_aliases.get(string);
    }

    public void clearAliases() {
        this.d_aliases = AFormat.newAliasMap();
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string = null;
        for (Map.Entry<String, T> entry : this.d_aliases.entrySet()) {
            if (theUtil.equal(object, entry.getValue()) && !theUtil.equal(string = entry.getKey(), "")) break;
        }
        if (string == null) {
            string = this.toString(object);
        }
        stringBuffer.append(string);
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(string.length());
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        if (this.d_aliases.containsKey(string = string.trim())) {
            return this.d_aliases.get(string);
        }
        return this.parse(string);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            String string2 = string.substring(parsePosition.getIndex()).trim();
            if (this.d_aliases.containsKey(string2)) {
                return this.d_aliases.get(string2);
            }
            T t = this.parse(string2);
            parsePosition.setIndex(string.length());
            return t;
        }
        catch (ParseException parseException) {
            parsePosition.setErrorIndex(0);
            return null;
        }
    }
}

