/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.gui.dialogs;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public abstract class AFindDlg<T, D>
extends guiDialog {
    private static Deque<String> QUERY_HISTORY = new ArrayDeque<String>();
    private Collection<? extends T> d_results;
    private Iterator<? extends T> d_iterator;
    private D d_domain;

    public AFindDlg(Window window, D d) {
        super(window, Intl.intl("Find"), 16);
        this.d_domain = d;
        this.d_results = Collections.emptyList();
        guiComboBox<String> guiComboBox2 = new guiComboBox<String>();
        Dimension dimension = guiComboBox2.getPreferredSize();
        guiComboBox2.setPreferredSize(new Dimension(230, dimension.height));
        guiComboBox2.setEditable(true);
        guiComboBox2.setItems((Collection<String>)QUERY_HISTORY);
        guiComboBox2.getEditor().selectAll();
        guiComboBox2.requestFocusInWindow();
        guiPanel guiPanel2 = new guiPanel(new FlowLayout(0, 0, 0));
        guiLabel guiLabel2 = new guiLabel("MMMMMMMMMMMM");
        guiPanel2.setPreferredSize(guiLabel2.getPreferredSize());
        guiPanel2.add(guiLabel2);
        guiLabel2.setText("");
        JButton jButton = new JButton(Intl.intl("Find/Next"));
        jButton.addActionListener(actionEvent -> this.perform(guiComboBox2, guiLabel2, ActionAfterQuery.FINDNEXT));
        JButton jButton2 = new JButton(Intl.intl("Select All"));
        jButton2.addActionListener(actionEvent -> this.perform(guiComboBox2, guiLabel2, ActionAfterQuery.SELECTALL));
        this.buildPanel(guiComboBox2, guiPanel2, jButton, jButton2);
    }

    private void buildPanel(guiComboBox<String> guiComboBox2, guiPanel guiPanel2, JButton jButton, JButton jButton2) {
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Find:"), guiComboBox2);
        guiPanel guiPanel3 = new guiPanel(new FlowLayout(2, 0, 0));
        guiPanel3.add(jButton);
        guiPanel3.add(Box.createHorizontalStrut(12));
        guiPanel3.add(jButton2);
        gridBagHelper.addRow(new Object[]{guiPanel3, 0, GridBagHelper.Anchor.RIGHT});
        gridBagHelper.addRow(guiPanel2, 0);
        this.getRootPane().setDefaultButton(jButton);
        gridBagHelper.finalizeRows();
    }

    private void performQuery(guiComboBox<String> guiComboBox2, String string) {
        this.d_results = this.find(string);
        this.d_iterator = this.d_results.iterator();
        AFindDlg.addToQueryHistory(guiComboBox2, string);
    }

    private void updateQueryAndWrapSearch(guiComboBox<String> guiComboBox2, guiLabel guiLabel2) {
        String string;
        guiLabel2.setText("");
        if (guiComboBox2.isModified() || this.d_results.isEmpty()) {
            string = guiComboBox2.getSelectedItem();
            if (string == null) {
                string = "";
            }
            String string2 = string.trim();
            guiLabel2.setText(Intl.intl("Searching for \"" + string2 + "\""));
            this.performQuery(guiComboBox2, string);
            guiComboBox2.setModified(false);
        }
        string = String.format(Intl.intl("%d Results"), this.d_results.size());
        if (this.d_results.size() == 1) {
            string = string.replace("Results", "Result");
        }
        guiLabel2.setText(string);
        if (!this.d_results.isEmpty() && !this.d_iterator.hasNext()) {
            this.d_iterator = this.d_results.iterator();
            guiLabel2.setText(Intl.intl("Search Wrapped"));
        }
    }

    private static void addToQueryHistory(guiComboBox<String> guiComboBox2, String string) {
        if (string != null && !string.trim().isEmpty()) {
            String string2 = string.trim();
            QUERY_HISTORY.addFirst(string2);
            while (5 < QUERY_HISTORY.size()) {
                QUERY_HISTORY.removeLast();
            }
            guiComboBox2.setItems((Collection<String>)QUERY_HISTORY);
        }
    }

    public abstract void perform(guiComboBox<String> var1, guiLabel var2, ActionAfterQuery var3);

    protected void run(guiComboBox<String> guiComboBox2, guiLabel guiLabel2, ActionAfterQuery actionAfterQuery) {
        this.updateQueryAndWrapSearch(guiComboBox2, guiLabel2);
        if (actionAfterQuery == ActionAfterQuery.FINDNEXT) {
            this.selectNext();
        } else if (actionAfterQuery == ActionAfterQuery.SELECTALL) {
            this.selectAll();
        }
    }

    protected abstract Collection<T> find(String var1);

    protected abstract void selectNext();

    protected abstract void selectAll();

    protected final Collection<? extends T> getSelection() {
        return this.d_results;
    }

    protected Iterator<? extends T> getIterator() {
        return this.d_iterator;
    }

    protected final D getDomain() {
        return this.d_domain;
    }

    protected static enum ActionAfterQuery {
        FINDNEXT,
        SELECTALL;

    }
}

